/*
 * Decompiled with CFR 0.152.
 */
package innoval.mailer;

import innoval.mailer.ColorCodeList;
import innoval.mailer.NoteList;
import innoval.mailer.PopFileProcedure;
import innoval.mailer.SendItem;
import innoval.mailer.jstreet;
import java.io.File;
import java.util.Vector;
import jclass.util.JCString;

public class FolderIndexItem {
    public long size = 0L;
    public int colorcode = 0;
    public boolean attach = false;
    public boolean checked = false;
    public boolean opened = false;
    public boolean sent = false;
    private String popname = "";
    public String popdir = "";
    public String type = "";
    public String status = "";
    public String from = "";
    public String to = "";
    public String subject = "";
    public String date = "";
    public String daterec = "";
    public String followup = "";
    public String notes = "";

    public FolderIndexItem() {
        this.checked = false;
    }

    public FolderIndexItem(PopFileProcedure pop) {
        this.from = pop.getHeader("FROM");
        this.to = pop.getHeader("TO");
        this.subject = pop.getHeader("SUBJECT");
        this.date = pop.getHeader("DATE");
        this.daterec = SendItem.getPopDate();
        this.size = pop.getPopFile().length();
        this.sent = pop.isHeader("X-$SENT-MESSAGE");
        this.attach = this.checkContentType(pop.getHeader("CONTENT-TYPE"));
        this.followup = new String("");
        this.notes = new String("");
        this.checked = false;
        this.opened = this.sent;
        this.colorcode = 0;
        this.fixSubject();
    }

    public void setPopName(String popname) {
        this.popname = new String(popname);
    }

    public String getPopName() {
        return this.popname;
    }

    private void fixSubject() {
        this.subject = new String(this.subject.replace('[', '(').replace(']', ')'));
    }

    public static String fixSlashes(String text) {
        if (text.indexOf(92) > 0) {
            StringBuffer sb = new StringBuffer(100);
            char[] ch = text.toCharArray();
            for (int i = 0; i < ch.length; ++i) {
                if (ch[i] == '\\') {
                    sb.append("\\\\");
                    continue;
                }
                sb.append(ch[i]);
            }
            text = sb.toString();
        }
        return text;
    }

    public FolderIndexItem copy() {
        FolderIndexItem item = new FolderIndexItem();
        item.size = this.size;
        item.colorcode = this.colorcode;
        item.attach = this.attach;
        item.checked = this.checked;
        item.opened = this.opened;
        item.sent = this.sent;
        item.setPopName(this.popname);
        item.popdir = new String(this.popdir);
        item.type = new String(this.type);
        item.status = new String(this.status);
        item.from = new String(this.from);
        item.to = new String(this.to);
        item.subject = new String(this.subject);
        item.date = new String(this.date);
        item.daterec = new String(this.daterec);
        item.followup = new String(this.followup);
        item.notes = new String(this.notes);
        return item;
    }

    public void update(FolderIndexItem item) {
        this.colorcode = item.colorcode;
        this.attach = item.attach;
        this.checked = item.checked;
        this.opened = item.opened;
        this.sent = item.sent;
        this.popname = new String(item.popname);
        this.type = new String(item.type);
        this.status = new String(item.status);
        this.from = new String(item.from);
        this.to = new String(item.to);
        this.subject = new String(item.subject);
        this.date = new String(item.date);
        this.daterec = new String(item.daterec);
        this.followup = new String(item.followup);
        this.notes = new String(item.notes);
        this.fixSubject();
    }

    public boolean hasNotes() {
        boolean ret_code = false;
        if (this.notes != null && this.notes.length() > 0) {
            ret_code = true;
        }
        return ret_code;
    }

    public String getNotes() {
        String text = "";
        if (this.notes != null && this.notes.length() > 0) {
            text = new String(this.notes.replace('\u0005', '\n').replace('\u0006', '\r'));
        }
        return text;
    }

    public void setNotes(String notes) {
        this.notes = new String(notes.replace('\n', '\u0005').replace('\r', '\u0006'));
    }

    public boolean getAttach() {
        return this.attach;
    }

    public void setAttach(boolean val) {
        this.attach = val;
    }

    public boolean resolveValue(char index, String val) {
        boolean ret_code = false;
        switch (index) {
            case 'V': {
                this.type = val;
                break;
            }
            case 'C': {
                this.colorcode = Integer.valueOf(val);
                break;
            }
            case 'F': {
                this.from = val;
                break;
            }
            case 'T': {
                this.to = val;
                break;
            }
            case 'S': {
                this.subject = val;
                this.fixSubject();
                break;
            }
            case 'D': {
                this.date = val;
                break;
            }
            case 'E': {
                this.daterec = val;
                break;
            }
            case 'Z': {
                this.size = Integer.valueOf(val).intValue();
                break;
            }
            case 'N': {
                this.sent = Boolean.valueOf(val);
                break;
            }
            case 'A': {
                this.attach = Boolean.valueOf(val);
                break;
            }
            case 'X': {
                this.status = val;
                break;
            }
            case 'U': {
                this.followup = val;
                break;
            }
            case 'O': {
                this.opened = Boolean.valueOf(val);
                break;
            }
            case 'I': {
                this.notes = val;
            }
            case '-': {
                break;
            }
            default: {
                ret_code = true;
            }
        }
        return ret_code;
    }

    public void updateItem(PopFileProcedure pop) {
        this.popname = pop.getPopFile().getName();
        this.from = pop.getHeader("FROM");
        this.to = pop.getHeader("TO");
        this.subject = pop.getHeader("SUBJECT");
        this.date = pop.getHeader("DATE");
        this.size = pop.getPopFile().length();
        this.attach = this.checkContentType(pop.getHeader("CONTENT-TYPE"));
        this.fixSubject();
    }

    public boolean checkContentType(String text) {
        boolean ret_code = false;
        if (text != null && text.trim().length() > 0) {
            text = new String(text.toLowerCase().trim());
            while (text.length() > 0 && text.charAt(0) == '\"') {
                text = new String(text.substring(1));
            }
            if (!(text.startsWith("text") || text.startsWith("multipart/digest") || text.startsWith("message/"))) {
                ret_code = true;
            } else if (text.startsWith("message/partial")) {
                ret_code = true;
            }
        }
        return ret_code;
    }

    public String toString(boolean vfolder) {
        String x = String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(ColorCodeList.getCodeImage(this.colorcode)).concat(String.valueOf(","))).concat(String.valueOf(this.noteIndicatorImage()))).concat(String.valueOf(FolderIndexItem.fixSlashes(this.subject.replace(',', ' '))))).concat(String.valueOf(","))).concat(String.valueOf(this.from.replace(',', ';')))).concat(String.valueOf(","))).concat(String.valueOf(FolderIndexItem.formatToAddress(this.to).replace(',', ';')))).concat(String.valueOf(","))).concat(String.valueOf(this.date.replace(',', ' ')))).concat(String.valueOf(","))).concat(String.valueOf(this.daterec.replace(',', ' ')))).concat(String.valueOf(","))).concat(String.valueOf(this.size))).concat(String.valueOf(","))).concat(String.valueOf(this.popname));
        if (vfolder) {
            String dir = this.getDirName(this.popdir);
            x = new String(String.valueOf(String.valueOf(x).concat(String.valueOf(","))).concat(String.valueOf(dir)));
        }
        return x;
    }

    public String getDirName() {
        return this.getDirName(this.popdir);
    }

    public String getDirName(String dir) {
        int spot = dir.lastIndexOf(File.separator);
        String name = "";
        name = spot >= 0 ? new String(dir.substring(spot + 1)) : new String(dir);
        return name;
    }

    public void updateListItem(NoteList notelist, Vector vector) {
        int i = 1;
        vector.setElementAt(JCString.parse(notelist, ColorCodeList.getCodeImage(this.colorcode)), i++);
        vector.setElementAt(JCString.parse(notelist, String.valueOf(this.noteIndicatorImage()).concat(String.valueOf(FolderIndexItem.fixSlashes(this.subject.replace(',', ' '))))), i++);
        vector.setElementAt(this.from.replace(',', ';'), i++);
        vector.setElementAt(FolderIndexItem.formatToAddress(this.to).replace(',', ';'), i++);
        vector.setElementAt(this.date.replace(',', ' '), i++);
        vector.setElementAt(this.daterec.replace(',', ' '), i++);
        vector.setElementAt(String.valueOf("").concat(String.valueOf(this.size)), i++);
        vector.setElementAt(this.popname, i);
    }

    public void addListItem(NoteList notelist, Vector vector) {
        vector.addElement(JCString.parse(notelist, ColorCodeList.getCodeImage(this.colorcode)));
        vector.addElement(JCString.parse(notelist, String.valueOf(this.noteIndicatorImage()).concat(String.valueOf(FolderIndexItem.fixSlashes(this.subject.replace(',', ' '))))));
        vector.addElement(this.from.replace(',', ';'));
        vector.addElement(FolderIndexItem.formatToAddress(this.to).replace(',', ';'));
        vector.addElement(this.date.replace(',', ' '));
        vector.addElement(this.daterec.replace(',', ' '));
        vector.addElement(String.valueOf("").concat(String.valueOf(this.size)));
        vector.addElement(this.popname);
    }

    public String noteIndicatorImage() {
        String image = "";
        if (this.attach && this.hasNotes()) {
            image = new String(String.valueOf(String.valueOf("[img=").concat(String.valueOf(jstreet.NOTE_BOTH))).concat(String.valueOf("]")));
        } else if (this.attach) {
            image = new String(String.valueOf(String.valueOf("[img=").concat(String.valueOf(jstreet.NOTE_ATTACH))).concat(String.valueOf("]")));
        } else if (this.hasNotes()) {
            image = new String(String.valueOf(String.valueOf("[img=").concat(String.valueOf(jstreet.NOTE_STICKY))).concat(String.valueOf("]")));
        }
        return image;
    }

    public static String formatToAddress(String addr) {
        String text = null;
        text = addr.length() < 300 ? new String(addr) : new String(String.valueOf(addr.substring(0, 300)).concat(String.valueOf("...")));
        return text;
    }

    public String writeString() {
        String x = null;
        x = new String(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("P:").concat(String.valueOf(this.popname))).concat(String.valueOf("\n"))).concat(String.valueOf("C:"))).concat(String.valueOf(this.colorcode))).concat(String.valueOf("\n"))).concat(String.valueOf("V:"))).concat(String.valueOf(this.type))).concat(String.valueOf("\n"))).concat(String.valueOf("F:"))).concat(String.valueOf(this.from))).concat(String.valueOf("\n"))).concat(String.valueOf("T:"))).concat(String.valueOf(this.to))).concat(String.valueOf("\n"))).concat(String.valueOf("S:"))).concat(String.valueOf(this.subject))).concat(String.valueOf("\n"))).concat(String.valueOf("D:"))).concat(String.valueOf(this.date))).concat(String.valueOf("\n"))).concat(String.valueOf("E:"))).concat(String.valueOf(this.daterec))).concat(String.valueOf("\n"))).concat(String.valueOf("Z:"))).concat(String.valueOf(this.size))).concat(String.valueOf("\n"))).concat(String.valueOf("A:"))).concat(String.valueOf(this.attach))).concat(String.valueOf("\n"))).concat(String.valueOf("N:"))).concat(String.valueOf(this.sent))).concat(String.valueOf("\n"))).concat(String.valueOf("X:"))).concat(String.valueOf(this.status))).concat(String.valueOf("\n"))).concat(String.valueOf("U:"))).concat(String.valueOf(this.followup))).concat(String.valueOf("\n"))).concat(String.valueOf("O:"))).concat(String.valueOf(this.opened))).concat(String.valueOf("\n"))).concat(String.valueOf("I:"))).concat(String.valueOf(this.notes))).concat(String.valueOf("\n")));
        return x;
    }
}

