/*
 * Decompiled with CFR 0.152.
 */
package innoval.mailer;

import innoval.mail.Imap4Exception;
import innoval.mailer.ImapMailbox;
import innoval.mailer.MsgBox;
import innoval.mailer.RetrieveThread;
import innoval.mailer.jstreet;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;

public class ImapMailboxCheck
extends Dialog
implements ActionListener,
KeyListener,
ItemListener {
    static final int NEW = 1;
    static final int UNSEEN = 2;
    private Frame frame = null;
    private ImapMailbox mailbox = null;
    private RetrieveThread retrthread = null;
    private int[] sel = null;
    private Label text = null;
    private Label stopLabel = null;
    private Checkbox checkAll = null;
    private Checkbox checkNew = null;
    private Checkbox checkUnseen = null;
    private Checkbox checkTop10 = null;
    private Checkbox checkBot10 = null;
    private Checkbox checkUser = null;
    private Button okButton;
    private Button cancelButton;
    private TextField start;
    private TextField stop;

    public ImapMailboxCheck(Frame frame, ImapMailbox mailbox) {
        super(frame, String.valueOf(String.valueOf("Open Folder [").concat(String.valueOf(mailbox.getName()))).concat(String.valueOf("]")), true);
        this.frame = frame;
        this.mailbox = mailbox;
        this.initWindow();
        this.enableEvents(64L);
        this.show();
    }

    public int[] getMessages() {
        return this.sel;
    }

    public void initWindow() {
        GridBagLayout grid = new GridBagLayout();
        int[] rowHeights = new int[]{5, 15, 15, 15, 5, 120, 20, 20, 5};
        int[] columnWidths = new int[]{5, 60, 5, 60, 5, 20, 80, 5};
        double[] rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.0};
        double[] columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.0};
        grid.rowHeights = rowHeights;
        grid.columnWidths = columnWidths;
        grid.rowWeights = rowWeights;
        grid.columnWeights = columnWeights;
        GridBagConstraints con = new GridBagConstraints();
        Label label = new Label("Total Messages:", 2);
        this.add(label);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 1;
        con.gridwidth = 3;
        grid.setConstraints(label, con);
        label = new Label(String.valueOf("").concat(String.valueOf(this.mailbox.getMessageCount())), 2);
        this.add(label);
        jstreet.reset(con);
        con.gridx = 5;
        con.gridy = 1;
        grid.setConstraints(label, con);
        label = new Label("New Messages:", 2);
        this.add(label);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 2;
        con.gridwidth = 3;
        grid.setConstraints(label, con);
        label = new Label(String.valueOf("").concat(String.valueOf(this.mailbox.getNewCount())), 2);
        this.add(label);
        jstreet.reset(con);
        con.gridx = 5;
        con.gridy = 2;
        grid.setConstraints(label, con);
        label = new Label("Unseen Messages:", 2);
        this.add(label);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 3;
        con.gridwidth = 3;
        grid.setConstraints(label, con);
        boolean unseen = false;
        if (this.mailbox.getUnseenStart() > 0) {
            unseen = true;
        }
        String val = "No";
        if (unseen) {
            val = new String("Yes");
        }
        label = new Label(val, 2);
        this.add(label);
        jstreet.reset(con);
        con.gridx = 5;
        con.gridy = 3;
        grid.setConstraints(label, con);
        Panel panel = this.setupCheckPanel();
        this.add(panel);
        jstreet.reset(con);
        con.gridx = 0;
        con.gridy = 5;
        con.gridwidth = 8;
        grid.setConstraints(panel, con);
        this.text = new Label("");
        this.add(this.text);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 6;
        con.gridwidth = 6;
        grid.setConstraints(this.text, con);
        this.okButton = new Button("OK");
        this.okButton.addActionListener(this);
        this.okButton.addKeyListener(this);
        if (this.mailbox.getMessageCount() == 0) {
            this.okButton.setEnabled(false);
        }
        this.add(this.okButton);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 7;
        grid.setConstraints(this.okButton, con);
        this.cancelButton = new Button("Cancel");
        this.cancelButton.addActionListener(this);
        this.cancelButton.addKeyListener(this);
        this.add(this.cancelButton);
        jstreet.reset(con);
        con.gridx = 3;
        con.gridy = 7;
        grid.setConstraints(this.cancelButton, con);
        this.setLayout(grid);
        this.pack();
        this.setResizable(false);
        jstreet.centerDialog(this, null);
    }

    private Panel setupCheckPanel() {
        Panel panel = new Panel();
        GridBagLayout grid = new GridBagLayout();
        int[] rowHeights = new int[]{20, 20, 20, 20, 20, 20, 20};
        int[] columnWidths = new int[]{15, 60, 5, 30, 30};
        double[] rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.0};
        double[] columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.0};
        grid.rowHeights = rowHeights;
        grid.columnWidths = columnWidths;
        grid.rowWeights = rowWeights;
        grid.columnWeights = columnWeights;
        GridBagConstraints con = new GridBagConstraints();
        CheckboxGroup group = new CheckboxGroup();
        this.checkAll = new Checkbox("Display All Messages", group, true);
        this.checkAll.addKeyListener(this);
        this.checkAll.addItemListener(this);
        if (this.mailbox.getMessageCount() == 0) {
            this.checkAll.setEnabled(false);
        }
        panel.add(this.checkAll);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 0;
        con.gridwidth = 4;
        grid.setConstraints(this.checkAll, con);
        this.checkNew = new Checkbox("Display Only New Messages", group, false);
        this.checkNew.addKeyListener(this);
        this.checkNew.addItemListener(this);
        if (this.mailbox.getNewCount() == 0) {
            this.checkNew.setEnabled(false);
        }
        panel.add(this.checkNew);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 1;
        con.gridwidth = 4;
        grid.setConstraints(this.checkNew, con);
        this.checkUnseen = new Checkbox("Display Only Unseen Messages", group, false);
        this.checkUnseen.addKeyListener(this);
        this.checkUnseen.addItemListener(this);
        if (this.mailbox.getUnseenStart() == 0) {
            this.checkUnseen.setEnabled(false);
        }
        panel.add(this.checkUnseen);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 2;
        con.gridwidth = 4;
        grid.setConstraints(this.checkUnseen, con);
        this.checkTop10 = new Checkbox("Display The 10 Most Recent Messages", group, false);
        this.checkTop10.addKeyListener(this);
        this.checkTop10.addItemListener(this);
        if (this.mailbox.getMessageCount() < 11) {
            this.checkTop10.setEnabled(false);
        }
        panel.add(this.checkTop10);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 3;
        con.gridwidth = 4;
        grid.setConstraints(this.checkTop10, con);
        this.checkBot10 = new Checkbox("Display The 10 Oldest Messages", group, false);
        this.checkBot10.addKeyListener(this);
        this.checkBot10.addItemListener(this);
        if (this.mailbox.getMessageCount() < 11) {
            this.checkBot10.setEnabled(false);
        }
        panel.add(this.checkBot10);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 4;
        con.gridwidth = 4;
        grid.setConstraints(this.checkBot10, con);
        this.checkUser = new Checkbox("Display Messages Starting At", group, false);
        this.checkUser.addItemListener(this);
        this.checkUser.addKeyListener(this);
        if (this.mailbox.getMessageCount() < 2) {
            this.checkUser.setEnabled(false);
        }
        panel.add(this.checkUser);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 5;
        grid.setConstraints(this.checkUser, con);
        this.start = new TextField("1");
        this.start.setEnabled(false);
        this.start.addKeyListener(this);
        panel.add(this.start);
        jstreet.reset(con);
        con.gridx = 3;
        con.gridy = 5;
        grid.setConstraints(this.start, con);
        this.stopLabel = new Label("Ending At", 2);
        this.stopLabel.setEnabled(false);
        panel.add(this.stopLabel);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 6;
        grid.setConstraints(this.stopLabel, con);
        this.stop = new TextField(String.valueOf("").concat(String.valueOf(this.mailbox.getMessageCount())));
        this.stop.setEnabled(false);
        this.stop.addKeyListener(this);
        panel.add(this.stop);
        jstreet.reset(con);
        con.gridx = 3;
        con.gridy = 6;
        grid.setConstraints(this.stop, con);
        panel.setLayout(grid);
        return panel;
    }

    public void itemStateChanged(ItemEvent e) {
        boolean val = false;
        if (e.getSource() == this.checkUser) {
            val = true;
        }
        this.start.setEnabled(val);
        this.stop.setEnabled(val);
        this.stopLabel.setEnabled(val);
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            Button evt = this.okButton;
            if (e.getSource() == this.cancelButton) {
                evt = this.cancelButton;
            }
            ActionEvent ae = new ActionEvent(evt, 1001, "");
            this.actionPerformed(ae);
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            if (this.processSelection()) {
                this.closeWindow();
            }
        } else if (e.getSource() == this.cancelButton) {
            this.closeWindow();
        }
    }

    private boolean processSelection() {
        int i;
        boolean ret_code = true;
        int total = this.mailbox.getMessageCount();
        int cnt = 0;
        int[] sel = new int[total];
        if (this.checkAll.getState()) {
            i = 1;
            while (i <= total) {
                sel[cnt++] = i++;
            }
        } else if (this.checkNew.getState()) {
            i = total - this.mailbox.getNewCount() + 1;
            while (i <= total) {
                sel[cnt++] = i++;
            }
        } else if (this.checkUnseen.getState()) {
            ret_code = false;
            this.text.setText("Retrieving a list of UNSEEN messages...");
            this.retrieveMessages(2);
        } else if (this.checkTop10.getState()) {
            i = total - 9;
            while (i <= total) {
                sel[cnt++] = i++;
            }
        } else if (this.checkBot10.getState()) {
            i = 1;
            while (i < 11) {
                sel[cnt++] = i++;
            }
        } else if (this.checkUser.getState()) {
            int istart = ImapMailboxCheck.getNumber(this.start);
            int iend = ImapMailboxCheck.getNumber(this.stop);
            ret_code = false;
            if (istart < 1) {
                MsgBox msg = new MsgBox(this.frame, "Please enter a valid starting message number.");
                this.start.requestFocus();
            } else if (iend < 1) {
                MsgBox msg = new MsgBox(this.frame, "Please enter a valid ending message number.");
                this.stop.requestFocus();
            } else if (istart > total) {
                MsgBox msg = new MsgBox(this.frame, "The starting message number is too large.");
                this.start.requestFocus();
            } else if (iend > total) {
                MsgBox msg = new MsgBox(this.frame, "The ending message number is too large.");
                this.stop.requestFocus();
            } else {
                ret_code = true;
                if (istart > iend) {
                    int temp = istart;
                    istart = iend;
                    iend = temp;
                }
                int i2 = istart;
                while (i2 <= iend) {
                    sel[cnt++] = i2++;
                }
            }
        }
        if (ret_code) {
            this.sel = new int[cnt];
            for (i = 0; i < cnt; ++i) {
                this.sel[i] = sel[i];
            }
        }
        return ret_code;
    }

    public static int getNumber(TextField text) {
        int num = -1;
        try {
            num = Integer.valueOf(text.getText().trim());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return num;
    }

    public void enableDialog(Container cont, boolean val) {
        Component ccomp = null;
        for (int i = 0; i < cont.getComponentCount(); ++i) {
            ccomp = cont.getComponent(i);
            if (ccomp instanceof Container) {
                this.enableDialog((Container)ccomp, val);
            }
            if (ccomp == this.cancelButton || ccomp == this.text) continue;
            ccomp.setEnabled(val);
        }
    }

    public void processWindowEvent(WindowEvent evt) {
        if (evt.getID() == 201) {
            this.closeWindow();
        } else {
            super.processWindowEvent(evt);
        }
    }

    public void closeWindow() {
        try {
            if (this.retrthread != null) {
                this.retrthread.stop();
            }
            this.dispose();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void retrieveMessages(int style) {
        this.enableDialog(this, false);
        this.retrthread = new RetrieveThread(this, style);
        this.retrthread.start();
    }

    public void retrieveTheMessages(int style) {
        boolean ret_code = true;
        try {
            switch (style) {
                case 1: {
                    this.sel = this.mailbox.getNewMessages(this);
                    break;
                }
                case 2: {
                    this.sel = this.mailbox.getUnseenMessages(this);
                }
            }
        }
        catch (Imap4Exception e) {
            ret_code = false;
            MsgBox msgBox = new MsgBox(this, e.toString());
        }
        this.retrthread = null;
        if (ret_code) {
            this.closeWindow();
        } else {
            this.enableDialog(this, true);
        }
        this.text.setText("");
    }
}

