/*
 * Decompiled with CFR 0.152.
 */
package innoval.mailer;

import innoval.mailer.ImapMailbox;
import innoval.mailer.ImapTree;
import innoval.mailer.MsgBox;
import innoval.mailer.jstreet;
import java.awt.Button;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;

public class ImapSelectFolder
extends Dialog
implements KeyListener,
ActionListener {
    private ImapMailbox mailbox;
    private ImapTree tree;
    private ImapTree ftree;
    private Frame frame;
    private Button okButton;
    private Button cancelButton;
    private Button expandButton;
    private Button collapseButton;

    ImapSelectFolder(Frame frame, ImapTree ftree) {
        super(frame, "Select a Folder", true);
        this.frame = frame;
        this.ftree = ftree;
        this.initDialog();
        this.show();
    }

    public ImapMailbox getFolder() {
        return this.mailbox;
    }

    private void initDialog() {
        GridBagLayout grid = new GridBagLayout();
        int[] rowHeights = new int[]{250, 2, 2, 2, 5, 20, 5};
        int[] columnWidths = new int[]{5, 80, 5, 80, 5, 80, 5, 80, 5};
        double[] rowWeights = new double[]{10.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        double[] columnWeights = new double[]{10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0};
        grid.rowHeights = rowHeights;
        grid.columnWidths = columnWidths;
        grid.rowWeights = rowWeights;
        grid.columnWeights = columnWeights;
        GridBagConstraints con = new GridBagConstraints();
        this.tree = this.ftree.cloneTree();
        this.add(this.tree);
        jstreet.reset(con);
        con.gridx = 0;
        con.gridy = 0;
        con.gridwidth = 9;
        grid.setConstraints(this.tree, con);
        this.okButton = new Button("OK");
        this.okButton.addActionListener(this);
        this.okButton.addKeyListener(this);
        this.add(this.okButton);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 5;
        grid.setConstraints(this.okButton, con);
        this.cancelButton = new Button("Cancel");
        this.cancelButton.addActionListener(this);
        this.cancelButton.addKeyListener(this);
        this.add(this.cancelButton);
        jstreet.reset(con);
        con.gridx = 3;
        con.gridy = 5;
        grid.setConstraints(this.cancelButton, con);
        this.expandButton = new Button("Expand All");
        this.expandButton.addActionListener(this);
        this.expandButton.addKeyListener(this);
        this.add(this.expandButton);
        jstreet.reset(con);
        con.gridx = 5;
        con.gridy = 5;
        grid.setConstraints(this.expandButton, con);
        this.collapseButton = new Button("Collapse All");
        this.collapseButton.addActionListener(this);
        this.collapseButton.addKeyListener(this);
        this.add(this.collapseButton);
        jstreet.reset(con);
        con.gridx = 7;
        con.gridy = 5;
        grid.setConstraints(this.collapseButton, con);
        this.setLayout(grid);
        this.pack();
        jstreet.centerDialog(this, null);
        this.enableEvents(64L);
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            Button evt = this.okButton;
            if (e.getSource() == this.cancelButton) {
                evt = this.cancelButton;
            }
            ActionEvent ae = new ActionEvent(evt, 1001, "");
            this.actionPerformed(ae);
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            this.processSelection();
        } else if (e.getSource() == this.cancelButton) {
            this.Close();
        } else if (e.getSource() == this.expandButton) {
            this.tree.expandCollapse(true);
        } else if (e.getSource() == this.collapseButton) {
            this.tree.expandCollapse(false);
        }
    }

    public void processSelection() {
        ImapMailbox item = (ImapMailbox)this.tree.getSelectedNode();
        if (item == null) {
            MsgBox msgBox = new MsgBox(this.frame, "No folder is currently selected.");
        } else {
            this.mailbox = item;
            this.Close();
        }
    }

    public void processWindowEvent(WindowEvent evt) {
        if (evt.getID() == 201) {
            this.Close();
        } else {
            super.processWindowEvent(evt);
        }
    }

    private void Close() {
        this.dispose();
    }
}

