/*
 * Decompiled with CFR 0.152.
 */
package innoval.mailer;

import borland.jbcl.control.ChoiceControl;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Label;
import java.awt.Panel;

public class ImportColumn {
    static final int HEIGHT = 50;
    static final String[] COLUMNS = new String[]{"Do not use", "Nickname", "First Name", "Last Name", "Full Name", "Email Address", "Telephone Number", "Fax Number", "Organization", "Title", "Postal Address", "Notes"};
    static final int DONOTUSE = 0;
    static final int NICKNAME = 1;
    static final int FIRSTNAME = 2;
    static final int LASTNAME = 3;
    static final int FULLNAME = 4;
    static final int EMAIL = 5;
    static final int TELEPHONE = 6;
    static final int FAX = 7;
    static final int COMPANY = 8;
    static final int TITLE = 9;
    static final int ADDRESS = 10;
    static final int NOTES = 11;
    private Label textLabel;
    private Label dataLabel;
    private Label defLabel;
    private ChoiceControl choice;
    private int colNumber;
    private String text;

    ImportColumn(int colNumber, String text) {
        this.colNumber = colNumber;
        this.text = text;
    }

    public void addTo(Panel panel) {
        int start = (this.colNumber - 1) * 50;
        this.checkPanelSize(panel, start + 50);
        this.textLabel = new Label(String.valueOf(String.valueOf("Column[").concat(String.valueOf(this.colNumber))).concat(String.valueOf("] Text:")), 2);
        this.textLabel.setBounds(5, start, 110, 20);
        this.textLabel.setForeground(Color.blue);
        panel.add(this.textLabel);
        this.dataLabel = new Label(this.text);
        this.dataLabel.setBounds(120, start, 300, 20);
        panel.add(this.dataLabel);
        this.defLabel = new Label("Column Definition:", 2);
        this.defLabel.setBounds(5, start + 25, 110, 20);
        panel.add(this.defLabel);
        this.choice = new ChoiceControl();
        this.loadChoice(this.choice);
        this.choice.select(0);
        this.choice.setBounds(120, start + 25, 200, 20);
        panel.add(this.choice);
    }

    public void setEnabled(boolean val) {
        if (this.textLabel != null) {
            this.textLabel.setEnabled(val);
        }
        if (this.dataLabel != null) {
            this.dataLabel.setEnabled(val);
        }
        if (this.defLabel != null) {
            this.defLabel.setEnabled(val);
        }
        if (this.choice != null) {
            this.choice.setEnabled(val);
        }
    }

    public void setText(String text) {
        this.text = new String(text);
        this.dataLabel.setText(text);
    }

    private void checkPanelSize(Panel panel, int cy) {
        if (panel.getSize().height < cy) {
            panel.setSize(panel.getSize().width, cy);
        }
    }

    private void loadChoice(Choice choice) {
        for (int i = 0; i < COLUMNS.length; ++i) {
            choice.add(COLUMNS[i]);
        }
    }

    public String getText() {
        return this.text.replace('\"', ' ').trim();
    }

    public int getType() {
        int val = 0;
        if (this.choice != null) {
            val = this.choice.getSelectedIndex();
        }
        return val;
    }
}

