/*
 * Decompiled with CFR 0.152.
 */
package innoval.mailer;

import innoval.mailer.JstreetDate;
import java.util.Calendar;
import java.util.StringTokenizer;

public class InnoValDates {
    int ajDateTime;
    int timeZoneHour;
    int timeZoneMinutes;
    int yearInt;
    int monthInt;
    int dateInt;
    int hourInt;
    int minuteInt;
    int secondInt;
    boolean inputIsLocal = false;
    boolean outputIsLocal = false;
    long dateTimeInSeconds = 0L;
    String[] tokens = new String[20];
    String[] DAY_NAME = new String[]{"     ", "Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
    String[] MONTH_NAME = new String[]{"     ", "January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};

    public void setDateTime(String str) {
        int mm = 0;
        int dd = 0;
        int yyyy = 0;
        int hh = 0;
        int uu = 0;
        int ss = 0;
        boolean adjH = false;
        boolean adjU = false;
        StringTokenizer st = new StringTokenizer(str.replace(',', ' '));
        int arrayIndex = 0;
        int offset = 0;
        while (st.hasMoreTokens()) {
            this.tokens[arrayIndex++] = st.nextToken();
        }
        for (int i = 0; i < 8; ++i) {
            if (!this.tokens[0].startsWith(this.DAY_NAME[i].substring(0, 3))) continue;
            offset = 1;
            break;
        }
        block2: for (int t = 0; t < 2; ++t) {
            if (this.tokens[t + offset].length() < 3) {
                dd = Integer.parseInt(this.tokens[t + offset]);
                continue;
            }
            for (int i = 0; i < 13; ++i) {
                if (!this.tokens[t + offset].startsWith(this.MONTH_NAME[i].substring(0, 3))) continue;
                mm = i;
                continue block2;
            }
        }
        for (int t = 2; t < 4; ++t) {
            if (this.tokens[t + offset].length() < 5) {
                yyyy = Integer.parseInt(this.tokens[t + offset]);
                if (yyyy > 999) continue;
                if (yyyy < 70) {
                    yyyy += 2000;
                    continue;
                }
                yyyy += 1900;
                continue;
            }
            StringTokenizer time = new StringTokenizer(this.tokens[t + offset].replace(':', ' '));
            hh = Integer.parseInt(time.nextToken());
            uu = Integer.parseInt(time.nextToken());
            if (!time.hasMoreTokens()) continue;
            ss = Integer.parseInt(time.nextToken());
        }
        this.setDateTime(yyyy, mm, dd, hh, uu, ss);
    }

    public void setDateTime() {
        Calendar rightNow = Calendar.getInstance();
        this.setDateTime(rightNow.get(1), rightNow.get(2) + 1, rightNow.get(5), rightNow.get(10), rightNow.get(12), rightNow.get(13));
    }

    public void setDate(int yyyy, int mm, int dd) {
        this.setDateTime(yyyy, mm, dd, 0, 0, 0);
    }

    public void setDateTime(int yyyy, int mm, int dd, int hh, int uu, int ss, int adjH, int adjU) {
        this.setDateTime(yyyy, mm, dd, hh, uu, ss);
        this.timeZoneAdjust(adjH, adjU);
    }

    public void setDateTime(int yyyy, int mm, int dd, int hh, int uu, int ss) {
        this.ajDateTime = this.astroJulian(yyyy, mm, dd);
        this.dateTimeInSeconds = (long)this.ajDateTime * (long)86400 + (long)(hh * 3600) + (long)(uu * 60) + (long)ss;
    }

    public void setDateTime(int newAJDate) {
        this.ajDateTime = newAJDate;
        this.dateTimeInSeconds = (long)this.ajDateTime * (long)86400;
        this.sixValues(this.ajDateTime, 0L);
    }

    public int getAJDateTime() {
        return this.ajDateTime;
    }

    public String getInetDate() {
        long julian = this.dateTimeInSeconds / (long)86400;
        long seconds = this.dateTimeInSeconds % (long)86400;
        this.sixValues(julian, seconds);
        String hx = this.hourInt < 10 ? String.valueOf("0").concat(String.valueOf(this.hourInt)) : String.valueOf("").concat(String.valueOf(this.hourInt));
        String ux = this.minuteInt < 10 ? String.valueOf("0").concat(String.valueOf(this.minuteInt)) : String.valueOf("").concat(String.valueOf(this.minuteInt));
        String sx = this.secondInt < 10 ? String.valueOf("0").concat(String.valueOf(this.secondInt)) : String.valueOf("").concat(String.valueOf(this.secondInt));
        String x = String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(this.DAY_NAME[this.getDayOfWeek(julian)].substring(0, 3)).concat(String.valueOf(", "))).concat(String.valueOf(this.dateInt))).concat(String.valueOf(" "))).concat(String.valueOf(this.MONTH_NAME[this.monthInt].substring(0, 3)))).concat(String.valueOf(" "))).concat(String.valueOf(this.yearInt))).concat(String.valueOf(" "))).concat(String.valueOf(hx))).concat(String.valueOf(":"))).concat(String.valueOf(ux))).concat(String.valueOf(":"))).concat(String.valueOf(sx));
        return x;
    }

    public void timeZoneAdjust(String arg) {
        int adjHh = 0;
        int adjUu = 0;
        switch (arg.length()) {
            case 1: 
            case 3: {
                arg = arg.toUpperCase();
                if (arg.equals("EST")) {
                    adjHh = -5;
                    break;
                }
                if (arg.equals("EDT")) {
                    adjHh = -4;
                    break;
                }
                if (arg.equals("CST")) {
                    adjHh = -6;
                    break;
                }
                if (arg.equals("CDT")) {
                    adjHh = -5;
                    break;
                }
                if (arg.equals("MST")) {
                    adjHh = -7;
                    break;
                }
                if (arg.equals("MDT")) {
                    adjHh = -6;
                    break;
                }
                if (arg.equals("PST")) {
                    adjHh = -8;
                    break;
                }
                if (arg.equals("PDT")) {
                    adjHh = -7;
                    break;
                }
                if (arg.equals("AST")) {
                    adjHh = -4;
                    break;
                }
                if (arg.equals("ADT")) {
                    adjHh = -3;
                    break;
                }
                adjHh = 0;
                break;
            }
            case 5: {
                char sign = arg.charAt(0);
                int hh = Integer.parseInt(arg.substring(1, 2));
                int uu = Integer.parseInt(arg.substring(3, 4));
                if (sign == '+') {
                    adjHh = hh;
                    adjUu = uu;
                    break;
                }
                if (sign == '-') {
                    adjHh = -hh;
                    adjUu = -uu;
                    break;
                }
                adjHh = 0;
                adjUu = 0;
            }
        }
        this.timeZoneAdjust(adjHh, adjUu);
    }

    public void timeZoneAdjust(int adjHh, int adjUu) {
        this.dateTimeInSeconds = this.dateTimeInSeconds + (long)(adjHh * 3600) + (long)(adjUu * 60);
    }

    public int astroJulian(int yyyy, int mm, int dd) {
        int aJ = 0;
        int i = 0;
        if (yyyy > 1980) {
            int yy = yyyy - 1980;
            aJ = 1461 * (yy / 4) + 365 * (yy % 4);
            for (i = 1; i < mm; ++i) {
                aJ += this.getDaysInMonth(yyyy, i);
            }
            aJ += dd;
        }
        return aJ;
    }

    public int dateAndTimeInSeconds(int aJ) {
        return aJ * 86400;
    }

    public void sixValues(long dts) {
        long julian = this.dateTimeInSeconds / (long)86400;
        long seconds = this.dateTimeInSeconds % (long)86400;
        this.sixValues(julian, seconds);
    }

    public void sixValues(long aJ, long ss) {
        boolean notDone = true;
        this.yearInt = (int)(aJ / (long)1461) * 4;
        this.yearInt = (int)((long)this.yearInt + (aJ %= (long)1461) / (long)365);
        aJ %= (long)365;
        this.yearInt += 1980;
        this.monthInt = 1;
        while (notDone) {
            int x = this.getDaysInMonth(this.yearInt, this.monthInt);
            if (aJ > (long)x) {
                ++this.monthInt;
                aJ -= (long)x;
                continue;
            }
            notDone = false;
            this.dateInt = (int)aJ;
        }
        this.hourInt = (int)(ss / (long)3600);
        ss = (int)(ss % (long)3600);
        this.minuteInt = (int)(ss / (long)60);
        this.secondInt = (int)(ss % (long)60);
    }

    public int getDayOfWeek(long aJ) {
        long day = aJ % (long)7 + (long)3;
        if (day > (long)7) {
            day -= (long)7;
        }
        return (int)day;
    }

    public static double dateToDouble(String date) {
        double val = 0.0;
        JstreetDate jdate = new JstreetDate(date);
        try {
            jdate.adjustTimeZone();
        }
        catch (Exception exception) {
            // empty catch block
        }
        val = jdate.toDouble();
        jdate = null;
        return val;
    }

    public static long dateToLong(String date) {
        long val = 0L;
        JstreetDate jdate = new JstreetDate(date);
        try {
            jdate.adjustTimeZone();
        }
        catch (Exception exception) {
            // empty catch block
        }
        val = jdate.toLong();
        jdate = null;
        return val;
    }

    public int getDayOfWeek() {
        long julian = this.dateTimeInSeconds / (long)86400;
        return this.getDayOfWeek(julian);
    }

    public int getDaysInMonth() {
        this.sixValues(this.dateTimeInSeconds);
        int rint = 0;
        switch (this.monthInt) {
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                rint = 30;
                break;
            }
            case 2: {
                rint = 28;
                break;
            }
            default: {
                rint = 31;
            }
        }
        if (rint == 28 && this.yearInt % 4 == 0) {
            rint = 29;
        }
        return rint;
    }

    public int getDaysInMonth(int yyyy, int mm) {
        int rint = 0;
        switch (mm) {
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                rint = 30;
                break;
            }
            case 2: {
                rint = 28;
                break;
            }
            default: {
                rint = 31;
            }
        }
        if (rint == 28 && yyyy % 4 == 0) {
            rint = 29;
        }
        return rint;
    }
}

