/*
 * Decompiled with CFR 0.152.
 */
package innoval.mailer;

import innoval.mailer.AutoRefresh;
import innoval.mailer.jstreet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.File;

public class Logo
extends Window {
    static final String IMAGE = new String("image/logo.gif");
    private jstreet Jstreet;
    private int w = 0;
    private int h = 0;
    private Image image;
    private Image off;

    public Logo(jstreet Jstreet) {
        super(Jstreet);
        this.Jstreet = Jstreet;
        this.initWindow();
        ((Component)this).setVisible(true);
        this.paint(this.getGraphics());
    }

    private void initWindow() {
        this.image = Logo.readFile(new File(IMAGE));
        for (int i = 0; i < 20 && this.image.getWidth(this) < 0; ++i) {
            AutoRefresh.Sleep(100L);
        }
        this.w = this.image.getWidth(this);
        this.h = this.image.getHeight(this);
        this.off = this.createImage(this.w, this.h);
        ((Component)this).setSize(this.w, this.h);
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)this).setLocation((screen.width - this.getSize().width) / 2, (screen.height - this.getSize().height) / 2);
    }

    public void close() {
        this.dispose();
    }

    public static Image readFile(File file) {
        Image image = null;
        if (file != null && file.exists()) {
            image = Toolkit.getDefaultToolkit().getImage(file.getAbsolutePath());
        } else {
            System.out.println(String.valueOf(String.valueOf("Logo image [").concat(String.valueOf(IMAGE))).concat(String.valueOf("] was not found.")));
        }
        return image;
    }

    public void update() {
    }

    public void paint(Graphics g) {
        Graphics offg = null;
        int x = 0;
        int y = 0;
        if (this.off != null) {
            offg = this.off.getGraphics();
        }
        if (offg == null) {
            offg = g;
        }
        if (this.image != null) {
            offg.drawImage(this.image, x, y, this);
        }
        offg.setFont(new Font("Helvetica", 0, 18));
        FontMetrics tm = offg.getFontMetrics();
        x = 5;
        y = 110;
        y = this.writeLine(offg, tm, jstreet.XMAILER, x, y);
        y = this.writeLine(offg, tm, jstreet.COMPANY, x, y);
        offg.setFont(new Font("Helvetica", 0, 12));
        tm = offg.getFontMetrics();
        y = this.writeLine(offg, tm, jstreet.ADDRESS, x, y);
        y = this.writeLine(offg, tm, jstreet.WEBPAGE, x, y);
        y = this.writeLine(offg, tm, jstreet.COPYRIGHT, x, y);
        y = this.writeLine(offg, tm, "All rights reserved.", x, y);
        if (this.Jstreet.licenseNum != null && this.Jstreet.licenseNum.length() > 0) {
            String text = new String(String.valueOf("License Number: ").concat(String.valueOf(this.Jstreet.licenseNum)));
            y = this.writeLine(offg, tm, text, x, y);
        }
        if (offg != g) {
            g.drawImage(this.off, 0, 0, this);
        }
        g.setPaintMode();
    }

    private int writeLine(Graphics g, FontMetrics tm, String text, int x, int y) {
        x = this.w - tm.stringWidth(text) - 15;
        g.setColor(Color.black);
        g.drawString(text, x + 2, y + 2);
        g.setColor(Color.white);
        g.drawString(text, x, y);
        return y += tm.getHeight() + 2;
    }
}

