/*
 * Decompiled with CFR 0.152.
 */
package innoval.mailer;

import innoval.mailer.AccountIndex;
import innoval.mailer.MsgBox;
import innoval.mailer.jstreet;
import java.awt.Button;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.io.File;

public class NewAccount
extends Dialog
implements KeyListener,
ActionListener {
    public boolean force = false;
    public boolean ret_code = false;
    private String account;
    private Frame parent;
    private Button okButton;
    private Button cancelButton;
    private File CurrentDirectory;
    private AccountIndex accountIndex;
    private TextField accountField;

    NewAccount(Frame parent, AccountIndex accountIndex, String dir) {
        super(parent, "Create a New Account", true);
        this.CurrentDirectory = new File(dir);
        this.parent = parent;
        this.accountIndex = accountIndex;
        this.ret_code = false;
        this.account = new String("");
        this.initDialog();
    }

    NewAccount(Frame parent, boolean force, AccountIndex accountIndex, String dir) {
        super(parent, "Create a New Account", true);
        this.CurrentDirectory = new File(dir);
        this.parent = parent;
        this.force = force;
        this.accountIndex = accountIndex;
        this.ret_code = false;
        this.account = new String("");
        this.initDialog();
    }

    private void initDialog() {
        Label label = null;
        GridBagLayout grid = new GridBagLayout();
        int[] rowHeights = new int[]{5, 20, 20, 24, 5};
        int[] columnWidths = new int[]{5, 60, 5, 60, 5, 60, 60, 60, 50, 5};
        double[] rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        double[] columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        grid.rowHeights = rowHeights;
        grid.columnWidths = columnWidths;
        grid.rowWeights = rowWeights;
        grid.columnWeights = columnWeights;
        GridBagConstraints con = new GridBagConstraints();
        label = new Label("Account Name", 2);
        this.add(label);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 1;
        con.gridwidth = 3;
        grid.setConstraints(label, con);
        this.accountField = new TextField();
        this.accountField.addKeyListener(this);
        this.add(this.accountField);
        jstreet.reset(con);
        con.gridx = 5;
        con.gridy = 1;
        con.gridwidth = 4;
        grid.setConstraints(this.accountField, con);
        this.okButton = new Button("OK");
        this.okButton.addActionListener(this);
        this.okButton.addKeyListener(this);
        this.add(this.okButton);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 3;
        grid.setConstraints(this.okButton, con);
        this.cancelButton = new Button("Cancel");
        this.cancelButton.addActionListener(this);
        this.cancelButton.addKeyListener(this);
        if (!this.force) {
            this.add(this.cancelButton);
            jstreet.reset(con);
            con.gridx = 3;
            con.gridy = 3;
            grid.setConstraints(this.cancelButton, con);
        }
        this.setLayout(grid);
        this.pack();
        this.setResizable(false);
        jstreet.centerDialog(this, this.parent);
        this.enableEvents(64L);
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            Button evt = this.okButton;
            if (e.getSource() == this.cancelButton) {
                evt = this.cancelButton;
            }
            ActionEvent ae = new ActionEvent(evt, 1001, "");
            this.actionPerformed(ae);
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            this.account = new String(this.accountField.getText().trim());
            if (this.account.length() == 0) {
                MsgBox msgbox = new MsgBox(this.parent, "Please specify an account name.");
                this.accountField.requestFocus();
            } else if (this.account.length() < 2 || this.account.charAt(1) != ':' && this.account.indexOf(File.separator) < 0) {
                if (!this.accountIndex.exists(this.account)) {
                    File file = new File(String.valueOf(this.CurrentDirectory.getAbsolutePath()).concat(String.valueOf(File.separator)), this.account);
                    if (!file.isDirectory() && !file.mkdir()) {
                        MsgBox msgbox = new MsgBox(this.parent, "A new account directory could not be created from the specified account name.");
                        this.accountField.requestFocus();
                    } else {
                        this.ret_code = true;
                    }
                } else {
                    MsgBox msgbox = new MsgBox(this.parent, "The specified account already exists in your account menu.");
                    this.accountField.requestFocus();
                }
            } else if (!this.accountIndex.exists(this.account)) {
                File file = new File(this.account);
                if (file.isDirectory()) {
                    this.ret_code = true;
                } else {
                    MsgBox msgbox = new MsgBox((Container)this.parent, "The specified account directory does not exist.  Would you like to create this directory?", 2);
                    if (msgbox.ret_code == 0) {
                        if (file.mkdir()) {
                            this.ret_code = true;
                        } else {
                            msgbox = new MsgBox(this.parent, "The specified account could not be created.");
                        }
                    } else {
                        this.accountField.requestFocus();
                    }
                }
            } else {
                MsgBox msgbox = new MsgBox(this.parent, String.valueOf(String.valueOf("The specified account directory already exists in your account menu, or contains an account settings file [").concat(String.valueOf(jstreet.PROFILENAME))).concat(String.valueOf("].")));
                this.accountField.requestFocus();
            }
            if (this.ret_code) {
                this.dispose();
            }
        } else if (e.getSource() == this.cancelButton) {
            this.dispose();
        }
    }

    public void processWindowEvent(WindowEvent evt) {
        if (evt.getID() == 201) {
            if (!this.force) {
                this.dispose();
            } else {
                MsgBox msgBox = new MsgBox(this.parent, "You must specify an account name.");
            }
        } else {
            super.processWindowEvent(evt);
        }
    }

    public String getAccount() {
        return this.account;
    }
}

