/*
 * Decompiled with CFR 0.152.
 */
package innoval.mailer;

import borland.jbcl.control.TabsetPanel;
import innoval.mailer.MsgBox;
import innoval.mailer.Persona;
import innoval.mailer.Profile;
import innoval.mailer.jstreet;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;

public class PersonaDialog
extends Dialog
implements ActionListener,
ItemListener {
    private jstreet parent;
    private Frame frame;
    private Profile profile;
    private Button okButton;
    private Button cancelButton;
    private Button createButton;
    private Button deleteButton;
    private Persona[] persona;
    private Persona selectedPersona;
    private int count;
    private Panel mainPanel;
    private TabsetPanel notebook;
    public boolean ret_code;

    PersonaDialog(Frame frame, jstreet parent, Profile profile) {
        super(frame, "Personas", true);
        this.frame = frame;
        this.parent = parent;
        this.profile = profile;
        this.ret_code = false;
        this.selectedPersona = null;
        this.persona = new Persona[30];
        this.count = 0;
        this.initDialog();
    }

    private void initDialog() {
        this.mainPanel = new Panel();
        this.add("South", this.mainPanel);
        GridBagLayout grid = new GridBagLayout();
        int[] rowHeights = new int[]{5, 20, 5};
        int[] columnWidths = new int[]{5, 60, 5, 60, 5, 60, 5, 60, 5};
        double[] rowWeights = new double[]{0.0, 0.0, 10.0};
        double[] columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.0};
        grid.rowHeights = rowHeights;
        grid.columnWidths = columnWidths;
        grid.rowWeights = rowWeights;
        grid.columnWeights = columnWeights;
        GridBagConstraints con = new GridBagConstraints();
        this.okButton = new Button("OK");
        this.okButton.addActionListener(this);
        this.mainPanel.add(this.okButton);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 1;
        grid.setConstraints(this.okButton, con);
        this.cancelButton = new Button("Cancel");
        this.cancelButton.addActionListener(this);
        this.mainPanel.add(this.cancelButton);
        jstreet.reset(con);
        con.gridx = 3;
        con.gridy = 1;
        grid.setConstraints(this.cancelButton, con);
        this.createButton = new Button("Create");
        this.createButton.addActionListener(this);
        this.mainPanel.add(this.createButton);
        jstreet.reset(con);
        con.gridx = 5;
        con.gridy = 1;
        grid.setConstraints(this.createButton, con);
        this.deleteButton = new Button("Delete");
        this.deleteButton.addActionListener(this);
        this.mainPanel.add(this.deleteButton);
        jstreet.reset(con);
        con.gridx = 7;
        con.gridy = 1;
        grid.setConstraints(this.deleteButton, con);
        this.notebook = new TabsetPanel();
        this.add("Center", this.notebook);
        this.setupNotebook();
        this.mainPanel.setLayout(grid);
        this.pack();
        this.setResizable(false);
        jstreet.centerDialog(this, this.frame);
        this.enableEvents(64L);
    }

    public String getSystemDir() {
        return this.parent.getSystemDir();
    }

    public void initDialog(Persona spersona) {
        for (int i = 0; i < this.count; ++i) {
            if (spersona.getName().compareTo(this.persona[i].getName()) != 0) continue;
            this.notebook.setSelectedIndex(i);
            break;
        }
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            for (int i = 0; i < this.count; ++i) {
                if (i == this.notebook.getSelectedIndex()) continue;
                this.persona[i].setDefault(false);
            }
        }
    }

    public Persona getPersona() {
        return this.selectedPersona;
    }

    public void actionPerformed(ActionEvent e) {
        block11: {
            block13: {
                block14: {
                    block12: {
                        block10: {
                            if (e.getSource() != this.okButton) break block10;
                            if (!this.checkForDuplicates() || !this.Close()) break block11;
                            this.ret_code = true;
                            this.selectedPersona = this.persona[this.notebook.getSelectedIndex()];
                            try {
                                this.dispose();
                            }
                            catch (NullPointerException nullPointerException) {}
                            break block11;
                        }
                        if (e.getSource() != this.cancelButton) break block12;
                        this.dispose();
                        break block11;
                    }
                    if (e.getSource() != this.deleteButton) break block13;
                    if (this.count <= 1) break block14;
                    int page = this.notebook.getSelectedIndex();
                    this.persona[page].setDeleted(true);
                    this.persona[page].deletePersona();
                    this.profile.Save();
                    for (int i = page; i < this.count - 1; ++i) {
                        this.persona[i] = this.persona[i + 1];
                    }
                    --this.count;
                    this.notebook.removeTab(this.notebook.getLabel(page));
                    if (page == this.count) {
                        --page;
                    }
                    if (this.count <= 0) break block11;
                    this.notebook.setSelectedIndex(page);
                    break block11;
                }
                MsgBox page = new MsgBox(this.frame, "You may not delete your last persona.");
                break block11;
            }
            if (e.getSource() == this.createButton) {
                if (this.count < 30) {
                    int num = this.count + 1;
                    int page = 0;
                    this.persona[this.count] = new Persona(this.frame, this.parent, this.profile, String.valueOf(String.valueOf("Persona[").concat(String.valueOf(num))).concat(String.valueOf("]")));
                    this.notebook.add((Component)this.persona[this.count].loadPanel(this), this.persona[this.count].getName());
                    page = this.notebook.getComponentCount();
                    this.persona[this.count].initFocus();
                    ++this.count;
                    this.notebook.setSelectedIndex(page -= 2);
                } else {
                    MsgBox num = new MsgBox(this.frame, "The maximum number of personas [30] has been exceeded.");
                }
            } else {
                for (int i = 0; i < this.count; ++i) {
                    if (e.getSource() == this.persona[i].selectButton) {
                        this.persona[i].selectTagFile();
                        break;
                    }
                    if (e.getSource() != this.persona[i].selectFolder) continue;
                    this.persona[i].selectFolder(this.frame, this.parent);
                    break;
                }
            }
        }
    }

    public boolean checkForDuplicates() {
        boolean ret_code = true;
        for (int i = 1; i < this.count; ++i) {
            String curpage = this.persona[i].getNewName();
            curpage.toLowerCase();
            for (int j = 0; j < i; ++j) {
                String prevpage = this.persona[j].getNewName();
                prevpage.toLowerCase();
                if (curpage.compareTo(prevpage) != 0) continue;
                this.notebook.setSelectedIndex(i);
                MsgBox msgbox = new MsgBox(this.frame, "A duplicate persona name has been found.");
                ret_code = false;
                break;
            }
            if (!ret_code) break;
        }
        return ret_code;
    }

    public void processWindowEvent(WindowEvent evt) {
        if (evt.getID() == 201) {
            this.dispose();
        } else {
            super.processWindowEvent(evt);
        }
    }

    private boolean Close() {
        boolean ret_code = true;
        String personas = new String("");
        for (int i = 0; i < this.count; ++i) {
            if (this.persona[i].isDeleted()) {
                this.persona[i].deletePersona();
                continue;
            }
            if (!this.persona[i].savePersona()) {
                this.initDialog(this.persona[i]);
                ret_code = false;
                break;
            }
            personas = new String(String.valueOf(String.valueOf(personas).concat(String.valueOf(this.persona[i].getName()))).concat(String.valueOf(",")));
        }
        if (ret_code) {
            this.profile.WriteString(Persona.SAVENAME, Persona.PERSONALIST, personas);
            this.profile.Save();
        }
        return ret_code;
    }

    private void setupNotebook() {
        String personas = Persona.getPersonas(this.profile);
        int spot = 0;
        int defpage = -1;
        do {
            if ((spot = personas.indexOf(44)) > 0) {
                String text = new String(personas.substring(0, spot));
                personas = new String(personas.substring(spot + 1));
                this.persona[this.count] = new Persona(this.frame, this.parent, this.profile, text);
                if (this.persona[this.count].isDefault()) {
                    defpage = this.count;
                }
                this.notebook.add((Component)this.persona[this.count].loadPanel(this), this.persona[this.count].getName());
                ++this.count;
                continue;
            }
            personas = new String("");
        } while (personas.length() > 0);
        if (this.count == 0) {
            this.persona[this.count++] = new Persona(this.frame, this.parent, this.profile, "Default");
            this.notebook.add((Component)this.persona[0].loadPanel(this), this.persona[0].getName());
            this.persona[0].initFocus();
        }
        if (defpage >= 0) {
            this.notebook.setSelectedIndex(defpage);
        } else {
            this.notebook.setSelectedIndex(0);
        }
    }
}

