/*
 * Decompiled with CFR 0.152.
 */
package innoval.popper;

import innoval.mail.Imap4;
import innoval.mail.Imap4Exception;
import innoval.mail.Imap4Folder;
import innoval.mail.Imap4Message;
import innoval.mailer.GenPopName;
import innoval.mailer.MsgBox;
import innoval.mailer.PopFileProcedure;
import innoval.mailer.Profile;
import innoval.mailer.SettingsAdvanced;
import innoval.mailer.SettingsGeneral;
import innoval.mailer.UIDLHandler;
import innoval.popper.PopperAccount;
import java.awt.Frame;
import java.awt.Label;
import java.io.File;

public class Imap4Retrieve {
    private String server;
    private String userid;
    private String password;
    private Imap4 imap;
    private Imap4Folder folder;
    private int port;
    private int maxBytes;
    private int connectTime = 60;
    private int lastMessage;
    private String mailbox = new String("");
    private String inchar = new String("");
    private Frame frame;
    private PopperAccount account;
    private Profile profile;
    private File popname;
    private File currentPopfile;
    private boolean deleteMessages;
    private boolean stop;
    private boolean newonly = false;

    Imap4Retrieve(Frame frame, PopperAccount account) {
        this.frame = frame;
        this.account = account;
        this.profile = account.getProfile();
        this.setTimeout();
    }

    public void setMailBox(String mailbox) {
        this.mailbox = new String(mailbox);
    }

    private void setTimeout() {
        try {
            this.connectTime = Integer.valueOf(this.profile.ReadString(SettingsGeneral.SAVEGENERAL, SettingsGeneral.POPTIMEOUT, "60"));
        }
        catch (NumberFormatException e) {
            this.connectTime = 60;
        }
    }

    public void setUserid(String userid) {
        this.userid = new String(userid);
    }

    public void setPassword(String password) {
        this.password = new String(password);
    }

    public void setServer(String server) {
        this.server = new String(server);
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setMaxKiloBytes(int maxBytes) {
        this.maxBytes = maxBytes * 1024;
    }

    public void setNewOnly(boolean newonly) {
        this.newonly = newonly;
    }

    public void setDelete(boolean val) {
        this.deleteMessages = val;
    }

    public int getMail() {
        boolean logon = false;
        boolean large = false;
        boolean go = true;
        Imap4Message msg = null;
        Object retCode = null;
        Object pop = null;
        UIDLHandler huidl = null;
        int i = 0;
        int count = 0;
        int total = 0;
        int deleted = 0;
        int mailmapstyle = 0;
        String mailmapEmail = this.profile.ReadString(SettingsAdvanced.SAVEADVANCED, SettingsAdvanced.MAILMAPEMAIL, "");
        boolean uidl = true;
        if (mailmapEmail.length() > 0) {
            mailmapstyle = Integer.valueOf(this.profile.ReadString(SettingsAdvanced.SAVEADVANCED, SettingsAdvanced.MAILMAPSTYLE, "0"));
        }
        if (!this.account.getStop()) {
            logon = this.imapConnect(this.account.text);
        }
        if (logon) {
            total = this.folder.getMessageCount();
            if (!this.account.getStop() && total > 0) {
                huidl = new UIDLHandler(this.account.getAccountDir());
                this.account.setText("Retrieving messages...");
                while (!this.account.getStop() && i < total) {
                    try {
                        msg = this.folder.getMessage(++i);
                        this.popname = new File(new GenPopName(this.account.getDir()).getName());
                        if (huidl != null) {
                            huidl.addNew(msg.getUID());
                        }
                        go = true;
                    }
                    catch (Imap4Exception e) {
                        go = false;
                        System.out.println(e.toString());
                    }
                    if (go) {
                        if (!this.account.getStop() && mailmapEmail.length() > 0) {
                            this.account.setText(String.valueOf(String.valueOf(String.valueOf(String.valueOf("Mailmapping [").concat(String.valueOf(i))).concat(String.valueOf("] of ["))).concat(String.valueOf(total))).concat(String.valueOf("].")));
                            go = PopFileProcedure.mailMap(msg, mailmapEmail, mailmapstyle);
                        } else {
                            go = true;
                        }
                    }
                    if (!this.account.getStop() && go && this.newonly) {
                        boolean bl = go = !huidl.findId(msg.getUID());
                    }
                    if (this.account.getStop() || !go) continue;
                    this.account.setText(String.valueOf(String.valueOf(String.valueOf(String.valueOf("Retrieving message [").concat(String.valueOf(i))).concat(String.valueOf("] of ["))).concat(String.valueOf(total))).concat(String.valueOf("].")));
                    if (msg.getSize() > this.maxBytes && this.maxBytes > 0) {
                        large = true;
                        msg.setMaxBytes(this.maxBytes);
                        msg.setMaxText(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("\n\n<html><body><hr>\n<center>ATTENTION: This notice was added by The J Street Mailer.</center>\n<center><hr width=200></center>\nThe remainder of this message has been left on your server because its \nsize [").concat(String.valueOf(msg.getSize()))).concat(String.valueOf(" bytes] exceeds the limit imposed in your General Settings ["))).concat(String.valueOf(this.maxBytes))).concat(String.valueOf(" \n"))).concat(String.valueOf("bytes]. Please use the \"Preview Mail\" option to view the mail remaining on "))).concat(String.valueOf("your message server.\n<hr>\n")));
                    } else {
                        large = false;
                    }
                    try {
                        msg.writeMessage(this.popname);
                    }
                    catch (Imap4Exception e) {
                        System.out.println(e.toString());
                    }
                    if (this.account.getStop() || !this.popname.exists() || this.popname.length() <= (long)0) continue;
                    if (uidl) {
                        huidl.addId(msg.getUID());
                    }
                    ++count;
                    if (!this.deleteMessages || large) continue;
                    try {
                        msg.delete();
                        ++deleted;
                    }
                    catch (Imap4Exception e) {
                        System.out.println(e.toString());
                    }
                }
            }
        }
        if (huidl != null) {
            huidl.saveServer();
            huidl = null;
        }
        if (this.deleteMessages && deleted > 0) {
            try {
                this.folder.removeMessages();
            }
            catch (Imap4Exception e) {
                System.out.println(e.toString());
            }
        }
        try {
            this.folder.close();
            this.imap.close();
        }
        catch (Imap4Exception e) {
            System.out.println(e.toString());
        }
        return count;
    }

    private boolean imapConnect(Label text) {
        boolean ret_code = false;
        this.imap = new Imap4();
        this.imap.setDebug(false);
        this.imap.setNoop(true);
        this.imap.setLabel(text);
        this.imap.setUserid(this.userid);
        this.imap.setPassword(this.password);
        this.imap.setPort(this.port);
        this.imap.setServer(this.server);
        try {
            if (this.imap.open()) {
                this.folder = new Imap4Folder(this.imap, "", this.mailbox);
                ret_code = this.folder.open();
            }
        }
        catch (Imap4Exception e) {
            MsgBox msgBox = new MsgBox(this.frame, e.toString());
        }
        return ret_code;
    }
}

