/*
 * Decompiled with CFR 0.152.
 */
package innoval.popper;

import innoval.mailer.ConnectSocketThread;
import innoval.mailer.GenPopName;
import innoval.mailer.MailMsg;
import innoval.mailer.MsgBox;
import innoval.mailer.PopFileProcedure;
import innoval.mailer.Profile;
import innoval.mailer.SettingsAdvanced;
import innoval.mailer.SettingsGeneral;
import innoval.mailer.UIDLHandler;
import innoval.popper.PopperAccount;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Socket;

public class Pop3Retrieve {
    private String server;
    private String userid;
    private String password;
    private Socket socket;
    private int port;
    private int maxBytes;
    private int firstMessage;
    private int connectTime = 60;
    private int lastMessage;
    private String inchar = new String("");
    private BufferedReader in;
    private BufferedWriter bwrite;
    private DataOutputStream out;
    private Frame frame;
    private PopperAccount account;
    private Profile profile;
    private File popname;
    private File currentPopfile;
    private boolean deleteMessages;
    private boolean newonly = false;

    Pop3Retrieve(Frame frame, PopperAccount account) {
        this.frame = frame;
        this.account = account;
        this.profile = account.getProfile();
        this.setTimeout();
    }

    private void setTimeout() {
        try {
            this.connectTime = Integer.valueOf(this.profile.ReadString(SettingsGeneral.SAVEGENERAL, SettingsGeneral.POPTIMEOUT, "60"));
        }
        catch (NumberFormatException e) {
            this.connectTime = 60;
        }
    }

    public void setMaxKiloBytes(int maxBytes) {
        this.maxBytes = maxBytes * 1024;
    }

    public void setUserid(String userid) {
        this.userid = new String(userid);
    }

    public void setPassword(String password) {
        this.password = new String(password);
    }

    public void setServer(String server) {
        this.server = new String(server);
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setNewOnly(boolean newonly) {
        this.newonly = newonly;
    }

    public void setFirstMessage(int val) {
        this.firstMessage = val;
    }

    public int getLastMessage() {
        return this.lastMessage;
    }

    public void setDelete(boolean val) {
        this.deleteMessages = val;
    }

    public boolean outReady() {
        boolean ret_code = false;
        if (this.out != null) {
            ret_code = true;
        }
        return ret_code;
    }

    public int ExecuteStat() {
        int notes = -1;
        try {
            if (!this.account.getStop()) {
                this.out.writeBytes("STAT\r\n");
                this.inchar = this.in.readLine();
                if (this.inchar.charAt(0) == '+') {
                    int end = this.inchar.indexOf(32, 4);
                    String text = new String(this.inchar.substring(4, end));
                    notes = Integer.parseInt(text);
                }
            }
        }
        catch (IOException e) {
            MsgBox msgBox = new MsgBox(this.frame, String.valueOf("Error").concat(String.valueOf(e)));
        }
        return notes;
    }

    public boolean runUIDL() {
        boolean ret_code = false;
        try {
            this.out.writeBytes("UIDL\r\n");
            this.inchar = this.in.readLine();
            if (this.inchar.charAt(0) == '+') {
                ret_code = true;
            }
        }
        catch (IOException e) {
            System.out.println(String.valueOf("UIDL Error: ").concat(String.valueOf(e)));
        }
        return ret_code;
    }

    public int getMail() {
        int count;
        block20: {
            boolean logon = false;
            boolean large = false;
            boolean go = true;
            MailMsg mailmsg = null;
            Object retCode = null;
            PopFileProcedure pop = null;
            UIDLHandler huidl = null;
            count = 0;
            int total = 0;
            int mailmapstyle = 0;
            String mailmapEmail = this.profile.ReadString(SettingsAdvanced.SAVEADVANCED, SettingsAdvanced.MAILMAPEMAIL, "");
            boolean uidl = Boolean.valueOf(this.profile.ReadString(SettingsGeneral.SAVEGENERAL, SettingsGeneral.UIDLCMD, "true"));
            if (mailmapEmail.length() > 0) {
                mailmapstyle = Integer.valueOf(this.profile.ReadString(SettingsAdvanced.SAVEADVANCED, SettingsAdvanced.MAILMAPSTYLE, "0"));
            }
            try {
                if (!this.account.getStop()) {
                    logon = this.Logon();
                }
                if (logon) {
                    this.account.setText("Counting available messages...");
                    if (!this.account.getStop()) {
                        total = this.ExecuteStat();
                    }
                    if (total >= 0) {
                        if (!this.account.getStop() && total > 0 && uidl) {
                            this.account.setText("Requesting UIDL message ids...");
                            huidl = new UIDLHandler(this.account.getAccountDir());
                            if (this.runUIDL()) {
                                huidl.retrieveIds(this.in);
                            } else {
                                uidl = false;
                                huidl.setSetting(this.profile, false);
                                huidl = null;
                            }
                        }
                        if (!this.account.getStop() && total > 0) {
                            this.account.setText("Retrieving messages...");
                        }
                        if (mailmapEmail.length() > 0 || uidl || this.firstMessage - 1 > total || this.firstMessage == 0) {
                            this.firstMessage = 1;
                        }
                        this.lastMessage = this.firstMessage - 1;
                        for (int i = this.firstMessage; !this.account.getStop() && i <= total; ++i) {
                            this.popname = new File(new GenPopName(this.account.getDir()).getName());
                            if (!this.account.getStop() && mailmapEmail.length() > 0) {
                                this.account.setText(String.valueOf(String.valueOf(String.valueOf(String.valueOf("Mailmapping [").concat(String.valueOf(i))).concat(String.valueOf("] of ["))).concat(String.valueOf(total))).concat(String.valueOf("].")));
                                pop = this.getMessage(i, this.popname, 3);
                                go = pop.mailMap(mailmapEmail, mailmapstyle);
                                pop = null;
                                this.popname.delete();
                            } else {
                                go = true;
                            }
                            if (!this.account.getStop() && go && this.newonly && uidl) {
                                boolean bl = go = !huidl.findId(i - 1);
                            }
                            if (this.account.getStop() || !go) continue;
                            this.account.setText(String.valueOf(String.valueOf(String.valueOf(String.valueOf("Retrieving message [").concat(String.valueOf(i))).concat(String.valueOf("] of ["))).concat(String.valueOf(total))).concat(String.valueOf("].")));
                            this.bwrite = new BufferedWriter(new FileWriter(this.popname.getAbsolutePath()));
                            mailmsg = new MailMsg();
                            mailmsg.setMaxBytes(this.maxBytes);
                            mailmsg.getMessage(this.frame, this.in, this.out, i, this.bwrite, this.account.text, null);
                            mailmsg.setPopfile(this.popname.getCanonicalPath());
                            large = mailmsg.getLarge();
                            this.bwrite.close();
                            this.bwrite = null;
                            mailmsg = null;
                            if (!this.account.getStop() && this.popname.exists() && this.popname.length() > (long)0) {
                                if (uidl) {
                                    huidl.addId(i - 1);
                                }
                                ++count;
                                if (this.deleteMessages && !large) {
                                    this.out.writeBytes(String.valueOf(String.valueOf("DELE ").concat(String.valueOf(i))).concat(String.valueOf("\r\n")));
                                    this.inchar = this.in.readLine();
                                    continue;
                                }
                                this.lastMessage = i;
                                continue;
                            }
                            if (!this.popname.exists() || this.popname.length() != (long)0) continue;
                            System.out.println(String.valueOf(String.valueOf("Message [").concat(String.valueOf(i))).concat(String.valueOf("] was found to be zero bytes prior to filter execution.")));
                        }
                    }
                }
            }
            catch (IOException e) {
                MsgBox msgBox = new MsgBox(this.frame, String.valueOf("Error").concat(String.valueOf(e)));
            }
            if (huidl != null) {
                huidl.saveServer();
                huidl = null;
            }
            if (!logon) break block20;
            this.Logoff();
        }
        return count;
    }

    public PopFileProcedure getMessage(int msgnum, File file, int parm) {
        boolean ret_code = false;
        PopFileProcedure pop = null;
        long bytes = 0L;
        int buflen = 0;
        int read = 0;
        String oldMsg = new String("");
        String end = new String("");
        String note = new String("");
        Object text = null;
        String oldText = null;
        char[] buffer = new char[1024];
        oldText = this.account.getText();
        try {
            this.bwrite = new BufferedWriter(new FileWriter(file.getAbsolutePath()));
            switch (parm) {
                case 0: {
                    this.out.writeBytes(String.valueOf(String.valueOf("RETR ").concat(String.valueOf(msgnum))).concat(String.valueOf("\r\n")));
                    break;
                }
                case 4: {
                    this.out.writeBytes(String.valueOf(String.valueOf("TOP ").concat(String.valueOf(msgnum))).concat(String.valueOf(" 50\r\n")));
                    break;
                }
                case 3: {
                    this.out.writeBytes(String.valueOf(String.valueOf("TOP ").concat(String.valueOf(msgnum))).concat(String.valueOf(" 1\r\n")));
                }
            }
            this.inchar = this.in.readLine();
            if (this.inchar.length() > 0 && this.inchar.charAt(0) == '+') {
                ret_code = true;
                bytes = Pop3Retrieve.parseBytes(this.inchar);
                do {
                    if ((buflen = this.in.read(buffer, 0, buffer.length)) <= 0) continue;
                    read += buflen;
                    if (bytes == (long)0) {
                        this.account.setText(String.valueOf(String.valueOf(String.valueOf(oldText).concat(String.valueOf(" ("))).concat(String.valueOf(read))).concat(String.valueOf(" bytes)")));
                    } else if ((long)read <= bytes) {
                        this.account.setText(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(oldText).concat(String.valueOf(" ("))).concat(String.valueOf((int)((double)read / (double)bytes * (double)100)))).concat(String.valueOf("% of "))).concat(String.valueOf(bytes))).concat(String.valueOf(")")));
                    }
                    note = new String(String.valueOf(note).concat(String.valueOf(new String(buffer, 0, buflen))));
                    end = note.length() > 10 ? new String(note.substring(note.length() - 10)) : new String(String.valueOf(end).concat(String.valueOf(note)));
                    if (note.length() <= 40000) continue;
                    this.bwrite.write(MailMsg.fixMessage(note));
                    note = null;
                    note = new String("");
                } while (!this.account.getStop() && !end.endsWith("\n.\r\n") && !end.endsWith("\n.\n"));
                this.bwrite.write(MailMsg.fixMessage(note));
            }
            this.bwrite.close();
            this.bwrite = null;
            if (ret_code) {
                pop = new PopFileProcedure();
                pop.readHeaders(file);
                pop.setBytes(bytes);
            }
        }
        catch (IOException e) {
            MsgBox msgBox = new MsgBox(this.frame, String.valueOf("Error").concat(String.valueOf(e)));
        }
        return pop;
    }

    public static long parseBytes(String text) {
        long bytes = 0L;
        int start = 0;
        int end = 0;
        start = text.indexOf("(");
        if (start < 0) {
            start = text.indexOf(" ");
        }
        if (start > 0) {
            end = text.indexOf(" ", start + 1);
            if (end < 0) {
                end = text.indexOf("(", start + 1);
            }
            if (Pop3Retrieve.isNumeric(text = end > start ? new String(text.substring(start + 1, end)) : new String(text.substring(start + 1)))) {
                bytes = Long.valueOf(text);
            }
        }
        return bytes;
    }

    public static boolean isNumeric(String text) {
        boolean ret_code = true;
        char[] chars = text.toCharArray();
        if (chars != null && chars.length > 0) {
            for (int i = 0; i < chars.length; ++i) {
                if (Character.isDigit(chars[i])) continue;
                ret_code = false;
                break;
            }
        } else {
            ret_code = false;
        }
        return ret_code;
    }

    public boolean deleteMessage(int msgnum) {
        boolean ret_code = false;
        try {
            this.out.writeBytes(String.valueOf(String.valueOf("DELE ").concat(String.valueOf(msgnum))).concat(String.valueOf("\r\n")));
            this.inchar = this.in.readLine();
            if (this.inchar.length() > 0 && this.inchar.charAt(0) == '+') {
                ret_code = true;
            }
        }
        catch (IOException e) {
            MsgBox msgBox = new MsgBox(this.frame, String.valueOf("Error").concat(String.valueOf(e)));
        }
        return ret_code;
    }

    public boolean Logon() {
        boolean ret_code = false;
        this.account.setText("Connecting to message server...");
        try {
            this.socket = this.connectSocket();
            if (!this.account.getStop() && this.socket != null) {
                this.account.setText("Logging on to message server...");
                this.in = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
                this.inchar = this.in.readLine();
                if (!this.account.getStop() && this.inchar.charAt(0) == '+') {
                    this.out = new DataOutputStream(this.socket.getOutputStream());
                    this.account.setText("Issuing USER command...");
                    this.out.writeBytes(String.valueOf(String.valueOf("USER ").concat(String.valueOf(this.userid))).concat(String.valueOf("\r\n")));
                    this.inchar = this.in.readLine();
                    if (!this.account.getStop() && this.inchar.charAt(0) == '+') {
                        this.account.setText("Issuing PASS command...");
                        this.out.writeBytes(String.valueOf(String.valueOf("PASS ").concat(String.valueOf(this.password))).concat(String.valueOf("\r\n")));
                        this.inchar = this.in.readLine();
                        if (!this.account.getStop() && this.inchar.charAt(0) == '+') {
                            ret_code = true;
                        } else if (!this.account.getStop()) {
                            MsgBox msgBox = new MsgBox(this.frame, String.valueOf("Pop3 Error: ").concat(String.valueOf(this.inchar)));
                        }
                    } else if (!this.account.getStop()) {
                        MsgBox msgBox = new MsgBox(this.frame, String.valueOf("Pop3 Error: ").concat(String.valueOf(this.inchar)));
                    }
                } else if (!this.account.getStop()) {
                    MsgBox msgBox = new MsgBox(this.frame, String.valueOf("Pop3 Error: ").concat(String.valueOf(this.inchar)));
                }
            } else if (!this.account.getStop()) {
                MsgBox msgBox = new MsgBox(this.frame, "No connection could be established with your POP3 server.");
            }
        }
        catch (IOException e) {
            MsgBox msgBox = new MsgBox(this.frame, String.valueOf("Error").concat(String.valueOf(e)));
        }
        if (this.account.getStop()) {
            this.account.setText("Logon was halted.");
        } else if (!ret_code) {
            this.account.setText("Logon Unsuccessful.");
            this.Logoff();
        } else {
            this.account.setText("Logon Successful.");
        }
        return ret_code;
    }

    public Socket connectSocket() {
        Socket socket = null;
        ConnectSocketThread thread = new ConnectSocketThread(this.frame, this.server, this.port);
        String oldText = this.account.getText();
        try {
            thread.start();
            for (int i = this.connectTime; i > 0; --i) {
                thread.join(1000L);
                if (!this.account.getStop()) {
                    this.account.setText(String.valueOf(String.valueOf(String.valueOf(oldText).concat(String.valueOf(" [Timeout in: "))).concat(String.valueOf(i))).concat(String.valueOf(" seconds]")));
                }
                if (!thread.isAlive() || this.account.getStop()) break;
            }
            this.account.setText(oldText);
            if (thread.isAlive()) {
                thread.stop();
                if (!this.account.getStop()) {
                    MsgBox msgBox = new MsgBox(this.frame, String.valueOf(String.valueOf("Connection attempt timed out after ").concat(String.valueOf(this.connectTime))).concat(String.valueOf(" seconds.")));
                }
            }
            if (!this.account.getStop()) {
                socket = thread.getSocket();
            }
        }
        catch (InterruptedException e) {
            MsgBox msgBox = new MsgBox(this.frame, String.valueOf("Error: ").concat(String.valueOf(e)));
        }
        return socket;
    }

    public void Logoff() {
        boolean ret_code = false;
        if (this.socket != null) {
            try {
                if (this.in != null && this.out != null) {
                    this.out.writeBytes("QUIT\r\n");
                    this.inchar = this.in.readLine();
                }
                this.socket.close();
            }
            catch (IOException e) {
                MsgBox msgBox = new MsgBox(this.frame, String.valueOf("Error").concat(String.valueOf(e)));
            }
        }
        this.in = null;
        this.out = null;
        this.socket = null;
    }
}

