/*
 * Decompiled with CFR 0.152.
 */
package innoval.popper;

import innoval.mailer.AutoRefresh;
import innoval.mailer.JBevelPanel;
import innoval.mailer.JstreetAudioClip;
import innoval.mailer.MsgBox;
import innoval.mailer.Profile;
import innoval.mailer.SendItem;
import innoval.mailer.SettingsAdvanced;
import innoval.mailer.SettingsGeneral;
import innoval.mailer.jstreet;
import innoval.popper.Imap4Retrieve;
import innoval.popper.Pop3Retrieve;
import innoval.popper.Popper;
import innoval.popper.PopperAccountThread;
import innoval.popper.PpoRetrieve;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;

public class PopperAccount {
    static final String SAVENAME = new String("PopperAccount");
    static final String SAVEMSGDATE = new String("LastMessageFound");
    private Label nameField;
    private Label lastDateField;
    private Label messageDateField;
    private Label intervalField;
    private Label messagesField;
    public Label text;
    private Panel panel = null;
    private boolean check = false;
    private boolean auto = false;
    private File dir;
    public PopperAccountThread thread;
    private Popper frame;
    private String account;
    private String lastDate;
    private String messageDate;
    private int interval;
    private int messages;
    private File outDir;
    private Profile profile;
    private boolean stop = false;

    PopperAccount(Popper frame, String dir, String account) {
        this.account = new String(account);
        this.frame = frame;
        this.dir = new File(account);
        if (!this.dir.exists()) {
            this.dir = new File(dir, account);
        }
        this.initAccount();
    }

    private void initAccount() {
        String pfile = new String(String.valueOf(String.valueOf(this.dir).concat(String.valueOf(File.separator))).concat(String.valueOf(jstreet.PROFILENAME)));
        if (new File(pfile).exists()) {
            this.profile = new Profile(this.frame, pfile);
            this.auto = this.readAuto();
            this.interval = this.readInterval();
            this.messageDate = this.readMessageDate();
        }
    }

    public String getName() {
        return this.account;
    }

    public Profile getProfile() {
        return this.profile;
    }

    public File getAccountDir() {
        return this.dir;
    }

    public File getDir() {
        return this.outDir;
    }

    public void setCheck(boolean check) {
        this.check = check;
    }

    public boolean getCheck() {
        return this.check;
    }

    public void readProfile() {
        if (this.profile != null) {
            this.profile.readProfile();
        }
    }

    private boolean readAuto() {
        boolean ret_code = false;
        if (this.profile != null) {
            ret_code = Boolean.valueOf(this.profile.ReadString(SettingsGeneral.SAVEGENERAL, SettingsGeneral.RETRAUTO, "false"));
        }
        return ret_code;
    }

    private int readInterval() {
        int num = 0;
        if (this.profile != null) {
            try {
                num = Integer.valueOf(this.profile.ReadString(SettingsGeneral.SAVEGENERAL, SettingsGeneral.AUTOMINUTES, "0"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return num;
    }

    private String readMessageDate() {
        String text = "";
        if (this.profile != null) {
            text = this.profile.ReadString(SAVENAME, SAVEMSGDATE, "");
        }
        return text;
    }

    public boolean isAuto() {
        this.auto = this.readAuto();
        return this.auto;
    }

    public Panel setupPanel() {
        this.panel = new Panel();
        Label label = null;
        this.panel.setBackground(Color.lightGray);
        GridBagLayout grid = new GridBagLayout();
        int[] rowHeights = new int[]{5, 10, 1, 10, 1, 10, 1, 10, 5, 1};
        int[] columnWidths = new int[]{5, 30, 5, 20, 5, 200, 5, 30, 5, 30, 5, 5};
        double[] rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.0};
        double[] columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.0};
        grid.rowHeights = rowHeights;
        grid.columnWidths = columnWidths;
        grid.rowWeights = rowWeights;
        grid.columnWeights = columnWeights;
        GridBagConstraints con = new GridBagConstraints();
        label = new Label("Account Name:", 2);
        this.panel.add(label);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 1;
        con.gridwidth = 3;
        grid.setConstraints(label, con);
        this.nameField = new Label(this.account);
        this.panel.add(this.nameField);
        jstreet.reset(con);
        con.gridx = 5;
        con.gridy = 1;
        grid.setConstraints(this.nameField, con);
        label = new Label("Interval:", 2);
        this.panel.add(label);
        jstreet.reset(con);
        con.gridx = 7;
        con.gridy = 1;
        grid.setConstraints(label, con);
        this.intervalField = new Label(String.valueOf("").concat(String.valueOf(this.interval)));
        this.panel.add(this.intervalField);
        jstreet.reset(con);
        con.gridx = 9;
        con.gridy = 1;
        grid.setConstraints(this.intervalField, con);
        label = new Label("Last Retrieval Attempt:", 2);
        this.panel.add(label);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 3;
        con.gridwidth = 3;
        grid.setConstraints(label, con);
        this.lastDateField = new Label(this.lastDate);
        this.panel.add(this.lastDateField);
        jstreet.reset(con);
        con.gridx = 5;
        con.gridy = 3;
        grid.setConstraints(this.lastDateField, con);
        label = new Label("Newest Message Found:", 2);
        this.panel.add(label);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 5;
        con.gridwidth = 3;
        grid.setConstraints(label, con);
        this.messageDateField = new Label(this.messageDate);
        this.panel.add(this.messageDateField);
        jstreet.reset(con);
        con.gridx = 5;
        con.gridy = 5;
        grid.setConstraints(this.messageDateField, con);
        label = new Label("Messages:", 2);
        this.panel.add(label);
        jstreet.reset(con);
        con.gridx = 7;
        con.gridy = 5;
        grid.setConstraints(label, con);
        this.messagesField = new Label(String.valueOf("").concat(String.valueOf(this.messages)));
        this.panel.add(this.messagesField);
        jstreet.reset(con);
        con.gridx = 9;
        con.gridy = 5;
        grid.setConstraints(this.messagesField, con);
        label = new Label("Status:", 2);
        this.panel.add(label);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 7;
        grid.setConstraints(label, con);
        this.text = new Label("");
        this.panel.add(this.text);
        jstreet.reset(con);
        con.gridx = 3;
        con.gridy = 7;
        con.gridwidth = 7;
        grid.setConstraints(this.text, con);
        JBevelPanel rect = new JBevelPanel();
        rect.setBevelInner(2);
        rect.setBevelOuter(2);
        rect.setPreferredSize(50, 50);
        this.panel.add(rect);
        jstreet.reset(con);
        con.gridx = 0;
        con.gridy = 0;
        con.gridwidth = 11;
        con.gridheight = 9;
        grid.setConstraints(rect, con);
        this.panel.setLayout(grid);
        this.changePanelColor(this.panel, false);
        return this.panel;
    }

    private void checkPanelSize(Panel panel, int cy) {
        if (panel.getSize().height < cy) {
            panel.setSize(panel.getSize().width, cy);
        }
    }

    private void updateMessageDate() {
        this.messageDate = SendItem.getPopDate();
        this.messageDateField.setText(this.messageDate);
        if (this.profile != null) {
            this.profile.WriteString(SAVENAME, SAVEMSGDATE, this.messageDate, true);
        }
    }

    private void updateLastDate() {
        this.lastDate = SendItem.getPopDate();
        this.lastDateField.setText(this.lastDate);
    }

    public void updateMessages() {
        int num = this.countMessages();
        if (num > this.messages) {
            this.updateMessageDate();
        }
        this.messages = num;
        this.messagesField.setText(String.valueOf("").concat(String.valueOf(this.messages)));
    }

    public int countMessages() {
        String[] file;
        int num = 0;
        if (this.outDir != null && this.outDir.exists() && (file = this.outDir.list()) != null) {
            num = file.length;
        }
        return num;
    }

    public void setStop(boolean stop) {
        this.stop = stop;
        if (this.thread != null) {
            this.thread.setStop(stop);
        }
    }

    public boolean getStop() {
        return this.stop;
    }

    public void start() {
        if (this.thread == null) {
            this.outDir = new File(this.frame.getRootDir(), this.account);
            if (!this.outDir.exists()) {
                this.outDir.mkdir();
            }
            if (this.outDir.exists()) {
                this.messages = this.countMessages();
                this.messagesField.setText(String.valueOf("").concat(String.valueOf(this.messages)));
                this.stop = false;
                this.thread = new PopperAccountThread(this);
                this.thread.start();
            } else {
                MsgBox msgBox = new MsgBox(this.frame, String.valueOf(String.valueOf(String.valueOf("Error creating Popper account directory [").concat(String.valueOf(this.outDir.getAbsolutePath()))).concat(String.valueOf("].\n\n"))).concat(String.valueOf("The account cannot be started.")));
            }
        }
    }

    public void setText(String str) {
        this.text.setText(str);
    }

    public String getText() {
        return this.text.getText();
    }

    public void refresh() {
        this.setText("Waiting to check account for new mail...");
        this.frame.refreshAccount(this);
        this.updateMessages();
        this.setText("Retrieve completed.");
    }

    public void retrieveMail() {
        this.setText("Checking for new mail...");
        this.updateLastDate();
        this.readProfile();
        this.retrieveMessages();
    }

    private void retrieveComplete() {
        if (Boolean.valueOf(this.profile.ReadString(SettingsGeneral.SAVEGENERAL, SettingsGeneral.PLAYTUNE, "false")).booleanValue()) {
            try {
                JstreetAudioClip clip = new JstreetAudioClip(this.profile.ReadString(SettingsGeneral.SAVEGENERAL, SettingsGeneral.TUNEFILE, ""));
                clip.play();
                clip = null;
            }
            catch (IOException er) {
                System.out.println(String.valueOf("Error: ").concat(String.valueOf(er)));
                Toolkit.getDefaultToolkit().beep();
            }
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    private void changePanelColor(Container cont, boolean val) {
        Color back = Color.darkGray;
        Color fore = Color.white;
        if (!val) {
            back = Color.lightGray;
            fore = Color.black;
        }
        cont.setBackground(back);
        cont.setForeground(fore);
        Component ccomp = null;
        for (int i = 0; i < cont.getComponentCount(); ++i) {
            ccomp = cont.getComponent(i);
            if (ccomp instanceof Container) {
                this.changePanelColor((Container)ccomp, val);
            }
            ccomp.setBackground(back);
            ccomp.setForeground(fore);
        }
    }

    private void retrieveMessages() {
        this.changePanelColor(this.panel, true);
        this.setText("Retrieving messages...");
        int notes = 0;
        if (Boolean.valueOf(this.profile.ReadString(SettingsAdvanced.SAVEADVANCED, SettingsAdvanced.PPOINACTIVE, "false")).booleanValue()) {
            this.setText("[PPO] Retrieving message data...");
            PpoRetrieve ppoin = new PpoRetrieve(this.frame, this);
            ppoin.setExt(this.profile.ReadString(SettingsAdvanced.SAVEADVANCED, SettingsAdvanced.PPOINEXTS, "pop"));
            ppoin.setDelete(Boolean.valueOf(this.profile.ReadString(SettingsGeneral.SAVEGENERAL, SettingsGeneral.RETRDELETE, "true")));
            notes = ppoin.getMail();
            ppoin = null;
        } else {
            String user = new String(this.profile.ReadString(SettingsGeneral.SAVEGENERAL, SettingsGeneral.POPUSERID, ""));
            String pw = new String(this.profile.ReadString(SettingsGeneral.SAVEGENERAL, SettingsGeneral.POPPASSWORD, "", 1));
            String serv = new String(this.profile.ReadString(SettingsGeneral.SAVEGENERAL, SettingsGeneral.POPSERVER, ""));
            String port = new String(this.profile.ReadString(SettingsGeneral.SAVEGENERAL, SettingsGeneral.POPPORT, "110"));
            if (serv.trim().length() > 0 && user.trim().length() > 0 && pw.trim().length() > 0) {
                int iport = 0;
                try {
                    iport = Integer.valueOf(port);
                }
                catch (NumberFormatException e) {
                    iport = 110;
                }
                switch (SettingsGeneral.getMailStyle(this.profile)) {
                    case 1: {
                        notes = this.retrieveImapMail(serv, user, pw, iport);
                        break;
                    }
                    default: {
                        notes = this.retrievePopMail(serv, user, pw, iport);
                    }
                }
            }
        }
        if (notes > 0) {
            this.retrieveComplete();
        }
        this.changePanelColor(this.panel, false);
    }

    private int retrievePopMail(String serv, String user, String pw, int iport) {
        int notes = 0;
        Pop3Retrieve pop3Retr = new Pop3Retrieve(this.frame, this);
        pop3Retr.setUserid(user);
        pop3Retr.setPassword(pw);
        pop3Retr.setServer(serv);
        pop3Retr.setPort(iport);
        pop3Retr.setDelete(Boolean.valueOf(this.profile.ReadString(SettingsGeneral.SAVEGENERAL, SettingsGeneral.RETRDELETE, "true")));
        if (Boolean.valueOf(this.profile.ReadString(SettingsGeneral.SAVEGENERAL, SettingsGeneral.RETRNEW, "false")).booleanValue()) {
            pop3Retr.setNewOnly(true);
            int smsg = 0;
            try {
                smsg = Integer.valueOf(this.profile.ReadString(SettingsGeneral.SAVEGENERAL, SettingsGeneral.LASTMESSAGE, "0"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            pop3Retr.setFirstMessage(smsg + 1);
        }
        if (Boolean.valueOf(this.profile.ReadString(SettingsGeneral.SAVEGENERAL, SettingsGeneral.NOTIFYLARGE, "false")).booleanValue()) {
            pop3Retr.setMaxKiloBytes(Integer.valueOf(this.profile.ReadString(SettingsGeneral.SAVEGENERAL, SettingsGeneral.NOTIFYBYTES, "0")));
        }
        notes = pop3Retr.getMail();
        if (Boolean.valueOf(this.profile.ReadString(SettingsGeneral.SAVEGENERAL, SettingsGeneral.RETRNEW, "false")).booleanValue()) {
            this.profile.WriteString(SettingsGeneral.SAVEGENERAL, SettingsGeneral.LASTMESSAGE, String.valueOf("").concat(String.valueOf(pop3Retr.getLastMessage())), true);
        }
        return notes;
    }

    private int retrieveImapMail(String serv, String user, String pw, int iport) {
        int notes = 0;
        Imap4Retrieve imapRetr = new Imap4Retrieve(this.frame, this);
        imapRetr.setUserid(user);
        imapRetr.setPassword(pw);
        imapRetr.setServer(serv);
        imapRetr.setPort(iport);
        imapRetr.setDelete(Boolean.valueOf(this.profile.ReadString(SettingsGeneral.SAVEGENERAL, SettingsGeneral.RETRDELETE, "true")));
        if (Boolean.valueOf(this.profile.ReadString(SettingsGeneral.SAVEGENERAL, SettingsGeneral.RETRNEW, "false")).booleanValue()) {
            imapRetr.setNewOnly(true);
        }
        if (Boolean.valueOf(this.profile.ReadString(SettingsGeneral.SAVEGENERAL, SettingsGeneral.NOTIFYLARGE, "false")).booleanValue()) {
            imapRetr.setMaxKiloBytes(Integer.valueOf(this.profile.ReadString(SettingsGeneral.SAVEGENERAL, SettingsGeneral.NOTIFYBYTES, "0")));
        }
        imapRetr.setMailBox(this.profile.ReadString(SettingsGeneral.SAVEGENERAL, SettingsGeneral.MAILBOXNAME, ""));
        notes = imapRetr.getMail();
        return notes;
    }

    public void cycle(PopperAccountThread thread) {
        int cnt = this.readInterval();
        this.intervalField.setText(String.valueOf("").concat(String.valueOf(cnt)));
        cnt *= 60;
        while (cnt > 0 && !thread.getStop()) {
            this.updateCounterText(cnt);
            AutoRefresh.Sleep(1000L);
            --cnt;
        }
    }

    private void updateCounterText(int secs) {
        int mins = secs / 60;
        int seconds = secs % 60;
        StringBuffer sb = new StringBuffer(100);
        sb.append("Next update in ");
        if (mins > 0) {
            if (mins == 1) {
                sb.append("1 minute");
            } else {
                sb.append(String.valueOf(String.valueOf("").concat(String.valueOf(mins))).concat(String.valueOf(" minutes")));
            }
            if (seconds > 0) {
                sb.append(" and ");
            }
        }
        if (seconds > 0) {
            if (seconds == 1) {
                sb.append("1 second");
            } else {
                sb.append(String.valueOf(String.valueOf("").concat(String.valueOf(seconds))).concat(String.valueOf(" seconds")));
            }
        }
        this.setText(sb.toString());
    }
}

