/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.misc;

import java.net.URL;
import java.util.Date;
import java.util.StringTokenizer;
import sunw.hotjava.misc.RfcDateParser;

public class HttpCookie {
    private Date expirationDate;
    private String nameAndValue;
    private String path;
    private String domain;
    private boolean isSecure = false;

    public HttpCookie(String string) {
        this.parseCookieString(string);
    }

    public HttpCookie(Date date, String string, String string2, String string3, boolean bl) {
        this.expirationDate = date;
        this.nameAndValue = string;
        this.path = string2;
        this.domain = string3;
        this.isSecure = bl;
    }

    HttpCookie(URL uRL, String string) {
        this.parseCookieString(string);
        this.applyDefaults(uRL);
    }

    private void applyDefaults(URL uRL) {
        if (this.domain == null) {
            this.domain = uRL.getHost();
        }
        if (this.path == null) {
            this.path = uRL.getFile();
            int n = this.path.lastIndexOf("/");
            if (n > -1) {
                this.path = this.path.substring(0, n);
            }
        }
    }

    private void parseCookieString(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        stringTokenizer.hasMoreTokens();
        this.nameAndValue = stringTokenizer.nextToken().trim();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (string2.equalsIgnoreCase("secure")) {
                this.isSecure = true;
                continue;
            }
            int n = string2.indexOf("=");
            if (n < 0) continue;
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n + 1);
            if (string3.equalsIgnoreCase("path")) {
                this.path = string4;
                continue;
            }
            if (string3.equalsIgnoreCase("domain")) {
                if (string4.indexOf(".") == 0) {
                    this.domain = string4.substring(1);
                    continue;
                }
                this.domain = string4;
                continue;
            }
            if (!string3.equalsIgnoreCase("expires")) continue;
            this.expirationDate = this.parseExpireDate(string4);
        }
        if (this.expirationDate == null) {
            this.expirationDate = new Date(System.currentTimeMillis() + (long)Integer.parseInt(System.getProperty("hotjava.cookies.default.expiration")));
        }
    }

    public String getNameValue() {
        return this.nameAndValue;
    }

    public String getName() {
        int n = this.nameAndValue.indexOf("=");
        return this.nameAndValue.substring(0, n);
    }

    public String getDomain() {
        return this.domain;
    }

    public String getPath() {
        return this.path;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    boolean hasExpired() {
        return this.expirationDate != null && this.expirationDate.getTime() <= System.currentTimeMillis();
    }

    boolean isSaveable() {
        return this.expirationDate != null && this.expirationDate.getTime() > System.currentTimeMillis();
    }

    public boolean isSecure() {
        return this.isSecure;
    }

    private Date parseExpireDate(String string) {
        RfcDateParser rfcDateParser = new RfcDateParser(string);
        Date date = rfcDateParser.getDate();
        if (date == null) {
            date = new Date(System.currentTimeMillis() + (long)Integer.parseInt(System.getProperty("hotjava.cookies.default.expiration")));
        }
        return date;
    }

    public String toString() {
        String string = this.nameAndValue;
        if (this.expirationDate != null) {
            string = String.valueOf(string) + "; expires=" + this.expirationDate;
        }
        if (this.path != null) {
            string = String.valueOf(string) + "; path=" + this.path;
        }
        if (this.domain != null) {
            string = String.valueOf(string) + "; domain=" + this.domain;
        }
        if (this.isSecure) {
            string = String.valueOf(string) + "; secure";
        }
        return string;
    }
}

