/*
 * Decompiled with CFR 0.152.
 */
package com.jthomas.javafaces;

import com.jthomas.javafaces.FaceOptions;
import com.jthomas.javafaces.MsgDialog;
import com.jthomas.util.Debug;
import com.jthomas.util.Queue;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import sun.applet.AppletAudioClip;

public class FaceAudio
implements Runnable {
    private static FaceAudio _FaceAudio;
    private Queue _Queue = new Queue(16);
    private boolean _Active = false;

    public FaceAudio() {
        _FaceAudio = this;
    }

    public void run() {
        this._Active = FaceOptions.getRef().getBoolean("AudioSupport", true);
        if (!this._Active) {
            Debug.out("FaceAudio is not active");
            return;
        }
        Debug.out("FaceAudio.run():");
        try {
            try {
                while (true) {
                    String audiourl = (String)this._Queue.get();
                    Debug.out("Playing " + audiourl);
                    this.play(audiourl);
                }
            }
            catch (Exception e) {
                Debug.out("FaceAudio: Exception in run(); ", e);
                Object var3_3 = null;
                Debug.out("Entered FaceAudio finally clause. Terminating Thread");
                this._Active = false;
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            Debug.out("Entered FaceAudio finally clause. Terminating Thread");
            this._Active = false;
            throw throwable;
        }
    }

    public void queuePut(Object obj) {
        if (this._Active) {
            this._Queue.put(obj);
        }
    }

    private void play(String urlstr) {
        URL audioURL = null;
        String filename = null;
        if (urlstr.startsWith("file:./")) {
            filename = urlstr.substring(7);
        }
        if (urlstr.startsWith("file:")) {
            filename = urlstr.substring(5);
            while (filename.startsWith("/")) {
                filename = filename.substring(1);
            }
        } else {
            MsgDialog.create("Audio file " + urlstr + " must be a local file.");
            return;
        }
        File file = new File(filename);
        if (!file.exists()) {
            MsgDialog.create("Selected local audio file " + urlstr + "does not exist.");
            return;
        }
        urlstr = "file:///" + file.getAbsolutePath().replace(File.separatorChar, '/');
        Debug.out("url=" + urlstr + " filename=" + filename);
        try {
            Debug.out(urlstr);
            audioURL = new URL(urlstr);
        }
        catch (MalformedURLException malformedURLException) {
            MsgDialog.create("Invalid Audio specification:\n  " + urlstr);
        }
        if (audioURL != null) {
            Debug.out(audioURL.toString());
            AppletAudioClip audioClip = new AppletAudioClip(audioURL);
            audioClip.play();
            try {
                Thread.sleep(5000L);
            }
            catch (Exception exception) {}
        } else {
            MsgDialog.create("Null Audio specification:\n  " + urlstr);
        }
    }

    public static void main(String[] argv) {
        Debug.setDebugOn(true);
        String url = "file:///d:/javacode/javafaces20/images/chirp.au";
        if (argv.length > 0) {
            url = argv[0];
        }
        FaceAudio fa = new FaceAudio();
        fa.play(url);
    }
}

