/*
 * Decompiled with CFR 0.152.
 */
package com.jthomas.javafaces;

import com.jthomas.util.Debug;
import java.io.File;
import java.net.URL;
import java.util.Date;
import java.util.StringTokenizer;

class FaceCacheEntry {
    String _User;
    String _Host;
    String _URL;
    String _CacheURL;
    private Date _Created;
    private Date _LastUsed;
    private Date _Verified;
    private boolean _Expired;

    FaceCacheEntry(String url, String host, String user, String pathurl) {
        this._User = user;
        this._Host = host;
        this._URL = url;
        this._CacheURL = pathurl;
        this._Created = new Date();
        this._LastUsed = new Date();
        this._Verified = new Date();
    }

    FaceCacheEntry(String entry) {
        String[] tokens = new String[10];
        StringTokenizer st = new StringTokenizer(entry);
        int i = 0;
        while (st.hasMoreTokens()) {
            tokens[i] = st.nextToken();
            if (tokens[i].equals("null")) {
                tokens[i] = null;
            }
            ++i;
        }
        this._URL = tokens[0];
        this._User = tokens[1];
        this._Host = tokens[2];
        this._CacheURL = tokens[3];
        try {
            this._Created = new Date(Long.parseLong(tokens[4]));
            this._LastUsed = new Date(Long.parseLong(tokens[5]));
            this._Verified = tokens[6] != null ? new Date(Long.parseLong(tokens[6])) : this._Created;
        }
        catch (Exception e) {
            Debug.out(e);
            Debug.out("Cache Entry had bad date. Replace with today's date");
            this._Created = new Date();
            this._LastUsed = new Date();
            this._Verified = new Date();
        }
    }

    public String toString() {
        return String.valueOf(this._URL) + " " + this._User + " " + this._Host + " " + this._CacheURL;
    }

    public String dump() {
        return String.valueOf(this._URL) + " " + this._User + " " + this._Host + " " + this._CacheURL + " " + Long.toString(this._Created.getTime()) + " " + Long.toString(this._LastUsed.getTime()) + " " + Long.toString(this._Verified.getTime()) + "\n";
    }

    public String list() {
        StringBuffer sb = new StringBuffer(100);
        sb.append(String.valueOf(this._User) + " @ " + this._Host + " URL=" + this._URL + " Created: " + this._Created.toString() + " Verified: " + this._Verified.toString() + " Used: " + this._LastUsed.toString());
        sb.append("\n");
        try {
            if (this._CacheURL != null) {
                sb.append("  CachedImage: '" + this._CacheURL + "'");
                File image = new File(new URL(this._CacheURL).getFile());
                if (!image.exists()) {
                    sb.append(" <<-- Cached Image file does not exist");
                }
            }
        }
        catch (Exception exception) {
            Debug.out("FaceCacheEntry:list() Failed listing " + this._CacheURL);
        }
        return sb.toString();
    }

    public boolean checkExpire(Date unusedDate) {
        return unusedDate.after(this._LastUsed);
    }

    public boolean checkVerify(Date verifyDate) {
        if (verifyDate.after(this._Verified)) {
            this._Verified = new Date();
            return true;
        }
        return false;
    }

    public void reference() {
        this._LastUsed = new Date();
    }

    public boolean getExpired() {
        return this._Expired;
    }

    public void setExpired(boolean truefalse) {
        this._Expired = truefalse;
    }
}

