/*
 * Decompiled with CFR 0.152.
 */
package com.jthomas.javafaces;

import com.jthomas.javafaces.FaceBoard;
import com.jthomas.javafaces.FaceCache;
import com.jthomas.javafaces.FaceEvent;
import com.jthomas.javafaces.FaceEventListener;
import com.jthomas.javafaces.FaceMailboxException;
import com.jthomas.javafaces.FaceOptions;
import com.jthomas.javafaces.FaceResolver;
import com.jthomas.javafaces.FaceServer;
import com.jthomas.javafaces.FaceStatusLabel;
import com.jthomas.javafaces.JavaFaces;
import com.jthomas.javafaces.Mailmsg;
import com.jthomas.javafaces.MsgDialog;
import com.jthomas.util.Debug;
import com.jthomas.util.Log;
import java.util.Enumeration;
import java.util.Hashtable;

public abstract class FaceMailbox
implements Runnable {
    private JavaFaces _JavaFaces;
    private FaceBoard _FaceBoard;
    private String _DefaultAudioURL;
    protected int _Count;
    protected FaceOptions _Options;
    protected FaceServer _Server;
    protected FaceCache _Cache;
    private FaceResolver _Resolver;
    protected String _Type;
    protected String _Host;
    protected String _User;
    protected String _Password;
    private Hashtable _Mailmsgs;
    protected int _MailboxMsgCount;
    private int _OldMsgCount;
    private int _Passes;
    protected boolean _Modified;

    protected FaceMailbox() {
    }

    public void init() {
        Debug.out("FaceMailbox.init():");
        this._JavaFaces = JavaFaces.getRef();
        Debug.out("access Cache");
        this._Cache = this._JavaFaces.getCacheRef();
        Debug.out("access FaceBoard");
        this._FaceBoard = this._JavaFaces.getFaceBoardRef();
        Debug.out("access Resolver");
        this._Resolver = this._JavaFaces.getResolverRef();
        Debug.out("create Hashtable");
        this._Mailmsgs = new Hashtable(100);
        Debug.out("refresh Options");
        this.refreshOptions();
        this._JavaFaces.addFaceEventListener(new 1());
        Debug.out("Init ended");
    }

    public void run() {
        Debug.out("FaceMailbox.run()");
        boolean done = false;
        boolean checkmail = true;
        this._MailboxMsgCount = -1;
        this._OldMsgCount = 0;
        try {
            while (!done) {
                ++this._Passes;
                if (this._JavaFaces._FlagQuitMail) {
                    this.terminate();
                    break;
                }
                if (this._JavaFaces._FlagResetServer) {
                    this.resetMail();
                    this.terminate();
                    break;
                }
                if (this._JavaFaces._FlagResetMail) {
                    this.resetMail();
                    this._JavaFaces._FlagResetMail = false;
                }
                if (checkmail || this._JavaFaces._FlagCheckMail) {
                    this.checkMail();
                    this._JavaFaces._FlagCheckMail = false;
                    checkmail = false;
                }
                if (this._JavaFaces._FlagQuitMail) {
                    this.terminate();
                    break;
                }
                Debug.out("Sleeping " + this._JavaFaces._Delay + " seconds");
                int delaytimes = this._JavaFaces._Delay / 5;
                this._JavaFaces.setBusy(false);
                try {
                    int i = 0;
                    while (i < delaytimes) {
                        Thread.currentThread();
                        Thread.sleep(5000L);
                        if (this._JavaFaces._FlagWakeup) break;
                        ++i;
                    }
                    if (!this._JavaFaces._FlagWakeup) {
                        checkmail = true;
                    } else {
                        this._JavaFaces._FlagWakeup = false;
                    }
                }
                catch (InterruptedException interruptedException) {
                    Debug.out("Interrupted");
                    done = true;
                }
                this._JavaFaces.setBusy(true);
                Debug.out("Awake");
            }
        }
        catch (Exception e) {
            Debug.out("FaceMailbox.run(): ", e);
        }
        Debug.out("FaceMailbox.run() terminated");
    }

    protected synchronized void resetMailmsgs() {
        Debug.out("FaceMailbox.resetMailmsgs()");
        Enumeration enumeration = this._Mailmsgs.elements();
        int i = 0;
        while (enumeration.hasMoreElements()) {
            Mailmsg mailmsg = (Mailmsg)enumeration.nextElement();
            mailmsg.setServerStatus(0);
            ++i;
        }
    }

    private synchronized void checkMail() {
        if (this._Passes == 1 && !this._Server.getLoginInfo()) {
            this._JavaFaces._FlagQuitMail = true;
            Debug.out("User pressed Cancel");
            return;
        }
        boolean opened = this.open();
        while (!opened) {
            Log.out("MailboxOpen", "Mailbox unable to Open");
            FaceStatusLabel.setStatus("Mailbox", "Unable to Open Mailbox");
            if (this._Passes == 1) {
                boolean ok = MsgDialog.create("Failed to open Mail Server\nPress OK to retry or Cancel to Respecify");
                if (!ok) {
                    this._JavaFaces._FlagResetServer = true;
                    this._JavaFaces._FlagQuitMail = true;
                    this._Server.setRespecify(true);
                    return;
                }
                opened = this.open();
                continue;
            }
            return;
        }
        if (this.count() == 0) {
            this.close();
            Debug.out("Mailbox closed - count=0");
            if (this._MailboxMsgCount != 0) {
                this._MailboxMsgCount = 0;
                this._FaceBoard.queuePut("NOMAIL");
                this._Mailmsgs.clear();
            }
        } else {
            try {
                Mailmsg[] mailmsgs = this.getMailmsgs();
                this.delete(mailmsgs);
                if (this.count() == 0) {
                    this._MailboxMsgCount = 0;
                    this._FaceBoard.queuePut("NOMAIL");
                    this._Mailmsgs.clear();
                } else {
                    this.read();
                }
            }
            catch (Exception e) {
                Log.exception(e);
                Debug.out("Exception while processing Mailbox", e);
            }
            this.close();
            if (this._JavaFaces._FlagQuitMail) {
                this.terminate();
                return;
            }
            this._OldMsgCount = this._MailboxMsgCount;
            this._MailboxMsgCount = this.count();
            if (this._MailboxMsgCount == 0) {
                this._MailboxMsgCount = 0;
                this._FaceBoard.queuePut("NOMAIL");
                this._Mailmsgs.clear();
                FaceStatusLabel.setStatus("Mailbox", "No Mail");
            } else if (this.getModified()) {
                this.postProcessMail();
            } else {
                Debug.out("No change in Mailbox");
                FaceStatusLabel.clearStatus("Mailbox");
            }
        }
    }

    public void refreshOptions() {
        this._Type = this._Server.getType();
        this._Host = this._Server.getHost();
        this._User = this._Server.getUser();
        this._Password = this._Server.getPass();
        this._DefaultAudioURL = this._Options.get("DefaultAudioURL", null);
    }

    protected boolean verifyLoginInfo() {
        if (this._Server != null) {
            return this._Server.verifyLoginInfo();
        }
        return false;
    }

    private void resetMail() {
        Debug.out("FaceMailbox.resetMail():  ");
        this._FaceBoard.queuePut("RESET");
        this._Mailmsgs.clear();
        this._MailboxMsgCount = -1;
    }

    private void postProcessMail() {
        FaceStatusLabel.setStatus("Mailbox", "Process Mail");
        Debug.out("Count old=" + this._OldMsgCount + " new=" + this._MailboxMsgCount);
        Mailmsg[] mailmsgs = this.getMailmsgs();
        int i = 0;
        while (i < mailmsgs.length) {
            if (this._JavaFaces._FlagQuitMail) break;
            Mailmsg mailmsg = mailmsgs[i];
            if (mailmsg.getServerStatus() == 0) {
                this.removeMailmsg(mailmsg);
                this.setModified(true);
            }
            ++i;
        }
        if (this.getModified() && this._JavaFaces._FlagAudio && this._DefaultAudioURL != null) {
            this._JavaFaces.getFaceAudioRef().queuePut(this._DefaultAudioURL);
            Debug.out("Audio Play:" + this._DefaultAudioURL);
        }
        FaceStatusLabel.clearStatus("Mailbox");
    }

    protected void addMailmsg(String key, Mailmsg mailmsg) {
        Debug.out("FaceMailbox.addMailmsg(): " + key + ":" + mailmsg);
        this._Mailmsgs.put(key, mailmsg);
        mailmsg.setAction(5);
        this._Resolver.queuePut(mailmsg);
        Debug.out("added");
    }

    protected void removeMailmsg(Mailmsg mailmsg) {
        Debug.out("FaceMailbox.removeMailmsg(): " + mailmsg.getKey());
        mailmsg.setAction(4);
        this._FaceBoard.queuePut(mailmsg);
        this._Mailmsgs.remove(mailmsg.getKey());
    }

    protected Mailmsg getMailmsg(String key) {
        Debug.out("FaceMailbox.getMailmsg(): " + key);
        return (Mailmsg)this._Mailmsgs.get(key);
    }

    protected synchronized Mailmsg[] getMailmsgs() {
        Debug.out("FaceMailbox.getMailmsgs()");
        Mailmsg[] mailmsgs = new Mailmsg[this._Mailmsgs.size()];
        Enumeration enumeration = this._Mailmsgs.elements();
        int i = 0;
        while (enumeration.hasMoreElements()) {
            mailmsgs[i] = (Mailmsg)enumeration.nextElement();
            ++i;
        }
        return mailmsgs;
    }

    public int count() {
        return this._Count;
    }

    public void setModified(boolean modified) {
        this._Modified = modified;
    }

    public boolean getModified() {
        return this._Modified;
    }

    public abstract boolean open();

    public abstract void read();

    public abstract boolean delete(Mailmsg[] var1) throws FaceMailboxException;

    public abstract void close();

    public abstract void terminate();

    private final class 1
    implements FaceEventListener {
        public void actionPerformed(FaceEvent e) {
            if (e.getID() == 20) {
                FaceMailbox.this.refreshOptions();
            }
        }

        /* synthetic */ 1() {
        }
    }
}

