/*
 * Decompiled with CFR 0.152.
 */
package com.jthomas.javafaces;

import com.jthomas.javafaces.FaceOptions;
import com.jthomas.javafaces.Mailmsg;
import com.jthomas.javafaces.MsgDialog;
import com.jthomas.util.Debug;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import starwave.util.regexp.MalformedRegexpException;
import starwave.util.regexp.Regexp;
import starwave.util.regexp.Result;

public class FaceSelect {
    private String[] _SelectList;
    private Regexp[] _SelectRegexp;
    private String[] _SelectHeader;
    private String[] _SelectImageURL;
    private String[] _SelectAudioURL;
    private int _SelectCount;
    private String _Type;

    public FaceSelect(String type) {
        this._Type = type.toUpperCase();
    }

    public void setup() {
        this._SelectList = FaceOptions.getRef().getList(this._Type);
        this._SelectCount = 0;
        int n = this._SelectList.length;
        this._SelectRegexp = new Regexp[n];
        this._SelectHeader = new String[n];
        this._SelectImageURL = new String[n];
        this._SelectAudioURL = new String[n];
        int k = 0;
        int i = 0;
        while (i < this._SelectList.length) {
            String errorMsg;
            String[] tokens = this.parseStatement(this._SelectList[i]);
            if (tokens[4] != null) {
                errorMsg = "Select entry " + i + ":\n" + "Too many parameters.\n" + this._SelectList[i];
                MsgDialog.create(errorMsg);
            } else {
                try {
                    this._SelectRegexp[k] = Regexp.compile(tokens[1]);
                }
                catch (MalformedRegexpException malformedRegexpException) {
                    this._SelectRegexp[k] = null;
                }
                if (this._SelectRegexp[k] == null) {
                    errorMsg = "Select entry " + i + ":\n" + "Error in Regular Expression. \"" + tokens[1] + "\" \n" + this._SelectList[i];
                    MsgDialog.create(errorMsg);
                } else {
                    this._SelectHeader[k] = tokens[0];
                    this._SelectImageURL[k] = tokens[2];
                    this._SelectAudioURL[k] = tokens[3];
                    ++k;
                }
            }
            ++i;
        }
        this._SelectCount = k;
    }

    private String[] parseStatement(String statement) {
        String[] tokens;
        block7: {
            int MAX = 5;
            int n = 0;
            tokens = new String[MAX];
            StringReader sr = new StringReader(statement);
            StreamTokenizer tokenstream = new StreamTokenizer(sr);
            tokenstream.quoteChar(34);
            tokenstream.slashSlashComments(false);
            tokenstream.slashStarComments(false);
            try {
                StringBuffer value = new StringBuffer();
                while (tokenstream.nextToken() != -1) {
                    if (n >= MAX) break;
                    switch (tokenstream.ttype) {
                        case -3: {
                            tokens[n] = tokenstream.sval.trim();
                            ++n;
                            break;
                        }
                        case 34: {
                            tokens[n] = tokenstream.sval.trim();
                            ++n;
                            break;
                        }
                        default: {
                            String errorMsg = "Error parsing Statement: " + statement + "\n" + "Found unquoted char: " + (char)tokenstream.ttype;
                            MsgDialog.create(errorMsg);
                            break block7;
                        }
                    }
                }
            }
            catch (IOException iOException) {
                Debug.out("Error parsing Statement: " + statement);
                String errorMsg = "Error parsing Statement: " + statement;
                MsgDialog.create(errorMsg);
            }
        }
        return tokens;
    }

    public int selectImage(Mailmsg mailmsg) {
        Object imageurl = null;
        int found = -1;
        int i = 0;
        while (i < this._SelectCount && found == -1) {
            int pos;
            Result result;
            String buffer = mailmsg.getHeader(this._SelectHeader[i]);
            if (buffer != null && (result = this._SelectRegexp[i].searchForward(buffer, pos = 0)) != null) {
                Debug.out("Matched " + this._SelectRegexp[i].toString() + " with " + this._SelectHeader[i] + ":" + buffer);
                found = i;
            }
            ++i;
        }
        return found;
    }

    public String getImageURL(int found) {
        return this._SelectImageURL[found];
    }

    public String getAudioURL(int found) {
        return this._SelectAudioURL[found];
    }
}

