/*
 * Decompiled with CFR 0.152.
 */
package com.jthomas.javafaces;

import com.jthomas.util.Debug;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Label;
import java.util.Enumeration;
import java.util.Stack;

public class FaceStatusLabel
extends Label {
    private static final int MINWIDTH = 100;
    private static FaceStatusLabel _StatusLabel;
    private static boolean _FaceStatusFlag;
    private int _Width;
    private int _Height;
    private String _Message = "Status";
    private String _MessageKey = "";
    private static Stack _MessageStack;
    private FontMetrics _FM;

    public FaceStatusLabel() {
        super("Starting JavaFaces");
        this.setBackground(new Color(13808780));
        Font font = new Font("Dialog", 1, 12);
        this.setFont(font);
        this._FM = this.getFontMetrics(font);
        this._Height = this._FM.getHeight();
        this._Width = 100;
        _StatusLabel = this;
    }

    public static FaceStatusLabel getRef() {
        return _StatusLabel;
    }

    public static synchronized void setStatus(String key, String statusinfo) {
        Debug.out("FaceStatusLabel.setStatus: " + key + ";" + statusinfo);
        if (_StatusLabel == null) {
            Debug.out("StatusLabel has not yet been created");
            return;
        }
        String[] status = new String[]{key, statusinfo};
        FaceStatusLabel.removemsg(key);
        _MessageStack.push(status);
        _StatusLabel.setText(statusinfo);
        FaceStatusLabel._StatusLabel._Message = statusinfo;
        FaceStatusLabel._StatusLabel._MessageKey = key;
        FaceStatusLabel._StatusLabel._Height = FaceStatusLabel._StatusLabel._FM.getHeight();
        int width = FaceStatusLabel._StatusLabel._FM.stringWidth(statusinfo);
        FaceStatusLabel._StatusLabel._Width = Math.max(100, width);
    }

    public static synchronized void clearStatus(String key) {
        Debug.out("FaceStatusLabel.clearStatus: " + key);
        String statusinfo = "";
        String oldkey = FaceStatusLabel._StatusLabel._MessageKey;
        if (_MessageStack.empty()) {
            return;
        }
        if (oldkey.equals(key)) {
            _MessageStack.pop();
            if (!_MessageStack.empty()) {
                String[] status = (String[])_MessageStack.peek();
                statusinfo = status[1];
                FaceStatusLabel._StatusLabel._MessageKey = status[0];
            }
            _StatusLabel.setText(statusinfo);
            int width = FaceStatusLabel._StatusLabel._FM.stringWidth(statusinfo);
            FaceStatusLabel._StatusLabel._Width = Math.max(100, width);
            FaceStatusLabel._StatusLabel._Message = statusinfo;
        } else {
            FaceStatusLabel.removemsg(key);
        }
    }

    private static void removemsg(String key) {
        Enumeration enumeration = _MessageStack.elements();
        while (enumeration.hasMoreElements()) {
            String[] entry = (String[])enumeration.nextElement();
            if (!entry[0].equals(key)) continue;
            _MessageStack.removeElement(entry);
        }
    }

    public static synchronized void setStatusFlag(boolean statusflag) {
        _FaceStatusFlag = statusflag;
        if (statusflag) {
            _StatusLabel.setText(FaceStatusLabel._StatusLabel._Message);
            _StatusLabel.setVisible(true);
        } else {
            _StatusLabel.setVisible(false);
        }
    }

    public static synchronized boolean getStatusFlag() {
        return _FaceStatusFlag;
    }

    public Dimension getMinimumSize() {
        Debug.out("StatusLabel.MinimumSize: " + 100 + "," + this._Height);
        if (_FaceStatusFlag) {
            return new Dimension(100, this._Height);
        }
        return new Dimension(0, 0);
    }

    public Dimension getPreferredSize() {
        Debug.out("StatusLabel.PreferredSize: " + this._Width + "," + this._Height);
        if (_FaceStatusFlag) {
            return new Dimension(this._Width, this._Height);
        }
        return new Dimension(0, 0);
    }

    static {
        _MessageStack = new Stack();
    }
}

