/*
 * Decompiled with CFR 0.152.
 */
package com.jthomas.javafaces;

import com.jthomas.javafaces.FaceAudio;
import com.jthomas.javafaces.FaceBoard;
import com.jthomas.javafaces.FaceCache;
import com.jthomas.javafaces.FaceEvent;
import com.jthomas.javafaces.FaceEventListener;
import com.jthomas.javafaces.FaceFrame;
import com.jthomas.javafaces.FaceMailbox;
import com.jthomas.javafaces.FaceOptions;
import com.jthomas.javafaces.FaceProperties;
import com.jthomas.javafaces.FaceResolver;
import com.jthomas.javafaces.FaceServer;
import com.jthomas.javafaces.MsgDialog;
import com.jthomas.javafaces.PiconDB;
import com.jthomas.util.Debug;
import com.jthomas.util.Log;
import java.util.Date;
import java.util.Vector;

public class JavaFaces
implements Runnable {
    static JavaFaces _JavaFaces;
    static final String _Version = "2.0";
    static final String _VersionDate = "June 22, 1998";
    boolean _FlagWakeup = false;
    boolean _FlagCheckMail = false;
    boolean _FlagResetMail = false;
    boolean _FlagResetServer = false;
    boolean _FlagQuitMail = false;
    boolean _FlagAudio = false;
    boolean _FlagCheckAddress = false;
    int _Delay;
    private FaceProperties _Properties;
    private String _OptionsFile;
    private FaceOptions _Options;
    private FaceResolver _Resolver;
    private Thread _ResolverThread;
    private FaceCache _Cache;
    private FaceFrame _FaceFrame;
    private FaceBoard _FaceBoard;
    private Thread _FaceBoardThread;
    private FaceMailbox _Mailbox;
    private int _MailboxMsgCount;
    private int _OldMsgCount;
    private Thread _MailboxThread;
    private PiconDB _PiconDB;
    private Thread _PiconDBThread;
    private FaceServer _Server;
    private FaceServer[] _ServerList;
    private int _ServerCurrent;
    private Vector _FaceEventListeners;
    private FaceAudio _FaceAudio;
    private Thread _FaceAudioThread;

    public static String version() {
        return "2.0 - June 22, 1998";
    }

    public static JavaFaces getRef() {
        Debug.assert(_JavaFaces != null, "JavaFaces instance not available");
        return _JavaFaces;
    }

    private JavaFaces() {
    }

    public void init() {
        this._Properties = FaceProperties.create("JavaFaces.ini");
        if (!this.setupOptions()) {
            this._FlagQuitMail = true;
            return;
        }
        boolean log = this._Options.get("Log", "true").equals("true");
        Log.setLogOn(log, this._Options.get("LogFile", "faces.log"));
        Log.out("Start", "Start JavaFaces Version " + JavaFaces.version());
        FaceServer.createList();
        this._ServerList = FaceServer.getList();
        this._FaceAudio = new FaceAudio();
        String dir = this._Options.get("CacheDirectory", null);
        if (dir != null) {
            try {
                if (this._Cache != null) {
                    this._Cache.writeIndex();
                }
                this._Cache = new FaceCache(dir);
            }
            catch (Exception exception) {
                Debug.out("Unable to open the Image Cache");
                this._Cache = null;
            }
        }
        this._Resolver = new FaceResolver();
        this._PiconDB = new PiconDB();
        this._FaceBoard = new FaceBoard();
        this._FaceBoard.setup();
        this._FaceFrame = new FaceFrame(this._FaceBoard);
        this._FaceFrame.setCursorBusy(true);
    }

    private boolean setupOptions() {
        String file;
        Debug.out("setupOptions():");
        try {
            if (this._Options == null) {
                this._Options = new FaceOptions(this._OptionsFile);
            }
            this._Options.parseOptions(null);
        }
        catch (Exception e) {
            String msg = "Options Error: " + e.getMessage();
            Log.out("Options", msg);
            MsgDialog.create(msg);
            return false;
        }
        this._Options.verifyOptions();
        if (this._Options.getBoolean("Debug", false)) {
            Debug.setDebugOn(true);
        }
        if ((file = this._Options.get("DebugFile", null)) != null) {
            Debug.setDebugFile(file);
        }
        if (this._Options.getBoolean("nojit", false)) {
            JavaFaces.jitDisable();
        } else if (Debug.isDebugOn() && this._Options.getBoolean("nojit", true)) {
            JavaFaces.jitDisable();
        }
        if (Debug.isDebugOn()) {
            Debug.out("Start JavaFaces Version " + JavaFaces.version() + " at " + new Date().toString().substring(0, 19));
            String version = System.getProperty("java.version");
            Debug.out("java.version=" + version);
            String os = System.getProperty("os.name");
            Debug.out("os.name=" + os);
            String userdir = System.getProperty("user.dir");
            Debug.out("user.dir=" + userdir);
            String compiler = System.getProperty("java.compiler");
            Debug.out("java.compiler=" + compiler);
            Debug.printStackTrace("Verify if JIT is off");
        }
        this._Delay = Integer.parseInt(this._Options.get("DelayTime"));
        JavaFaces._JavaFaces._FlagAudio = this._Options.getBoolean("AudioSupport", false);
        return true;
    }

    public void refreshOptions() {
        Debug.out("refreshOptions():");
        this.setupOptions();
    }

    public void setServer(int ServerNumber) {
        Debug.out("JavaFaces.setServer " + ServerNumber);
        if (this._ServerCurrent != ServerNumber) {
            this._ServerCurrent = ServerNumber;
            this._FlagResetServer = true;
            this._FlagCheckMail = true;
            this._FlagWakeup = true;
        }
    }

    public void run() {
        Debug.out("JavaFaces.run()");
        boolean done = false;
        boolean passes = false;
        if (this._FaceAudioThread == null) {
            Debug.out("Start FaceAudioThread");
            this._FaceAudioThread = new Thread((Runnable)this._FaceAudio, "FaceAudioThread");
            this._FaceAudioThread.start();
        }
        this._MailboxMsgCount = -1;
        this._OldMsgCount = 0;
        if (this._ResolverThread == null) {
            Debug.out("Start FaceResolverThread");
            this._ResolverThread = new Thread((Runnable)this._Resolver, "ResolverThread");
            this._ResolverThread.start();
        }
        try {
            Thread.sleep(200L);
        }
        catch (Exception exception) {}
        Debug.out(String.valueOf(this._ResolverThread.toString()) + " isAlive=" + this._ResolverThread.isAlive());
        this._Resolver.queuePut(null);
        if (this._PiconDBThread == null) {
            Debug.out("Start PiconDBThread");
            this._PiconDBThread = new Thread((Runnable)this._PiconDB, "PiconDBThread");
            this._PiconDBThread.start();
        }
        try {
            Thread.sleep(200L);
        }
        catch (Exception exception) {}
        Debug.out(String.valueOf(this._PiconDBThread.toString()) + " isAlive=" + this._PiconDBThread.isAlive());
        this._PiconDB.queuePut(null);
        if (this._FaceBoardThread == null) {
            Debug.out("Start FaceBoardThread");
            this._FaceBoardThread = new Thread((Runnable)this._FaceBoard, "FaceBoardThread");
            this._FaceBoardThread.start();
        }
        try {
            Thread.sleep(200L);
        }
        catch (Exception exception) {}
        Debug.out("Threads should be started!");
        do {
            this._FlagResetServer = false;
            Debug.out("Access MailServer");
            this._Server = this._ServerList[this._ServerCurrent];
            while (!this._Server.verifyLoginInfo()) {
                if (this._Server.getLoginInfo()) continue;
                this._FlagQuitMail = true;
                break;
            }
            Debug.out("Create Mailbox object for " + this._Server.toString());
            this._Mailbox = this._Server.createMailbox();
            if (this._Mailbox == null) break;
            this._Mailbox.init();
            Debug.out("Start Mailbox thread");
            this._MailboxThread = new Thread((Runnable)this._Mailbox, "MailboxThread");
            this._MailboxThread.start();
            try {
                Debug.out("waiting...");
                this._MailboxThread.join();
            }
            catch (Exception exception) {}
            this._FlagQuitMail = false;
        } while (this._FlagResetServer);
        if (this._Cache != null) {
            this._Cache.writeIndex();
        }
        this._Properties.save();
        Debug.out("JavaFaces is done!");
        Log.out("Stop", "JavaFaces is done!");
        System.exit(0);
    }

    public static void displayDebugInfo() {
        Runtime runtime = Runtime.getRuntime();
        Debug.out("Memory: Total=" + runtime.totalMemory() + "  Free=" + runtime.freeMemory());
        Thread t = JavaFaces._JavaFaces._MailboxThread;
        Debug.out(String.valueOf(t.toString()) + " isAlive=" + t.isAlive());
        t = JavaFaces._JavaFaces._ResolverThread;
        Debug.out(String.valueOf(t.toString()) + " isAlive=" + t.isAlive());
        JavaFaces._JavaFaces._Resolver.queuePut(null);
        t = JavaFaces._JavaFaces._PiconDBThread;
        Debug.out(String.valueOf(t.toString()) + " isAlive=" + t.isAlive());
        JavaFaces._JavaFaces._PiconDB.queuePut(null);
        t = JavaFaces._JavaFaces._FaceBoardThread;
        Debug.out(String.valueOf(t.toString()) + " isAlive=" + t.isAlive());
        JavaFaces._JavaFaces._FaceBoard.queuePut(null);
        t = JavaFaces._JavaFaces._FaceAudioThread;
        Debug.out(String.valueOf(t.toString()) + " isAlive=" + t.isAlive());
        JavaFaces._JavaFaces._FaceAudio.queuePut(null);
    }

    public synchronized void addFaceEventListener(FaceEventListener rcl) {
        if (this._FaceEventListeners == null) {
            this._FaceEventListeners = new Vector(10);
        }
        if (!this._FaceEventListeners.contains(rcl)) {
            this._FaceEventListeners.addElement(rcl);
        }
    }

    public synchronized void removeFaceEventListener(FaceEventListener rcl) {
        if (this._FaceEventListeners == null) {
            return;
        }
        this._FaceEventListeners.removeElement(rcl);
    }

    public void fireFaceEvent(int id) {
        Vector targets = null;
        JavaFaces javaFaces = this;
        synchronized (javaFaces) {
            if (this._FaceEventListeners == null) {
                Object var4_4 = null;
                return;
            }
            targets = (Vector)this._FaceEventListeners.clone();
        }
        FaceEvent event = new FaceEvent(this, id);
        int i = 0;
        while (i < targets.size()) {
            FaceEventListener target = (FaceEventListener)targets.elementAt(i);
            target.actionPerformed(event);
            ++i;
        }
    }

    public FaceCache getCacheRef() {
        return this._Cache;
    }

    public FaceResolver getResolverRef() {
        return this._Resolver;
    }

    public PiconDB getPiconDBRef() {
        return this._PiconDB;
    }

    public FaceBoard getFaceBoardRef() {
        return this._FaceBoard;
    }

    public FaceAudio getFaceAudioRef() {
        return this._FaceAudio;
    }

    public FaceOptions getFaceOptionsRef() {
        return this._Options;
    }

    public void setDelay(int delay) {
        this._Delay = delay;
    }

    public void setBusy(boolean busy) {
        Debug.out("Cursor busy = " + busy);
        this._FaceFrame.setCursorBusy(busy);
    }

    public static void jitDisable() {
        Debug.out("Disable JIT Compiler");
        Compiler.disable();
    }

    public static void main(String[] args) {
        try {
            _JavaFaces = new JavaFaces();
            int i = 0;
            while (i < args.length) {
                if (args[i].equals("-d")) {
                    Debug.setDebugOn(true);
                } else if (args[i].equals("-nojit")) {
                    JavaFaces.jitDisable();
                } else if (args[i].equals("?")) {
                    System.out.println("Options:  -d  -nojit  your.opt");
                    System.exit(0);
                } else {
                    JavaFaces._JavaFaces._OptionsFile = args[i];
                }
                ++i;
            }
            _JavaFaces.init();
            if (JavaFaces._JavaFaces._FlagQuitMail) {
                Debug.out("Failed during initialization");
                System.exit(0);
            }
            Thread jf = new Thread((Runnable)_JavaFaces, "JavaFaces");
            jf.start();
            jf.join();
        }
        catch (Exception e) {
            Debug.out(e);
        }
    }
}

