/*
 * Decompiled with CFR 0.152.
 */
package com.jthomas.pop;

import com.jthomas.pop.Convert;
import com.jthomas.pop.popStatus;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.net.Socket;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;

public class pop3 {
    protected final int AUTHORIZATION = 1;
    protected final int TRANSACTION = 2;
    protected final int UPDATE = 3;
    protected int _TotalMsgs;
    protected int _TotalSize;
    protected boolean _StatusOK = false;
    protected int State;
    protected String LastCmd;
    protected String Host;
    protected int Port = 110;
    protected String User;
    protected String Password;
    protected Socket server;
    protected BufferedReader serverInputStream;
    protected DataOutputStream serverOutputStream;
    private boolean debugOn = false;

    public pop3(String host, String user, String password) {
        this.Host = host;
        this.User = user;
        this.Password = password;
    }

    public pop3() {
    }

    public popStatus connect(String host) {
        this.Host = host;
        return this.connect();
    }

    public popStatus connect(String host, int port) {
        this.Host = host;
        this.Port = port;
        return this.connect();
    }

    public synchronized popStatus connect() {
        popStatus status = new popStatus();
        this.debug("Connecting to " + this.Host + " at port " + this.Port);
        if (this.Host == null) {
            status._Response = "-ERR Host not specified";
            status._OK = false;
            return status;
        }
        try {
            this.server = new Socket(this.Host, this.Port);
            if (this.server == null) {
                this.debug("-ERR Error while connecting to POP3 server");
                status._OK = false;
                status._Response = "-ERR Error while connecting to POP3 server";
            } else {
                this.debug("Connected");
                this.serverInputStream = new BufferedReader(new InputStreamReader(this.server.getInputStream()));
                if (this.serverInputStream == null) {
                    this.debug("Failed to setup an input stream.");
                    status._OK = false;
                    status._Response = "-ERR Error setting up input stream";
                    this.server = null;
                }
                this.serverOutputStream = new DataOutputStream(this.server.getOutputStream());
                if (this.serverOutputStream == null) {
                    this.debug("Failed to setup an output stream.");
                    status._OK = false;
                    status._Response = "-ERR Error setting up output stream";
                    this.server = null;
                }
            }
        }
        catch (Exception e) {
            String msg = "Exception! " + e.toString();
            this.debug(msg);
            status._OK = false;
            status._Response = msg;
            this.server = null;
        }
        if (this.server != null) {
            status._OK = true;
            this._StatusOK = true;
            status._Response = this.recv();
            this.Parse(status, 2);
            this.debug("Response=" + status._Response);
        }
        if (status._OK) {
            this.State = 1;
        }
        return status;
    }

    public popStatus login(String user, String password) {
        this.User = user;
        this.Password = password;
        return this.login();
    }

    public synchronized popStatus login() {
        popStatus status = new popStatus();
        if (this.User == null || this.Password == null) {
            status._Response = "-ERR Userid or Password not specified";
            return status;
        }
        if (this.server != null) {
            this.send("USER " + this.User);
            status._Response = this.recv();
            this.Parse(status, 1);
            if (status._OK) {
                this.send("PASS " + this.Password);
                status._Response = this.recv();
                this.Parse(status, 1);
                if (status._OK) {
                    this.State = 2;
                    popStatus popStatus2 = this.stat();
                }
            }
        }
        return status;
    }

    public synchronized void close() {
        this.debug("Closing socket");
        try {
            this.server.close();
            this.State = 0;
        }
        catch (IOException iOException) {
            this.debug("Failure in server.close()");
        }
    }

    public synchronized popStatus stat() {
        popStatus status = new popStatus();
        if (this.State != 2) {
            status._Response = "-ERR Server not in transaction mode";
            return status;
        }
        this.send("STAT");
        status._Response = this.recv();
        String[] tokens = this.Parse(status, 4);
        if (status._OK) {
            this._TotalMsgs = Convert.toInt(tokens[1]);
            this._TotalSize = Convert.toInt(tokens[2]);
        }
        return status;
    }

    public synchronized popStatus quit() {
        popStatus status = new popStatus();
        this.send("QUIT");
        this.State = 3;
        status._Response = this.recv();
        String[] tokens = this.Parse(status, 2);
        this.close();
        return status;
    }

    public synchronized popStatus list(int msgnum) {
        popStatus status = new popStatus();
        boolean i = false;
        this.send("LIST " + msgnum);
        status._Response = this.recv();
        String[] tokens = this.Parse(status, 2);
        return status;
    }

    public synchronized popStatus list() {
        popStatus status = new popStatus();
        this.send("LIST");
        this.recvN(status);
        String[] tokens = this.Parse(status, 2);
        return status;
    }

    public synchronized popStatus uidl(int msgnum) {
        popStatus status = new popStatus();
        this.send("UIDL " + msgnum);
        status._Response = this.recv();
        String[] tokens = this.Parse(status, 2);
        return status;
    }

    public synchronized popStatus uidl() {
        popStatus status = new popStatus();
        this.send("UIDL");
        this.recvN(status);
        String[] tokens = this.Parse(status, 2);
        return status;
    }

    public synchronized popStatus retr(int msgnum) {
        popStatus status = new popStatus();
        this.send("RETR " + msgnum);
        this.recvN(status);
        String[] tokens = this.Parse(status, 2);
        return status;
    }

    public synchronized popStatus top(int msgnum, int n) {
        popStatus status = new popStatus();
        this.send("TOP " + msgnum + " " + n);
        this.recvN(status);
        String[] tokens = this.Parse(status, 2);
        return status;
    }

    public synchronized popStatus dele(int msgnum) {
        popStatus status = new popStatus();
        this.send("DELE " + msgnum);
        status._Response = this.recv();
        String[] tokens = this.Parse(status, 2);
        return status;
    }

    public synchronized popStatus rset() {
        popStatus status = new popStatus();
        this.send("RSET");
        status._Response = this.recv();
        String[] tokens = this.Parse(status, 2);
        return status;
    }

    public synchronized popStatus noop() {
        popStatus status = new popStatus();
        this.send("NOOP");
        status._Response = this.recv();
        String[] tokens = this.Parse(status, 2);
        return status;
    }

    public int get_TotalMsgs() {
        return this._TotalMsgs;
    }

    public int get_TotalSize() {
        return this._TotalSize;
    }

    public synchronized popStatus appendFile(String filename, int msgnum) {
        popStatus status = new popStatus();
        this.send("RETR " + msgnum);
        this.recvN(status);
        String[] tokens = this.Parse(status, 2);
        if (status._OK) {
            RandomAccessFile openfile;
            try {
                openfile = new RandomAccessFile(filename, "rw");
            }
            catch (IOException iOException) {
                status._OK = false;
                status._Response = "-ERR File open failed";
                return status;
            }
            Date datestamp = new Date();
            String[] contents = status.Responses();
            try {
                openfile.seek(openfile.length());
                openfile.writeBytes("From - " + datestamp.toString() + "\r\n");
                int i = 0;
                while (i < contents.length) {
                    openfile.writeBytes(String.valueOf(contents[i]) + "\r\n");
                    ++i;
                }
                openfile.close();
            }
            catch (IOException iOException) {
                status._OK = false;
                status._Response = "-ERR File write failed";
                return status;
            }
        }
        status._OK = true;
        return status;
    }

    String[] Parse(popStatus status, int maxToParse) {
        String[] tokens = null;
        status._OK = false;
        String response = status._Response;
        if (response != null) {
            int i = 0;
            if (response.trim().startsWith("+OK")) {
                status._OK = true;
            } else {
                this.debug(response);
            }
            StringTokenizer st = new StringTokenizer(response);
            int max = maxToParse == -1 ? st.countTokens() : maxToParse;
            tokens = new String[max + 1];
            while (st.hasMoreTokens() && i < max) {
                tokens[i] = new String(st.nextToken());
                ++i;
            }
            if (st.hasMoreTokens()) {
                StringBuffer rest = new StringBuffer(st.nextToken());
                while (st.hasMoreTokens()) {
                    rest.append(" " + st.nextToken());
                }
                tokens[max] = new String(rest);
            }
        }
        return tokens;
    }

    void send(String cmdline) {
        this.debug(">> " + cmdline);
        this.LastCmd = cmdline;
        try {
            this.serverOutputStream.writeBytes(String.valueOf(cmdline) + "\r\n");
            this._StatusOK = true;
        }
        catch (IOException iOException) {
            System.err.println("Caught exception while sending command to server");
            this._StatusOK = false;
        }
        catch (Exception e) {
            System.err.println("Send: Unexpected exception: " + e.toString());
            this._StatusOK = false;
        }
    }

    String recv() {
        String line = "";
        if (!this._StatusOK) {
            line = "-ERR Failed sending command to server";
            return line;
        }
        try {
            line = this.serverInputStream.readLine();
            this.debug("<<" + line);
        }
        catch (IOException iOException) {
            System.err.println("Caught exception while reading");
            line = "-ERR Caught IOException while reading from server";
        }
        catch (Exception e) {
            System.err.println("Unexpected exception: " + e.toString());
            line = "-ERR Unexpected exception while reading from server";
        }
        if (line == null) {
            this.debug("Read a null line from server");
            line = "-ERR <NULL>";
        }
        if (line.trim().startsWith("-ERR")) {
            this.debug("Result from server has error!");
            this.debug("Sent:     '" + this.LastCmd + "'");
            this.debug("Received: '" + line + "'");
            return line;
        }
        if (line.trim().startsWith("+OK")) {
            return line;
        }
        this.debug("Received strange response");
        this.debug("'" + line + "'");
        line = "-ERR Invalid response";
        return line;
    }

    void recvN(popStatus status) {
        this.debug("entered recvN");
        Vector<String> v = new Vector<String>(100, 100);
        String line = "";
        Object response = null;
        try {
            boolean done = false;
            int linenum = 0;
            while (!done) {
                line = this.serverInputStream.readLine();
                this.debug("<<" + line.length() + " '" + line + "'");
                if (++linenum == 1) {
                    if (line.trim().startsWith("-ERR ")) {
                        this.debug("Result from server has error!");
                        this.debug("Sent:     '" + this.LastCmd + "'");
                        this.debug("Received: '" + line + "'");
                        done = true;
                        status._Response = line;
                        continue;
                    }
                    if (line.trim().startsWith("+OK")) {
                        status._Response = line;
                        continue;
                    }
                    this.debug("Received strange response");
                    this.debug("'" + line + "'");
                    done = true;
                    status._Response = "-ERR Invalid response";
                    continue;
                }
                if (line.startsWith(".")) {
                    if (line.length() == 1) {
                        done = true;
                        continue;
                    }
                    v.addElement(line.substring(1));
                    continue;
                }
                v.addElement(line);
            }
        }
        catch (IOException iOException) {
            System.err.println("Caught exception while reading");
            status._Response = "-ERR Caught IOException while reading from server";
        }
        catch (Exception e) {
            System.err.println("Unexpected exception: " + e.toString());
            status._Response = "-ERR Unexpected exception while reading from server";
        }
        status._Responses = new String[v.size()];
        v.copyInto(status._Responses);
    }

    public void setDebugOn(boolean OnOff) {
        this.debugOn = OnOff;
    }

    public void debug(String debugstr) {
        if (this.debugOn) {
            System.err.println("Pop3: " + debugstr);
        }
    }
}

