/*
 * Decompiled with CFR 0.152.
 */
package starwave.util.regexp;

import starwave.util.regexp.State;

class CharArrayState
extends State {
    char[] data;

    CharArrayState(char[] data, int offset, int length) {
        super(offset, length);
        this.data = data;
    }

    int getchar() {
        if (this.offset >= this.limit) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(this.offset) + " >= " + this.limit);
        }
        return this.data[this.offset];
    }

    int getchar(int offset) {
        if (offset >= this.limit) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(offset) + " >= " + this.limit);
        }
        return this.data[offset];
    }

    int indexOf(int c, int offset) {
        char[] data = this.data;
        int limit = this.limit;
        while (offset < limit) {
            if (data[offset] == c) {
                return offset;
            }
            ++offset;
        }
        return -1;
    }

    int lastIndexOf(int c, int offset) {
        char[] data = this.data;
        while (offset >= 0) {
            if (data[offset] == c) {
                return offset;
            }
            --offset;
        }
        return -1;
    }

    public String getGroupString(int n) {
        this.validateGroup(n);
        return String.copyValueOf(this.data, this.pstart[n] - 1, this.pend[n] - this.pstart[n]);
    }
}

