/*
 * Decompiled with CFR 0.152.
 */
package starwave.util.regexp;

import starwave.util.regexp.MalformedRegexpException;
import starwave.util.regexp.Regexp;
import starwave.util.regexp.State;

class CharClass
extends Regexp {
    static final int NCHARS = 256;
    static final int SHIFT = 5;
    static final int MASK = 31;
    static CharClass sClass = new CharClass(null, "[ \t\n\r]");
    static CharClass wClass = new CharClass(null, "[a-zA-Z0-9_]");
    static CharClass dClass = new CharClass(null, "[0-9]");
    int[] bits;
    boolean in = true;

    static CharClass cloneCharClass(Regexp prev, int kind) {
        CharClass cc;
        switch (kind) {
            case 83: 
            case 115: {
                cc = sClass;
                break;
            }
            case 87: 
            case 119: {
                cc = wClass;
                break;
            }
            case 68: 
            case 100: {
                cc = dClass;
                break;
            }
            default: {
                throw new MalformedRegexpException("Internal exception");
            }
        }
        cc = new CharClass(cc);
        if (Character.isUpperCase((char)kind)) {
            cc.in = false;
        }
        cc.prev = prev;
        if (prev != null) {
            prev.next = cc;
        }
        return cc;
    }

    CharClass(CharClass orig) {
        super(null);
        this.bits = orig.bits;
        this.in = orig.in;
    }

    CharClass(Regexp prev, String spec) {
        super(prev);
        this.bits = new int[8];
        this.process(spec);
    }

    final boolean charInClass(int c) {
        return (this.bits[c >> 5] & 1 << (c & 0x1F)) != 0;
    }

    final void addChar(int c) {
        int n = c >> 5;
        this.bits[n] = this.bits[n] | 1 << (c & 0x1F);
    }

    final void addChars(int c0, int c1) {
        if (c0 > c1) {
            int tmp = c0;
            c0 = c1;
            c1 = tmp;
        }
        while (c0 <= c1) {
            this.addChar(c0++);
        }
    }

    final void merge(CharClass other, boolean invert) {
        int i = 0;
        while (i < this.bits.length) {
            int otherbits = other.bits[i];
            if (invert) {
                otherbits ^= 0xFFFFFFFF;
            }
            int n = i++;
            this.bits[n] = this.bits[n] | otherbits;
        }
    }

    void process(String spec) {
        int i = 1;
        int limit = spec.length() - 1;
        if (spec.charAt(i) == '^') {
            ++i;
            this.in = false;
        }
        while (i < limit) {
            int c = spec.charAt(i++);
            block0 : switch (c) {
                case 92: {
                    c = spec.charAt(i++);
                    switch (c) {
                        case 87: 
                        case 119: {
                            this.merge(wClass, c == 87);
                            break block0;
                        }
                        case 83: 
                        case 115: {
                            this.merge(sClass, c == 83);
                            break block0;
                        }
                        case 68: 
                        case 100: {
                            this.merge(dClass, c == 68);
                            break block0;
                        }
                        case 110: {
                            c = 10;
                            break;
                        }
                        case 114: {
                            c = 13;
                            break;
                        }
                        case 102: {
                            c = 12;
                            break;
                        }
                        case 116: {
                            c = 9;
                            break;
                        }
                        case 98: {
                            c = 8;
                            break;
                        }
                    }
                }
                default: {
                    this.addChar(c);
                    break;
                }
                case 45: {
                    if (i < limit) {
                        this.addChars(spec.charAt(i - 2), spec.charAt(i++));
                        break;
                    }
                    this.addChar(45);
                    break;
                }
            }
        }
    }

    Regexp advance(State state) {
        int c = state.getchar();
        if (this.charInClass(c) == this.in) {
            ++state.offset;
            return this.next;
        }
        return null;
    }

    final String ppChar(int c) {
        String str;
        switch (c) {
            case 10: {
                str = "\\n";
                break;
            }
            case 13: {
                str = "\\r";
                break;
            }
            case 9: {
                str = "\\t";
                break;
            }
            default: {
                str = c < 32 ? "^" + new Character((char)(c + 64)) : String.valueOf(new Character((char)c));
            }
        }
        return str;
    }

    public String toStringThis() {
        StringBuffer value = new StringBuffer("[");
        if (!this.in) {
            value.append("^");
        }
        int i = 0;
        while (i < 255) {
            if (this.charInClass(i)) {
                int j = i + 1;
                while (j < 255) {
                    if (!this.charInClass(j)) break;
                    ++j;
                }
                int count = j - i;
                value.append(this.ppChar(i));
                switch (count) {
                    default: {
                        value.append('-');
                    }
                    case 2: {
                        value.append(this.ppChar(j - 1));
                    }
                    case 1: 
                }
                i = j - 1;
            }
            ++i;
        }
        value.append(']');
        return value.toString();
    }
}

