/*
 * Decompiled with CFR 0.152.
 */
package starwave.util.regexp;

class CompilerState {
    String input;
    int offset;
    int groupCount;
    int limit;
    boolean mapCase;
    boolean eof = false;

    CompilerState(String input, boolean mapCase) {
        this.input = input;
        this.mapCase = mapCase;
        this.limit = input.length();
    }

    final int nextChar() {
        if (this.offset < this.limit) {
            return this.input.charAt(this.offset++);
        }
        this.eof = true;
        return -1;
    }

    final int currentChar() {
        if (this.eof) {
            return -1;
        }
        return this.input.charAt(this.offset - 1);
    }

    final void ungetc() {
        this.eof = false;
        --this.offset;
    }

    final int nextGroup() {
        return this.groupCount++;
    }

    final String substring(int from) {
        return this.input.substring(from, this.offset);
    }

    final boolean atEop() {
        return this.offset == this.limit;
    }

    public String toString() {
        return this.eof ? "EOF" : this.input.substring(this.offset);
    }
}

