/*
 * Decompiled with CFR 0.152.
 */
package jef.sound;

import java.io.InputStream;
import sun.audio.AudioData;
import sun.audio.AudioPlayer;
import sun.audio.ContinuousAudioDataStream;

public class LoFiSound {
    AudioPlayer ap;
    ContinuousAudioDataStream cads;
    AudioData ad;
    int[] linBuffer;
    byte[] muBuffer;

    public void init(int[] lb, byte[] mb) {
        this.ap = AudioPlayer.player;
        this.linBuffer = lb;
        this.muBuffer = mb;
        this.ad = new AudioData(this.muBuffer);
        this.cads = new ContinuousAudioDataStream(this.ad);
        this.ap.start((InputStream)this.cads);
    }

    public void disable() {
        this.ap.stop((InputStream)this.cads);
        this.cads = null;
        this.ad = null;
        System.out.println("LoFiSound disabled");
    }

    public void finalize() {
        this.disable();
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected static byte linToMu(int lin) {
        int mask;
        if ((lin /= 4) < 0) {
            lin = -lin;
            mask = 127;
        } else {
            mask = 255;
        }
        lin = lin < 32 ? 0xF0 | 15 - lin / 2 : (lin < 96 ? 0xE0 | 15 - (lin - 32) / 4 : (lin < 224 ? 0xD0 | 15 - (lin - 96) / 8 : (lin < 480 ? 0xC0 | 15 - (lin - 224) / 16 : (lin < 992 ? 0xB0 | 15 - (lin - 480) / 32 : (lin < 2016 ? 0xA0 | 15 - (lin - 992) / 64 : (lin < 4064 ? 0x90 | 15 - (lin - 2016) / 128 : (lin < 8160 ? 0x80 | 15 - (lin - 4064) / 256 : 128)))))));
        return (byte)(mask & lin);
    }

    protected void convertBufferToMuLaw() {
        int i = 0;
        while (i < this.linBuffer.length) {
            this.muBuffer[i] = LoFiSound.linToMu(this.linBuffer[i]);
            ++i;
        }
    }
}

