/*
 * Decompiled with CFR 0.152.
 */
package jef.sound.chip;

import jef.map.ReadHandler;
import jef.map.WriteHandler;
import jef.sound.SoundChip;
import jef.sound.SoundChipEmulator;

public class AY8910
extends SoundChip
implements SoundChipEmulator {
    static final int MAX_OUTPUT = 8191;
    static final int MAX_8910 = 5;
    static final int STEP = 4096;
    int ay8910_index_ym;
    int num = 0;
    static int ym_num = 0;
    static final int AY_AFINE = 0;
    static final int AY_ACOARSE = 1;
    static final int AY_BFINE = 2;
    static final int AY_BCOARSE = 3;
    static final int AY_CFINE = 4;
    static final int AY_CCOARSE = 5;
    static final int AY_NOISEPER = 6;
    static final int AY_ENABLE = 7;
    static final int AY_AVOL = 8;
    static final int AY_BVOL = 9;
    static final int AY_CVOL = 10;
    static final int AY_EFINE = 11;
    static final int AY_ECOARSE = 12;
    static final int AY_ESHAPE = 13;
    static final int AY_PORTA = 14;
    static final int AY_PORTB = 15;
    static AY8910Context[] ay = new AY8910Context[5];
    static int baseClock;

    public AY8910(int numChips, int clock) {
        this.num = numChips;
        baseClock = clock;
    }

    public void init(boolean useJavaxSound, int sampRate, int buflen, int fps) {
        super.init(useJavaxSound, sampRate, buflen, fps);
        int chip = 0;
        while (chip < this.num) {
            this.AY8910_init("AY-3-8910", chip, baseClock, 50, super.getSampFreq(), 0, 0, 0, 0);
            this.build_mixer_table(chip);
            ++chip;
        }
    }

    public void _AYWriteReg(int n, int r, int v) {
        AY8910Context psg = ay[n];
        psg.Regs[r] = v;
        switch (r) {
            case 0: 
            case 1: {
                psg.Regs[1] = psg.Regs[1] & 0xF;
                int old = psg.PeriodA;
                psg.PeriodA = (psg.Regs[0] + 256 * psg.Regs[1]) * psg.UpdateStep;
                if (psg.PeriodA == 0) {
                    psg.PeriodA = psg.UpdateStep;
                }
                psg.CountA += psg.PeriodA - old;
                if (psg.CountA > 0) break;
                psg.CountA = 1;
                break;
            }
            case 2: 
            case 3: {
                psg.Regs[3] = psg.Regs[3] & 0xF;
                int old = psg.PeriodB;
                psg.PeriodB = (psg.Regs[2] + 256 * psg.Regs[3]) * psg.UpdateStep;
                if (psg.PeriodB == 0) {
                    psg.PeriodB = psg.UpdateStep;
                }
                psg.CountB += psg.PeriodB - old;
                if (psg.CountB > 0) break;
                psg.CountB = 1;
                break;
            }
            case 4: 
            case 5: {
                psg.Regs[5] = psg.Regs[5] & 0xF;
                int old = psg.PeriodC;
                psg.PeriodC = (psg.Regs[4] + 256 * psg.Regs[5]) * psg.UpdateStep;
                if (psg.PeriodC == 0) {
                    psg.PeriodC = psg.UpdateStep;
                }
                psg.CountC += psg.PeriodC - old;
                if (psg.CountC > 0) break;
                psg.CountC = 1;
                break;
            }
            case 6: {
                psg.Regs[6] = psg.Regs[6] & 0x1F;
                int old = psg.PeriodN;
                psg.PeriodN = psg.Regs[6] * psg.UpdateStep;
                if (psg.PeriodN == 0) {
                    psg.PeriodN = psg.UpdateStep;
                }
                psg.CountN += psg.PeriodN - old;
                if (psg.CountN > 0) break;
                psg.CountN = 1;
                break;
            }
            case 7: {
                if (psg.lastEnable != -1) {
                    psg.getClass();
                    int cfr_ignored_0 = psg.Regs[7];
                }
                if (psg.lastEnable != -1) {
                    psg.getClass();
                    int cfr_ignored_1 = psg.Regs[7];
                }
                psg.lastEnable = psg.Regs[7];
                break;
            }
            case 8: {
                psg.Regs[8] = psg.Regs[8] & 0x1F;
                psg.EnvelopeA = psg.Regs[8] & 0x10;
                psg.VolA = psg.EnvelopeA != 0 ? psg.VolE : psg.VolTable[psg.Regs[8] != 0 ? psg.Regs[8] * 2 + 1 : 0];
                break;
            }
            case 9: {
                psg.Regs[9] = psg.Regs[9] & 0x1F;
                psg.EnvelopeB = psg.Regs[9] & 0x10;
                psg.VolB = psg.EnvelopeB != 0 ? psg.VolE : psg.VolTable[psg.Regs[9] != 0 ? psg.Regs[9] * 2 + 1 : 0];
                break;
            }
            case 10: {
                psg.Regs[10] = psg.Regs[10] & 0x1F;
                psg.EnvelopeC = psg.Regs[10] & 0x10;
                psg.VolC = psg.EnvelopeC != 0 ? psg.VolE : psg.VolTable[psg.Regs[10] != 0 ? psg.Regs[10] * 2 + 1 : 0];
                break;
            }
            case 11: 
            case 12: {
                int old = psg.PeriodE;
                psg.PeriodE = (psg.Regs[11] + 256 * psg.Regs[12]) * psg.UpdateStep;
                if (psg.PeriodE == 0) {
                    psg.PeriodE = psg.UpdateStep / 2;
                }
                psg.CountE += psg.PeriodE - old;
                if (psg.CountE > 0) break;
                psg.CountE = 1;
                break;
            }
            case 13: {
                psg.Regs[13] = psg.Regs[13] & 0xF;
                int n2 = psg.Attack = (psg.Regs[13] & 4) != 0 ? 31 : 0;
                if ((psg.Regs[13] & 8) == 0) {
                    psg.Hold = 1;
                    psg.Alternate = psg.Attack;
                } else {
                    psg.Hold = psg.Regs[13] & 1;
                    psg.Alternate = psg.Regs[13] & 2;
                }
                psg.CountE = psg.PeriodE;
                psg.CountEnv = 31;
                psg.Holding = 0;
                psg.VolE = psg.VolTable[psg.CountEnv ^ psg.Attack];
                if (psg.EnvelopeA != 0) {
                    psg.VolA = psg.VolE;
                }
                if (psg.EnvelopeB != 0) {
                    psg.VolB = psg.VolE;
                }
                if (psg.EnvelopeC == 0) break;
                psg.VolC = psg.VolE;
                break;
            }
            case 14: {
                int cfr_ignored_2 = psg.Regs[7];
                break;
            }
            case 15: {
                int cfr_ignored_3 = psg.Regs[7];
            }
        }
    }

    public void AYWriteReg(int chip, int r, int v) {
        AY8910Context psg = ay[chip];
        if (r > 15) {
            return;
        }
        if (r < 14 && r != 13) {
            int cfr_ignored_0 = psg.Regs[r];
        }
        this._AYWriteReg(chip, r, v);
    }

    public int AYReadReg(int n, int r) {
        AY8910Context psg = ay[n];
        if (r > 15) {
            return 0;
        }
        switch (r) {
            case 14: {
                if ((psg.Regs[7] & 0x40) != 0) {
                    System.out.println("warning: read from 8910 #" + n + " Port A set as output");
                    break;
                }
                if (psg.PortAread == 0) break;
                psg.Regs[14] = psg.PortAread;
                break;
            }
            case 15: {
                if ((psg.Regs[7] & 0x80) != 0) {
                    System.out.println("warning: read from 8910 #" + n + " Port B set as output");
                    break;
                }
                if (psg.PortBread == 0) break;
                psg.Regs[15] = psg.PortBread;
            }
        }
        return psg.Regs[r];
    }

    public void AY8910Write(int chip, int a, int data) {
        AY8910Context psg = ay[chip];
        if ((a & 1) != 0) {
            this.AYWriteReg(chip, psg.register_latch, data);
        } else {
            psg.register_latch = data & 0xF;
        }
    }

    public int AY8910Read(int chip) {
        AY8910Context psg = ay[chip];
        return this.AYReadReg(chip, psg.register_latch);
    }

    public void writeBuffer() {
        this.clearBuffer();
        int chip = 0;
        while (chip < this.num) {
            this.AY8910Update(chip);
            ++chip;
        }
    }

    public void AY8910Update(int chip) {
        AY8910Context psg = ay[chip];
        int pbuf1 = 0;
        int length = super.getBufferLength();
        if ((psg.Regs[7] & 1) != 0) {
            if (psg.CountA <= length * 4096) {
                psg.CountA += length * 4096;
            }
            psg.OutputA = 1;
        } else if (psg.Regs[8] == 0 && psg.CountA <= length * 4096) {
            psg.CountA += length * 4096;
        }
        if ((psg.Regs[7] & 2) != 0) {
            if (psg.CountB <= length * 4096) {
                psg.CountB += length * 4096;
            }
            psg.OutputB = 1;
        } else if (psg.Regs[9] == 0 && psg.CountB <= length * 4096) {
            psg.CountB += length * 4096;
        }
        if ((psg.Regs[7] & 4) != 0) {
            if (psg.CountC <= length * 4096) {
                psg.CountC += length * 4096;
            }
            psg.OutputC = 1;
        } else if (psg.Regs[10] == 0 && psg.CountC <= length * 4096) {
            psg.CountC += length * 4096;
        }
        if ((psg.Regs[7] & 0x38) == 56 && psg.CountN <= length * 4096) {
            psg.CountN += length * 4096;
        }
        int outn = psg.OutputN | psg.Regs[7];
        while (length != 0) {
            int nextevent;
            int volc = 0;
            int volb = 0;
            int vola = 0;
            int left = 4096;
            do {
                nextevent = psg.CountN < left ? psg.CountN : left;
                if ((outn & 8) != 0) {
                    if (psg.OutputA != 0) {
                        vola += psg.CountA;
                    }
                    psg.CountA -= nextevent;
                    while (psg.CountA <= 0) {
                        psg.CountA += psg.PeriodA;
                        if (psg.CountA > 0) {
                            psg.OutputA ^= 1;
                            if (psg.OutputA == 0) break;
                            vola += psg.PeriodA;
                            break;
                        }
                        psg.CountA += psg.PeriodA;
                        vola += psg.PeriodA;
                    }
                    if (psg.OutputA != 0) {
                        vola -= psg.CountA;
                    }
                } else {
                    psg.CountA -= nextevent;
                    while (psg.CountA <= 0) {
                        psg.CountA += psg.PeriodA;
                        if (psg.CountA > 0) {
                            psg.OutputA ^= 1;
                            break;
                        }
                        psg.CountA += psg.PeriodA;
                    }
                }
                if ((outn & 0x10) != 0) {
                    if (psg.OutputB != 0) {
                        volb += psg.CountB;
                    }
                    psg.CountB -= nextevent;
                    while (psg.CountB <= 0) {
                        psg.CountB += psg.PeriodB;
                        if (psg.CountB > 0) {
                            psg.OutputB ^= 1;
                            if (psg.OutputB == 0) break;
                            volb += psg.PeriodB;
                            break;
                        }
                        psg.CountB += psg.PeriodB;
                        volb += psg.PeriodB;
                    }
                    if (psg.OutputB != 0) {
                        volb -= psg.CountB;
                    }
                } else {
                    psg.CountB -= nextevent;
                    while (psg.CountB <= 0) {
                        psg.CountB += psg.PeriodB;
                        if (psg.CountB > 0) {
                            psg.OutputB ^= 1;
                            break;
                        }
                        psg.CountB += psg.PeriodB;
                    }
                }
                if ((outn & 0x20) != 0) {
                    if (psg.OutputC != 0) {
                        volc += psg.CountC;
                    }
                    psg.CountC -= nextevent;
                    while (psg.CountC <= 0) {
                        psg.CountC += psg.PeriodC;
                        if (psg.CountC > 0) {
                            psg.OutputC ^= 1;
                            if (psg.OutputC == 0) break;
                            volc += psg.PeriodC;
                            break;
                        }
                        psg.CountC += psg.PeriodC;
                        volc += psg.PeriodC;
                    }
                    if (psg.OutputC != 0) {
                        volc -= psg.CountC;
                    }
                } else {
                    psg.CountC -= nextevent;
                    while (psg.CountC <= 0) {
                        psg.CountC += psg.PeriodC;
                        if (psg.CountC > 0) {
                            psg.OutputC ^= 1;
                            break;
                        }
                        psg.CountC += psg.PeriodC;
                    }
                }
                psg.CountN -= nextevent;
                if (psg.CountN > 0) continue;
                if ((psg.RNG + 1 & 2) != 0) {
                    psg.OutputN ^= 0xFFFFFFFF;
                    outn = psg.OutputN | psg.Regs[7];
                }
                if ((psg.RNG & 1) != 0) {
                    psg.RNG ^= 0x28000;
                }
                psg.RNG >>= 1;
                psg.CountN += psg.PeriodN;
            } while ((left -= nextevent) > 0);
            if (psg.Holding == 0) {
                psg.CountE -= 4096;
                if (psg.CountE <= 0) {
                    do {
                        --psg.CountEnv;
                        psg.CountE += psg.PeriodE;
                    } while (psg.CountE <= 0);
                    if (psg.CountEnv < 0) {
                        if (psg.Hold != 0) {
                            if (psg.Alternate != 0) {
                                psg.Attack ^= 0x1F;
                            }
                            psg.Holding = 1;
                            psg.CountEnv = 0;
                        } else {
                            if (psg.Alternate != 0 && (psg.CountEnv & 0x20) != 0) {
                                psg.Attack ^= 0x1F;
                            }
                            psg.CountEnv &= 0x1F;
                        }
                    }
                    psg.VolE = psg.VolTable[psg.CountEnv ^ psg.Attack];
                    if (psg.EnvelopeA != 0) {
                        psg.VolA = psg.VolE;
                    }
                    if (psg.EnvelopeB != 0) {
                        psg.VolB = psg.VolE;
                    }
                    if (psg.EnvelopeC != 0) {
                        psg.VolC = psg.VolE;
                    }
                }
            }
            int a1 = vola * psg.VolA / 4096;
            int a2 = volb * psg.VolB / 4096;
            int a3 = volc * psg.VolC / 4096;
            int at = a1 + a2 + a3;
            this.writeLinBuffer(pbuf1, this.readLinBuffer(pbuf1) + at);
            ++pbuf1;
            --length;
        }
    }

    public void AY8910_set_clock(int chip, int clock) {
        AY8910Context psg = ay[chip];
        psg.UpdateStep = 4096 * super.getSampFreq() * 8 / clock;
    }

    public void build_mixer_table(int chip) {
        AY8910Context psg = ay[chip];
        double out = 2730.0;
        int i = 31;
        while (i > 0) {
            psg.VolTable[i] = (int)(out + 0.5);
            out /= 1.188502227;
            --i;
        }
        psg.VolTable[0] = 0;
    }

    public void AY8910_reset(int chip) {
        AY8910Context psg = ay[chip];
        psg.register_latch = 0;
        psg.RNG = 1;
        psg.OutputA = 0;
        psg.OutputB = 0;
        psg.OutputC = 0;
        psg.OutputN = 255;
        psg.lastEnable = -1;
        int i = 0;
        while (i < 14) {
            this._AYWriteReg(chip, i, 0);
            ++i;
        }
    }

    public void AY8910_sh_reset() {
        int i = 0;
        while (i < this.num + ym_num) {
            this.AY8910_reset(i);
            ++i;
        }
    }

    public int AY8910_init(String chip_name, int chip, int clock, int volume, int samprate, int portAread, int portBread, int portAwrite, int portBwrite) {
        System.out.println("AY8910_init " + chip);
        AY8910.ay[chip] = new AY8910Context();
        AY8910Context psg = ay[chip];
        int[] vol = new int[3];
        psg.PortAread = portAread;
        psg.PortBread = portBread;
        psg.PortAwrite = portAwrite;
        psg.PortBwrite = portBwrite;
        int i = 0;
        while (i < 3) {
            vol[i] = volume;
            ++i;
        }
        this.AY8910_set_clock(chip, clock);
        psg.PeriodA = psg.UpdateStep;
        psg.PeriodB = psg.UpdateStep;
        psg.PeriodC = psg.UpdateStep;
        psg.PeriodE = psg.UpdateStep;
        psg.PeriodN = psg.UpdateStep;
        return 0;
    }

    public ReadHandler ay8910_read_port_0_r() {
        return new AY8910_read_port_r(0);
    }

    public ReadHandler ay8910_read_port_1_r() {
        return new AY8910_read_port_r(1);
    }

    public ReadHandler ay8910_read_port_2_r() {
        return new AY8910_read_port_r(2);
    }

    public ReadHandler ay8910_read_port_3_r() {
        return new AY8910_read_port_r(3);
    }

    public ReadHandler ay8910_read_port_4_r() {
        return new AY8910_read_port_r(4);
    }

    public WriteHandler AY8910_control_port_0_w() {
        return new AY8910_control_port_w(0);
    }

    public WriteHandler AY8910_control_port_1_w() {
        return new AY8910_control_port_w(1);
    }

    public WriteHandler AY8910_control_port_2_w() {
        return new AY8910_control_port_w(2);
    }

    public WriteHandler AY8910_control_port_3_w() {
        return new AY8910_control_port_w(3);
    }

    public WriteHandler AY8910_control_port_4_w() {
        return new AY8910_control_port_w(4);
    }

    public WriteHandler AY8910_write_port_0_w() {
        return new AY8910_write_port_w(0);
    }

    public WriteHandler AY8910_write_port_1_w() {
        return new AY8910_write_port_w(1);
    }

    public WriteHandler AY8910_write_port_2_w() {
        return new AY8910_write_port_w(2);
    }

    public WriteHandler AY8910_write_port_3_w() {
        return new AY8910_write_port_w(3);
    }

    public WriteHandler AY8910_write_port_4_w() {
        return new AY8910_write_port_w(4);
    }

    class AY8910Context {
        public int Channel;
        public int SampleRate;
        public int PortAread;
        public int PortBread;
        public int PortAwrite;
        public int PortBwrite;
        int register_latch;
        int[] Regs = new int[16];
        int lastEnable;
        int UpdateStep;
        int PeriodA;
        int PeriodB;
        int PeriodC;
        int PeriodN;
        int PeriodE;
        int CountA;
        int CountB;
        int CountC;
        int CountN;
        int CountE;
        int VolA;
        int VolB;
        int VolC;
        int VolE;
        int EnvelopeA;
        int EnvelopeB;
        int EnvelopeC;
        int OutputA;
        int OutputB;
        int OutputC;
        int OutputN;
        int CountEnv;
        int Hold;
        int Alternate;
        int Attack;
        int Holding;
        int RNG;
        int[] VolTable = new int[32];

        AY8910Context() {
        }
    }

    class AY8910_read_port_r
    implements ReadHandler {
        int context;

        public AY8910_read_port_r(int context) {
            this.context = context;
        }

        public int read(int address) {
            return AY8910.this.AY8910Read(this.context);
        }
    }

    class AY8910_control_port_w
    implements WriteHandler {
        int context;

        public AY8910_control_port_w(int context) {
            this.context = context;
        }

        public void write(int address, int data) {
            AY8910.this.AY8910Write(this.context, 0, data);
        }
    }

    class AY8910_write_port_w
    implements WriteHandler {
        int context;

        public AY8910_write_port_w(int context) {
            this.context = context;
        }

        public void write(int address, int data) {
            AY8910.this.AY8910Write(this.context, 1, data);
        }
    }
}

