/*
 * Decompiled with CFR 0.152.
 */
package j51;

import j51.J51Panel;
import j51.intel.MCS51;
import j51.util.FastArray;
import j51.util.Hex;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

public class JAssembly
extends J51Panel {
    private AbstractTableModel tm;
    private JTable jt;
    private FastArray breakPoint = new FastArray();
    private FastArray pcs = new FastArray();
    private boolean completed = false;

    JAssembly() {
        super("Assembler", false);
        this.tm = new AbstractTableModel(){

            @Override
            public int getRowCount() {
                return JAssembly.this.completed ? JAssembly.this.pcs.size() : JAssembly.this.pcs.size() + 1;
            }

            @Override
            public int getColumnCount() {
                return 3;
            }

            @Override
            public Object getValueAt(int n, int n2) {
                if (n >= JAssembly.this.pcs.size()) {
                    JAssembly.this.decode(-1, n);
                }
                if (n >= JAssembly.this.pcs.size()) {
                    return null;
                }
                int n3 = JAssembly.this.pc(n);
                switch (n2) {
                    case 0: {
                        return JAssembly.this.breakPoint.get(n);
                    }
                    case 1: {
                        return Hex.bin2word(n3);
                    }
                    case 2: {
                        return JAssembly.this.cpu.getDecodeAt(n3).substring(5);
                    }
                }
                return null;
            }

            @Override
            public String getColumnName(int n) {
                switch (n) {
                    case 0: {
                        return "";
                    }
                    case 1: {
                        return "Addr";
                    }
                    case 2: {
                        return "Code";
                    }
                }
                return null;
            }

            public Class getColumnClass(int n) {
                return this.getValueAt(0, n).getClass();
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return n2 == 0;
            }

            @Override
            public void setValueAt(Object object, int n, int n2) {
                Boolean bl = (Boolean)object;
                JAssembly.this.breakPoint.set(n, bl);
                JAssembly.this.cpu.setBreakPoint(JAssembly.this.pc(n), bl);
            }
        };
        this.jt = new JTable(this.tm);
        this.jt.setDefaultRenderer(String.class, new Renderer());
        JScrollPane jScrollPane = new JScrollPane(this.jt);
        jScrollPane.setVerticalScrollBarPolicy(22);
        jScrollPane.setHorizontalScrollBarPolicy(32);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.anchor = 10;
        this.add((Component)jScrollPane, gridBagConstraints);
    }

    private int pc(int n) {
        return (Integer)this.pcs.get(n);
    }

    private void decode(int n, int n2) {
        int n3;
        int n4 = 0;
        if (this.pcs.size() == 0) {
            n3 = 0;
        } else {
            n3 = this.pc(this.pcs.size() - 1);
            n3 += this.cpu.getLengthAt(n3);
        }
        int n5 = this.pcs.size();
        while (true) {
            if (n3 >= this.cpu.getCodeSize()) {
                this.completed = true;
                break;
            }
            if (n2 >= 0 && this.pcs.size() > n2 || n >= 0 && n3 > n) break;
            ++n4;
            this.pcs.add(new Integer(n3));
            this.breakPoint.add(new Boolean(false));
            n3 += this.cpu.getLengthAt(n3);
            this.tm.fireTableRowsInserted(this.pcs.size() - 1, this.pcs.size() - 1);
        }
    }

    private void createTable() {
        this.pcs.clear();
        this.breakPoint.clear();
        this.completed = false;
        for (int i = 0; i < this.tm.getColumnCount(); ++i) {
            JComponent jComponent;
            TableColumn tableColumn = this.jt.getColumnModel().getColumn(i);
            switch (i) {
                default: {
                    jComponent = new JTextField(50);
                    break;
                }
                case 1: {
                    jComponent = new JTextField(4);
                    break;
                }
                case 0: {
                    jComponent = new JCheckBox();
                }
            }
            Dimension dimension = ((Component)jComponent).getPreferredSize();
            tableColumn.setPreferredWidth(dimension.width);
            tableColumn.setResizable(false);
        }
        this.tm.fireTableDataChanged();
    }

    @Override
    public void setCpu(MCS51 mCS51) {
        super.setCpu(mCS51);
        this.createTable();
    }

    @Override
    public void update(boolean bl) {
        if (bl) {
            this.createTable();
        }
        int n = 0;
        this.decode(this.cpu.pc(), -1);
        for (int i = 0; i < this.pcs.size(); ++i) {
            if (this.pc(i) < this.cpu.pc()) continue;
            n = i;
            break;
        }
        Rectangle rectangle = this.jt.getCellRect(n, 0, true);
        this.jt.scrollRectToVisible(rectangle);
        this.jt.clearSelection();
        this.jt.setRowSelectionInterval(n, n);
    }

    @Override
    public void setEmulation(boolean bl) {
        this.jt.setEnabled(!bl);
    }

    class Renderer
    extends DefaultTableCellRenderer {
        Renderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            Font font = this.getFont();
            font = new Font("Monospaced", font.getStyle(), font.getSize());
            this.setFont(font);
            return this;
        }
    }
}

