/*
 * Decompiled with CFR 0.152.
 */
package j51.diseqc;

import j51.diseqc.Diseqc;
import j51.diseqc.Motor;
import j51.diseqc.Satellite;
import j51.intel.AsyncTimerListener;
import j51.intel.EmulationListener;
import j51.intel.MCS51;
import j51.intel.MCS51Peripheral;
import j51.intel.MemoryReadListener;
import j51.intel.ResetListener;
import j51.intel.SfrWriteListener;
import j51.swing.JFactory;
import j51.swing.JLed;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JToggleButton;

public class DiseqcPeripheral
extends JPanel
implements MCS51Peripheral,
SfrWriteListener,
MemoryReadListener,
AsyncTimerListener,
ResetListener,
EmulationListener {
    private final int MIN = -900;
    private final int MAX = 900;
    private MCS51 cpu;
    private JLed ledw = new JLed("West", Color.green);
    private JLed lede = new JLed("East", Color.green);
    private JLed led = new JLed("Status", Color.blue);
    private JLed ledp = new JLed("Power", Color.red);
    private JToggleButton gow = new JToggleButton("GO WEST");
    private JToggleButton goe = new JToggleButton("GO EAST");
    private Motor m = new Satellite();
    private int motorPosition = 0;
    private int pulseWidth;
    private int pulseTime;
    boolean motorPower = false;
    private JSlider sDelay = new JSlider(0, 100);
    private JSlider sWidth = new JSlider(0, 100);

    public DiseqcPeripheral() {
        super(new GridBagLayout());
        JFactory.setTitle(this, "Diseqc motor");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.sWidth.setValue(15);
        this.sWidth.setMajorTickSpacing(10);
        this.sWidth.setPaintLabels(true);
        this.sWidth.setPaintTicks(true);
        this.sWidth.setPaintTrack(true);
        this.sDelay.setValue(50);
        this.sDelay.setMajorTickSpacing(10);
        this.sDelay.setPaintLabels(true);
        this.sDelay.setPaintTicks(true);
        this.sDelay.setPaintTrack(true);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        this.add((Component)new JLabel("Pulse witdh (ms)"), gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.add(this.sWidth);
        ++gridBagConstraints.gridx;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 2;
        this.add(this.m.getComponent(), gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)new JLabel("Pulse period (ms)"), gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.add((Component)this.sDelay, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        this.add((Component)this.ledw, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.add((Component)this.led, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.add((Component)this.ledp, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.add((Component)this.lede, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        this.add((Component)this.gow, gridBagConstraints);
        gridBagConstraints.gridx += 2;
        this.add((Component)this.goe, gridBagConstraints);
    }

    @Override
    public void reset(MCS51 mCS51) {
        int n;
        Diseqc diseqc = (Diseqc)mCS51;
        if (diseqc.eeprom(0) != 21930) {
            return;
        }
        this.motorPosition = n = diseqc.eeprom(2) - 32768;
        if (this.motorPosition < -900) {
            this.motorPosition = -900;
        }
        if (this.motorPosition > 900) {
            this.motorPosition = 900;
        }
        this.m.setPosition(this.motorPosition);
    }

    @Override
    public int readMemory(int n, int n2) {
        n2 |= 3;
        if (this.goe.isSelected()) {
            n2 &= 0xFFFFFFFE;
        }
        if (this.gow.isSelected()) {
            n2 &= 0xFFFFFFFD;
        }
        return n2;
    }

    public void writeP1(int n) {
        this.lede.set((n & 0x80) != 0);
        this.ledw.set((n & 0x40) != 0);
    }

    @Override
    public void sfrWrite(int n, int n2) {
        if (n == 128) {
            boolean bl;
            boolean bl2 = bl = (n2 & 8) == 0;
            if (bl && !this.motorPower) {
                this.cpu.addAsyncTimerListenerMillis(this.pulseTime, this);
            }
            this.motorPower = bl;
            this.led.set((n2 & 4) == 0);
            this.ledp.set(this.motorPower);
        } else {
            this.lede.set((n2 & 0x80) != 0);
            this.ledw.set((n2 & 0x40) != 0);
        }
    }

    @Override
    public void expired(MCS51 mCS51) {
        if (!this.motorPower) {
            return;
        }
        int n = 0;
        if (this.lede.get()) {
            if (this.motorPosition > -900) {
                n = -1;
            }
        } else if (this.motorPosition < 900) {
            n = 1;
        }
        if (n != 0) {
            this.motorPosition += n;
            this.m.setPosition(this.motorPosition);
            this.cpu.sfrSet(144, 16);
            class EndPulse
            implements AsyncTimerListener {
                private int direction;

                EndPulse(int n) {
                    this.direction = n;
                }

                @Override
                public void expired(MCS51 mCS51) {
                    DiseqcPeripheral.this.motorPosition += this.direction;
                    DiseqcPeripheral.this.m.setPosition(DiseqcPeripheral.this.motorPosition);
                    DiseqcPeripheral.this.cpu.sfrReset(144, 16);
                    if (DiseqcPeripheral.this.motorPower) {
                        DiseqcPeripheral.this.cpu.addAsyncTimerListenerMillis(DiseqcPeripheral.this.pulseTime, DiseqcPeripheral.this);
                    }
                }
            }
            this.cpu.addAsyncTimerListenerMillis(this.pulseWidth, new EndPulse(n));
        }
    }

    @Override
    public void setEmulation(boolean bl) {
        if (bl) {
            this.pulseTime = this.sDelay.getValue();
            this.pulseWidth = this.sWidth.getValue();
        }
        this.sWidth.setEnabled(!bl);
        this.sDelay.setEnabled(!bl);
    }

    @Override
    public void registerCpu(MCS51 mCS51) {
        this.cpu = mCS51;
        mCS51.addSfrWriteListener(128, this);
        mCS51.addSfrWriteListener(144, this);
        mCS51.addSfrMemoryReadListener(128, this);
        mCS51.addResetListener(this);
        mCS51.addEmulationListener(this);
        this.pulseWidth = 15;
        this.pulseTime = 50;
    }
}

