/*
 * Decompiled with CFR 0.152.
 */
package j51.i2c;

import j51.i2c.I2cSlave;
import j51.intel.MCS51;
import j51.intel.MCS51Peripheral;
import j51.intel.MemoryWriteListener;
import j51.intel.OpenCollectorMemoryBit;
import j51.intel.ResetListener;
import j51.util.Hex;
import j51.util.Logger;
import java.util.Vector;

public class I2cBus
implements MemoryWriteListener,
MCS51Peripheral,
ResetListener {
    private static Logger log = Logger.getLogger(I2cBus.class);
    protected OpenCollectorMemoryBit SCL;
    protected OpenCollectorMemoryBit SDA;
    private boolean oldScl;
    private boolean oldSda;
    private int state;
    private int bitCount;
    private int value;
    private I2cSlave ph;
    private boolean ack;
    private boolean read;
    private int address;
    private boolean ignore;
    private int byteCount;
    private boolean lastByte;
    private Vector<I2cSlave> slaves = new Vector();

    public I2cBus(OpenCollectorMemoryBit openCollectorMemoryBit, OpenCollectorMemoryBit openCollectorMemoryBit2) {
        this.setScl(openCollectorMemoryBit);
        this.setSda(openCollectorMemoryBit2);
    }

    @Override
    public void registerCpu(MCS51 mCS51) {
        mCS51.addResetListener(this);
    }

    public void setScl(OpenCollectorMemoryBit openCollectorMemoryBit) {
        this.SCL = openCollectorMemoryBit;
        this.SCL.addMemoryWriteListener(this);
    }

    public void setSda(OpenCollectorMemoryBit openCollectorMemoryBit) {
        this.SDA = openCollectorMemoryBit;
        this.SDA.addMemoryWriteListener(this);
    }

    @Override
    public void reset(MCS51 mCS51) {
        this.SDA.set(true);
        this.SCL.set(true);
        this.oldSda = this.SDA.get();
        this.oldScl = this.SCL.get();
        this.i2cIdle();
    }

    private void i2cIdle() {
        this.bitCount = 0;
        this.ph = null;
        this.ack = false;
        this.read = false;
        this.ignore = false;
        this.lastByte = false;
        this.byteCount = 0;
    }

    protected void i2cStart() {
        this.bitCount = 0;
        if (this.ph != null) {
            I2cSlave i2cSlave = this.ph;
            log.fine("Repeated start condition");
            this.i2cIdle();
            this.ph = i2cSlave;
        } else {
            log.fine("Start condition");
            this.i2cIdle();
        }
    }

    protected void i2cStop() {
        log.fine("Stop condition");
        this.i2cIdle();
    }

    public void addSlave(I2cSlave i2cSlave) {
        this.slaves.add(i2cSlave);
    }

    private boolean searchSlave(int n) {
        n &= 0xFE;
        for (int i = 0; i < this.slaves.size(); ++i) {
            this.ph = this.slaves.elementAt(i);
            if (!this.ph.i2cAddress(n)) continue;
            return true;
        }
        return false;
    }

    protected void i2cRecv(int n) {
        log.fine("I2CRECV " + Hex.bin2byte(n));
        if (this.ph == null) {
            this.address = n;
            if (this.searchSlave(n)) {
                log.fine("Found " + this.ph);
                this.ack = this.ph.i2cWrite(this.byteCount++, n);
            } else {
                log.info("Not found Peripheral at " + Hex.bin2byte(n));
            }
        } else {
            this.ack = this.ph.i2cWrite(this.byteCount++, n);
        }
    }

    protected void i2cSend(boolean bl) {
        if (this.lastByte) {
            return;
        }
        switch (this.bitCount) {
            case 0: {
                this.value = this.ph.i2cRead(this.byteCount++) & 0xFF;
                log.fine("I2CSEND " + Hex.bin2byte(this.value) + " count " + this.byteCount);
            }
            default: {
                if ((this.value & 0x80) != 0) {
                    this.SDA.set(true);
                } else {
                    this.SDA.set(false);
                }
                this.value <<= 1;
                ++this.bitCount;
                break;
            }
            case 8: {
                this.lastByte = bl;
                log.finer("Last byte " + this.lastByte);
                ++this.bitCount;
            }
        }
        log.finer("Send Clock " + this.bitCount + " Bit " + this.SDA.get() + " value " + Hex.bin2byte(this.value));
    }

    protected void i2cRecv(boolean bl) {
        switch (this.bitCount) {
            case 0: {
                this.value = 0;
            }
            default: {
                this.value <<= 1;
                if (bl) {
                    this.value |= 1;
                }
                if (++this.bitCount != 8) break;
                this.i2cRecv(this.value);
                break;
            }
            case 8: {
                ++this.bitCount;
            }
        }
    }

    protected void i2cRise(boolean bl) {
        log.finer("I2CRise " + bl);
        if (this.read) {
            this.i2cSend(bl);
        } else {
            this.i2cRecv(bl);
        }
    }

    protected void i2cFail(boolean bl) {
        log.finer("I2CFail " + bl);
        if (this.bitCount == 8) {
            if (this.read) {
                log.finer("Release SDA");
                this.SDA.set(true);
            } else if (this.ack) {
                log.finer("ACK SDA");
                this.SDA.set(false);
            } else {
                this.SDA.set(true);
                log.finer("NACK SDA");
            }
        } else if (this.bitCount == 9) {
            this.ack = false;
            if (!this.read) {
                this.SDA.set(true);
            }
            this.bitCount = 0;
            if (this.byteCount == 1) {
                boolean bl2 = this.read = (this.value & 1) != 0;
                if (this.read) {
                    log.finer("Read operation");
                } else {
                    log.finer("Write operation");
                }
            }
        }
    }

    protected void bus(boolean bl, boolean bl2) {
        if (this.ignore) {
            return;
        }
        if (this.oldScl == bl && bl2 == this.oldSda) {
            return;
        }
        this.ignore = true;
        log.finest("ENTER SCL=" + bl + ",SDA=" + bl2 + " OSCL=" + this.oldScl + ",OSDA=" + this.oldSda + " LSCL=" + this.SCL.getLocal() + ",LSDA=" + this.SDA.getLocal());
        if (bl && this.oldScl && this.oldSda && !bl2) {
            this.i2cStart();
        }
        if (bl && this.oldScl && !this.oldSda && bl2) {
            this.i2cStop();
        }
        if (!this.oldScl && bl) {
            this.i2cRise(bl2);
        }
        if (this.oldScl && !bl) {
            this.i2cFail(bl2);
        }
        this.oldScl = this.SCL.get();
        this.oldSda = this.SDA.get();
        this.ignore = false;
        log.finest("LEAVE SCL=" + bl + ",SDA=" + bl2 + " OSCL=" + this.oldScl + ",OSDA=" + this.oldSda + " LSCL=" + this.SCL.getLocal() + ",LSDA=" + this.SDA.getLocal());
    }

    @Override
    public void writeMemory(int n, int n2, int n3) {
        this.bus(this.SCL.get(), this.SDA.get());
    }
}

