/*
 * Decompiled with CFR 0.152.
 */
package j51.intel;

import j51.intel.MCS51;
import j51.intel.Uart;
import j51.util.Hex;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class JUart
extends Uart
implements KeyListener {
    private JTextArea textArea = new JTextArea(1000, 80);

    public JUart() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        dimension.height /= 4;
        dimension.width /= 4;
        this.textArea.setLineWrap(true);
        this.setPreferredSize(dimension);
        this.textArea.setForeground(Color.green);
        this.textArea.setBackground(Color.black);
        this.add((Component)new JScrollPane(this.textArea, 22, 32), "Center");
        Font font = this.textArea.getFont();
        font = new Font("Monospaced", 0, font.getSize());
        this.textArea.setFont(font);
        this.textArea.addKeyListener(this);
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        keyEvent.consume();
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyChar();
        if (keyEvent.getKeyCode() == 10) {
            n = 13;
        }
        if (n == 10) {
            n = 13;
        }
        if (n != 65535) {
            this.recvChar(n);
        }
        keyEvent.consume();
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        keyEvent.consume();
    }

    @Override
    public void reset(MCS51 mCS51) {
        super.reset(mCS51);
        this.textArea.setText("");
    }

    @Override
    protected void sendChar(int n) {
        byte[] byArray = new byte[]{(byte)n};
        if ((n < 32 || n >= 127) && n != 13 && n != 10 && n != 9 && n != 8) {
            String string = "<" + Hex.bin2byte(n) + ">";
            this.textArea.append(string);
        } else {
            this.textArea.append(new String(byArray));
        }
        this.textArea.setCaretPosition(this.textArea.getDocument().getLength());
        int n2 = 20480;
        int n3 = 500;
        int n4 = this.textArea.getDocument().getLength() - n2;
        if (n4 >= n3) {
            this.textArea.replaceRange("", 0, n4);
        }
    }
}

