/*
 * Decompiled with CFR 0.152.
 */
package j51.intel;

import j51.util.Hex;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import javax.swing.Timer;

public class PersistentBuffer {
    private byte[] buffer;
    private String filename;
    private boolean loaded = false;
    private Timer timer = null;
    private String name;

    public PersistentBuffer(String string, String string2, int n) {
        this.buffer = new byte[n];
        this.name = string;
        this.filename = string + "." + n + "." + string2;
        for (int i = 0; i < n; ++i) {
            this.buffer[i] = -1;
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(new File(this.filename));
            fileInputStream.read(this.buffer);
            fileInputStream.close();
            this.loaded = true;
            System.out.println(this.filename + " loaded");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public int getSize() {
        return this.buffer.length;
    }

    private void checkAddr(int n) {
        if (n >= this.buffer.length) {
            throw new Error(this.name + " 0x" + Hex.bin2word(n) + " out of range, max 0x" + Hex.bin2word(this.buffer.length));
        }
    }

    public int get(int n) {
        this.checkAddr(n);
        return this.buffer[n] & 0xFF;
    }

    public int get16(int n) {
        return (this.buffer[n] & 0xFF) << 8 | this.buffer[n + 1] & 0xFF;
    }

    public synchronized void set(int n, int n2) {
        byte by = (byte)(n2 & 0xFF);
        this.checkAddr(n);
        if (this.buffer[n] != by) {
            this.buffer[n] = by;
            if (this.timer == null) {
                this.timer = new Timer(1000, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        PersistentBuffer.this.timer.stop();
                        PersistentBuffer.this.save();
                    }
                });
                this.timer.start();
            } else {
                this.timer.restart();
            }
        }
    }

    private synchronized void save() {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(new File(this.filename));
            fileOutputStream.write(this.buffer);
            fileOutputStream.close();
            System.out.println(this.filename + " saved");
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }
}

