/*
 * Decompiled with CFR 0.152.
 */
package j51.intel;

import j51.intel.InterruptSource;
import j51.intel.MCS51;
import j51.intel.MCS51Constants;
import j51.intel.MCS51Peripheral;
import j51.intel.ResetListener;
import j51.intel.SfrReadListener;
import j51.intel.SfrWriteListener;
import j51.swing.JFactory;
import java.awt.BorderLayout;
import javax.swing.JPanel;

public class Uart
extends JPanel
implements MCS51Peripheral,
SfrWriteListener,
SfrReadListener,
MCS51Constants,
InterruptSource,
ResetListener {
    private int sbuf = 63;
    private boolean sbufReaded;
    protected MCS51 cpu;
    private byte[] inBuffer = new byte[0x100000];
    int inPs;
    int inPl;

    public Uart() {
        super(new BorderLayout());
        JFactory.setTitle(this, "Uart");
    }

    @Override
    public void reset(MCS51 mCS51) {
        this.inPl = 0;
        this.inPs = 0;
        this.sbufReaded = true;
    }

    @Override
    public void registerCpu(MCS51 mCS51) {
        this.cpu = mCS51;
        mCS51.addSfrWriteListener(153, this);
        mCS51.addSfrReadListener(153, this);
        mCS51.addInterruptSource(168, this, "UART0");
        mCS51.addInterruptSource(152, this, "UART0");
        mCS51.addResetListener(this);
    }

    @Override
    public int sfrRead(int n) {
        switch (n) {
            case 153: {
                int n2 = this.sbuf;
                this.sbufReaded = true;
                this.rxWakeup();
                return n2;
            }
        }
        return 0;
    }

    @Override
    public void sfrWrite(int n, int n2) {
        byte[] byArray = new byte[1];
        switch (n) {
            case 153: {
                this.sendChar(n2);
                this.cpu.sfrSet(152, 2);
            }
        }
    }

    @Override
    public int getInterruptVector() {
        return 35;
    }

    @Override
    public void interruptStart() {
    }

    @Override
    public void interruptStop() {
    }

    @Override
    public boolean interruptCondition() {
        return (this.cpu.sfr(168) & 0x10) != 0 && ((this.cpu.sfr(152) & 1) != 0 || (this.cpu.sfr(152) & 2) != 0);
    }

    protected void sendChar(int n) {
    }

    private synchronized void rxWakeup() {
        if (this.inPl == this.inPs) {
            return;
        }
        if (this.cpu.sfrIsSet(152, 1)) {
            return;
        }
        if (!this.sbufReaded) {
            return;
        }
        this.sbuf = this.inBuffer[this.inPl] & 0xFF;
        this.sbufReaded = false;
        this.cpu.sfrSet(152, 1);
        if (++this.inPl >= this.inBuffer.length) {
            this.inPl = 0;
        }
    }

    protected synchronized void recvChar(int n) {
        int n2 = this.inPs + 1;
        if (n2 > this.inBuffer.length) {
            n2 = 0;
        }
        if (n2 == this.inPl) {
            return;
        }
        this.inBuffer[this.inPs] = (byte)n;
        this.inPs = n2;
        this.rxWakeup();
    }
}

