/*
 * Decompiled with CFR 0.152.
 */
package j51.lcd;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.util.HashMap;
import javax.swing.JComponent;

public class GLcd
extends JComponent {
    private int pixelSize;
    private int width;
    private int height;
    private Color colorBack = new Color(0, 0, 0);
    private Color colorFront = new Color(0, 255, 0);
    private Dimension size;
    private byte[] memory;
    private HashMap patterns = new HashMap();

    public GLcd(int n, int n2, int n3) {
        this.width = n;
        this.height = n2;
        this.pixelSize = n3;
        this.size = new Dimension(n * n3, n2 * n3);
        this.setPreferredSize(this.size);
        this.memory = new byte[n / 8 * n2];
        for (int i = 0; i < this.memory.length; ++i) {
            this.memory[i] = 0;
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Insets insets = this.getInsets();
        graphics.translate(insets.left, insets.top);
        for (int i = 0; i < this.width; i += 8) {
            for (int j = 0; j < this.height; ++j) {
                graphics.drawImage(this.getImage(i, j), this.pixelSize * i, this.pixelSize * j, null);
            }
        }
    }

    public byte getMemory(int n) {
        return this.memory[n];
    }

    public void setMemory(int n, byte by) {
        if (this.memory[n] != by) {
            this.memory[n] = by;
            this.repaint();
        }
    }

    public Image getImage(int n, int n2) {
        byte by = this.memory[n2 * this.width / 8 + n / 8];
        Image image = (Image)this.patterns.get(new Integer(by));
        if (image == null) {
            image = this.createImage(8 * this.pixelSize, this.pixelSize);
            Graphics graphics = image.getGraphics();
            graphics.setColor(this.colorBack);
            graphics.fillRect(0, 0, this.width * this.pixelSize, this.height * this.pixelSize);
            graphics.setColor(this.colorFront);
            for (int i = 0; i < 8; ++i) {
                if ((by & 1 << 7 - i) == 0) continue;
                graphics.fillRect(i * this.pixelSize, 0, this.pixelSize, this.pixelSize);
            }
            this.patterns.put(new Integer(by), image);
        }
        return image;
    }
}

