/*
 * Decompiled with CFR 0.152.
 */
package j51.test;

import j51.intel.MCS51;
import j51.intel.MCS51Peripheral;
import j51.intel.SfrReadListener;
import j51.intel.SfrWriteListener;
import j51.lcd.GLcd;

class G128x64
extends GLcd
implements MCS51Peripheral,
SfrWriteListener,
SfrReadListener {
    private final int ADDL = 253;
    private final int ADDH = 254;
    private final int DATA = 255;
    MCS51 cpu;
    private int address = 0;

    public G128x64() {
        super(128, 64, 2);
    }

    @Override
    public void registerCpu(MCS51 mCS51) {
        this.cpu = mCS51;
        mCS51.addSfrWriteListener(253, this);
        mCS51.addSfrWriteListener(254, this);
        mCS51.addSfrWriteListener(255, this);
        mCS51.addSfrReadListener(255, this);
    }

    @Override
    public void sfrWrite(int n, int n2) {
        switch (n) {
            case 253: {
                this.address &= 0xFF00;
                this.address |= n2 & 0xFF;
                break;
            }
            case 254: {
                this.address &= 0xFF;
                this.address |= n2 << 8;
                break;
            }
            case 255: {
                this.setMemory(this.address, (byte)(n2 & 0xFF));
            }
        }
    }

    @Override
    public int sfrRead(int n) {
        return this.getMemory(this.address) & 0xFF;
    }
}

