/*
 * Decompiled with CFR 0.152.
 */
package agjava.net;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.NoRouteToHostException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;

public class Network
extends Thread {
    public Socket clientSocket = null;
    public ServerSocket serverSocket = null;
    public boolean connected = true;
    public DataInputStream Recv;
    public DataOutputStream Send;
    private int Port;
    public String Host;
    private final String ENC_TYPE = "ISO-8859-1";

    public Network(int n) {
        this.Port = n;
    }

    public Network(String string, int n) {
        this.Host = string;
        this.Port = n;
    }

    public void Bind() {
        try {
            this.serverSocket = new ServerSocket(this.Port);
        }
        catch (IOException iOException) {
            System.err.println("Network.IOException(3): " + iOException);
        }
    }

    public Socket BindListen() {
        try {
            this.serverSocket = new ServerSocket(this.Port);
            this.clientSocket = this.serverSocket.accept();
            OutputStream outputStream = this.clientSocket.getOutputStream();
            InputStream inputStream = this.clientSocket.getInputStream();
            this.Send = new DataOutputStream(outputStream);
            this.Recv = new DataInputStream(inputStream);
            this.connected = true;
            this.serverSocket.close();
            return this.clientSocket;
        }
        catch (IOException iOException) {
            System.err.println("Network.IOException(2) " + iOException);
            this.connected = false;
            try {
                this.serverSocket.close();
                this.clientSocket.close();
            }
            catch (IOException iOException2) {}
            return this.clientSocket;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println("Network.Exception(2): " + exception);
            this.connected = false;
            try {
                this.serverSocket.close();
                this.clientSocket.close();
            }
            catch (IOException iOException) {}
            return this.clientSocket;
        }
    }

    public Socket Connect() {
        try {
            this.clientSocket = new Socket(this.Host, this.Port);
            OutputStream outputStream = this.clientSocket.getOutputStream();
            InputStream inputStream = this.clientSocket.getInputStream();
            this.Send = new DataOutputStream(outputStream);
            this.Recv = new DataInputStream(inputStream);
            this.connected = true;
            return this.clientSocket;
        }
        catch (UnknownHostException unknownHostException) {
            System.err.println("Unknown Host: " + this.Host);
            this.connected = false;
            try {
                this.clientSocket.close();
            }
            catch (IOException iOException) {}
            return this.clientSocket;
        }
        catch (NoRouteToHostException noRouteToHostException) {
            System.err.println("Host unreachable: " + this.Host);
            this.connected = false;
            try {
                this.clientSocket.close();
            }
            catch (IOException iOException) {}
            return this.clientSocket;
        }
        catch (IOException iOException) {
            System.err.println("Network.IOException(1): " + iOException);
            iOException.printStackTrace();
            this.connected = false;
            try {
                this.clientSocket.close();
            }
            catch (IOException iOException2) {}
            return this.clientSocket;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println("Network.Exception(1): " + exception);
            this.connected = false;
            try {
                this.clientSocket.close();
            }
            catch (IOException iOException) {}
            return this.clientSocket;
        }
    }

    public Socket Listen() {
        try {
            this.clientSocket = this.serverSocket.accept();
            OutputStream outputStream = this.clientSocket.getOutputStream();
            InputStream inputStream = this.clientSocket.getInputStream();
            this.Send = new DataOutputStream(outputStream);
            this.Recv = new DataInputStream(inputStream);
            this.connected = true;
            return this.clientSocket;
        }
        catch (IOException iOException) {
            System.err.println("Network.IOException(4) " + iOException);
            this.connected = false;
            return this.clientSocket;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println("Network.Exception(4): " + exception);
            this.connected = false;
            return this.clientSocket;
        }
    }

    public void close() {
        try {
            this.clientSocket.close();
        }
        catch (IOException iOException) {
        }
        catch (Exception exception) {}
    }

    public static final String getHostID() {
        try {
            String string = InetAddress.getLocalHost().toString();
            string = string.substring(string.lastIndexOf("/") + 1);
            return string;
        }
        catch (UnknownHostException unknownHostException) {
            System.err.println("Error getting Local IP: " + unknownHostException);
            return "";
        }
    }

    public static final String getHostname() {
        try {
            String string = InetAddress.getLocalHost().toString();
            string = string.substring(0, string.lastIndexOf("/"));
            return string;
        }
        catch (UnknownHostException unknownHostException) {
            System.err.println("Error getting Local Hostname: " + unknownHostException);
            return "unknownHost";
        }
    }

    public int readByte() {
        try {
            int n = this.Recv.read();
            short s = (short)n;
            return s;
        }
        catch (SocketException socketException) {
            return -1;
        }
        catch (IOException iOException) {
            System.err.println("Network.Exception(8): " + iOException);
            return -1;
        }
    }

    public int readInt() {
        try {
            int n = this.Recv.readInt();
            return n;
        }
        catch (SocketException socketException) {
            return -1;
        }
        catch (IOException iOException) {
            System.err.println("Network.Exception(10): " + iOException);
            return -1;
        }
    }

    public long readLong() {
        try {
            long l = this.Recv.readLong();
            return l;
        }
        catch (SocketException socketException) {
            return -1L;
        }
        catch (IOException iOException) {
            System.err.println("Network.Exception(7): " + iOException);
            return -1L;
        }
    }

    public int readShort() {
        try {
            short s = this.Recv.readShort();
            return s;
        }
        catch (SocketException socketException) {
            return -1;
        }
        catch (EOFException eOFException) {
            return 0;
        }
        catch (IOException iOException) {
            System.err.println("Network.Exception(9): " + iOException);
            return -1;
        }
    }

    public String readString(int n) {
        StringBuffer stringBuffer = new StringBuffer(n);
        if (n <= 0) {
            return "";
        }
        byte[] byArray = new byte[n];
        try {
            this.Recv.read(byArray, 0, n);
            stringBuffer.append(new String(byArray, "ISO-8859-1"));
            return stringBuffer.toString();
        }
        catch (SocketException socketException) {
            return "";
        }
        catch (Exception exception) {
            System.err.println(exception);
            return "";
        }
    }

    public void send(byte by) {
        try {
            this.Send.writeByte(by);
        }
        catch (SocketException socketException) {
        }
        catch (IOException iOException) {
            System.err.println("Network.Exception(6): " + iOException);
        }
    }

    public void send(int n) {
        try {
            this.Send.writeInt(n);
        }
        catch (IOException iOException) {
            System.err.println("Network.IOException(5): " + iOException);
        }
    }

    public void send(long l) {
        try {
            this.Send.writeLong(l);
        }
        catch (SocketException socketException) {
        }
        catch (IOException iOException) {
            System.err.println("Network.Exception(5.1): " + iOException);
        }
    }

    public void send(String string) {
        try {
            this.Send.writeBytes(string);
        }
        catch (SocketException socketException) {
        }
        catch (IOException iOException) {
            System.err.println("Network.Exception(3): " + iOException);
        }
    }

    public void send(short s) {
        try {
            this.Send.writeShort(s);
        }
        catch (SocketException socketException) {
        }
        catch (IOException iOException) {
            System.err.println("Network.Exception(4): " + iOException);
        }
    }

    public final ServerSocket serverSocket() {
        return this.serverSocket;
    }

    public final Socket socket() {
        return this.clientSocket;
    }
}

