/*
 * Decompiled with CFR 0.152.
 */
package ants.p2p.filesharing;

import ants.p2p.Message;
import ants.p2p.NeighbourAnt;
import ants.p2p.filesharing.AutoresumeEngine;
import ants.p2p.filesharing.DownloadWatchDog;
import ants.p2p.filesharing.FileInfosPullerThread;
import ants.p2p.filesharing.PartialFile;
import ants.p2p.filesharing.PullerThread;
import ants.p2p.filesharing.WarriorAnt;
import ants.p2p.messages.FileInfosPullErrorControlMessage;
import ants.p2p.messages.FileInfosPushMessage;
import ants.p2p.messages.FilePartMessage;
import ants.p2p.messages.FilePullMessage;
import ants.p2p.messages.FilePushMessage;
import ants.p2p.messages.FileTransferErrorControlMessage;
import ants.p2p.query.QueryCompletedFileTuple;
import ants.p2p.query.QueryFileTuple;
import ants.p2p.query.QueryPartialFileTuple;
import ants.p2p.query.QueryRemoteFileTuple;
import ants.p2p.utils.encoding.Base16;
import ants.p2p.utils.indexer.BackgroundEngine;
import ants.p2p.utils.indexer.DigestManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import ji.JI;
import org.apache.log4j.Logger;

public class MultipleSourcesDownloadManager
extends Thread {
    static Logger _logger = Logger.getLogger((String)MultipleSourcesDownloadManager.class.getName());
    MultipleSourcesDownloadManager instance = null;
    AutoresumeEngine ae;
    String fileName;
    String fileHash;
    String ed2kFileHash;
    Object[] chunkHashes;
    String extendedInfos;
    long bytesDownloaded;
    long initialBytesDownloaded;
    long fileSize;
    int blockSize;
    List peerList = new ArrayList();
    List synchronizedPeerList = this.peerList;
    List inServicePeerList = new ArrayList();
    List synchronizedInServicePeerList = this.inServicePeerList;
    WarriorAnt n;
    boolean interrupt = false;
    boolean writingToDisk = false;
    long percWritten = 0L;
    boolean[] downloadedBlockGroups;
    boolean[] inServiceBlockGroups;
    int partId;
    DownloadWatchDog watchDog = new DownloadWatchDog(this);
    long assignedCoprime;
    PropertyChangeListener selfListener = null;
    PropertyChangeListener warriorAntListener = null;
    long startTime;
    public static int blocksPerSource;
    public static int MaxSources;
    public PropertyChangeSupport propertyChangeSupport;
    int chunckBlocksCounter = 0;

    public MultipleSourcesDownloadManager(WarriorAnt n, String fileName, String fileHash, String ed2kFileHash, long bytesDownloaded, int blockSize, long fileSize, String extendedInfos) throws Exception {
        this.instance = this;
        this.fileName = fileName;
        this.fileHash = fileHash;
        this.ed2kFileHash = ed2kFileHash;
        this.chunkHashes = null;
        this.extendedInfos = extendedInfos;
        this.bytesDownloaded = bytesDownloaded;
        this.initialBytesDownloaded = bytesDownloaded;
        this.fileSize = fileSize;
        this.blockSize = blockSize;
        blocksPerSource = PartialFile.computeGroupFactor(blockSize);
        this.n = n;
        this.setPriority(6);
        this.startTime = System.currentTimeMillis();
        this.downloadedBlockGroups = new boolean[(int)Math.ceil((double)fileSize / ((double)(blockSize * blocksPerSource) * 1.0))];
        this.inServiceBlockGroups = new boolean[this.downloadedBlockGroups.length];
        this.partId = 0;
        this.assignedCoprime = (long)Math.floor(Math.random() * (double)this.downloadedBlockGroups.length);
        while (!new BigInteger(this.assignedCoprime + "").gcd(new BigInteger(this.downloadedBlockGroups.length + "")).equals(BigInteger.ONE)) {
            ++this.assignedCoprime;
            if (this.assignedCoprime != (long)this.downloadedBlockGroups.length) continue;
            this.assignedCoprime = (long)Math.floor(Math.random() * (double)this.downloadedBlockGroups.length);
        }
        Arrays.fill(this.downloadedBlockGroups, false);
        Arrays.fill(this.inServiceBlockGroups, false);
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.selfListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("peerAvaiable")) {
                    MultipleSourcesDownloadManager.this.resume();
                }
            }
        };
        this.propertyChangeSupport.addPropertyChangeListener(this.selfListener);
        this.warriorAntListener = new PropertyChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Converted monitor instructions to comments
             * Lifted jumps to return sites
             */
            public void propertyChange(PropertyChangeEvent e) {
                Object peerId;
                Thread firer;
                Object object;
                boolean[] blArray;
                int id;
                int index;
                String suffix;
                String peerId2;
                if (e.getPropertyName().equals("filePartUpdate") && ((FilePartMessage)e.getNewValue()).getFilePushMessage().getFileName().lastIndexOf(MultipleSourcesDownloadManager.this.getFileHash()) >= 0) {
                    ++MultipleSourcesDownloadManager.this.chunckBlocksCounter;
                    MultipleSourcesDownloadManager.this.watchDog.setReceivedPart();
                    peerId2 = ((FilePartMessage)e.getNewValue()).getFilePushMessage().getSource();
                    MultipleSourcesDownloadManager.this.propertyChangeSupport.firePropertyChange("pullerThreadUpdatePart", null, peerId2);
                }
                if (e.getPropertyName().equals("filePartDownloadCompleted") && ((FilePushMessage)e.getNewValue()).getFileName().lastIndexOf(MultipleSourcesDownloadManager.this.getFileHash()) >= 0) {
                    MultipleSourcesDownloadManager.this.chunckBlocksCounter -= blocksPerSource;
                    if (MultipleSourcesDownloadManager.this.chunckBlocksCounter < 0) {
                        MultipleSourcesDownloadManager.this.chunckBlocksCounter = 0;
                    }
                    peerId2 = ((FilePushMessage)e.getNewValue()).getSource();
                    suffix = ((FilePushMessage)e.getNewValue()).getFileName();
                    index = suffix.lastIndexOf(".");
                    suffix = suffix.substring(index + 1, suffix.length());
                    id = Integer.parseInt(suffix);
                    MultipleSourcesDownloadManager.this.watchDog.setReceivedPart();
                    MultipleSourcesDownloadManager.this.propertyChangeSupport.firePropertyChange("pullerThreadCompletedPart", null, peerId2);
                    blArray = MultipleSourcesDownloadManager.this.downloadedBlockGroups;
                    // MONITORENTER : MultipleSourcesDownloadManager.this.downloadedBlockGroups
                    object = MultipleSourcesDownloadManager.this.inServiceBlockGroups;
                    // MONITORENTER : MultipleSourcesDownloadManager.this.inServiceBlockGroups
                    List list = MultipleSourcesDownloadManager.this.synchronizedInServicePeerList;
                    // MONITORENTER : list
                    List list2 = MultipleSourcesDownloadManager.this.synchronizedPeerList;
                    // MONITORENTER : list2
                    try {
                        DigestManager dm = new DigestManager();
                        if (dm.getDigest(new File(WarriorAnt.chunksHome + ((FilePushMessage)e.getNewValue()).getFileName())).equals(Base16.toHexString((byte[])MultipleSourcesDownloadManager.this.chunkHashes[id]))) {
                            _logger.info((Object)("File part accepted: " + Base16.toHexString((byte[])MultipleSourcesDownloadManager.this.chunkHashes[id])));
                            MultipleSourcesDownloadManager.this.downloadedBlockGroups[id] = true;
                            NeighbourAnt.totalDownloaded += (double)new File(WarriorAnt.chunksHome + ((FilePushMessage)e.getNewValue()).getFileName()).length();
                        } else {
                            _logger.info((Object)("File part rejected: " + Base16.toHexString((byte[])MultipleSourcesDownloadManager.this.chunkHashes[id])));
                        }
                    }
                    catch (Exception exc) {
                        _logger.error("Error in computing digest " + e != null ? e.getNewValue() : (e + " " + MultipleSourcesDownloadManager.this.chunkHashes != null ? MultipleSourcesDownloadManager.this.chunkHashes[id] : MultipleSourcesDownloadManager.this.chunkHashes), (Throwable)exc);
                    }
                    MultipleSourcesDownloadManager.this.inServiceBlockGroups[id] = false;
                    QueryFileTuple peer = MultipleSourcesDownloadManager.this.findInServicePeer(peerId2);
                    if (peer != null) {
                        MultipleSourcesDownloadManager.this.synchronizedInServicePeerList.remove(peer);
                        MultipleSourcesDownloadManager.this.synchronizedPeerList.add(peer);
                    }
                    MultipleSourcesDownloadManager.this.resume();
                    // MONITOREXIT : list2
                    // MONITOREXIT : list
                    // MONITOREXIT : object
                    // MONITOREXIT : blArray
                }
                if (e.getPropertyName().equals("filePartDownloadError") && ((FileTransferErrorControlMessage)e.getNewValue()).getFilePullMessage().getLocalFileName().lastIndexOf(MultipleSourcesDownloadManager.this.getFileHash()) >= 0) {
                    MultipleSourcesDownloadManager.this.chunckBlocksCounter -= blocksPerSource;
                    if (MultipleSourcesDownloadManager.this.chunckBlocksCounter < 0) {
                        MultipleSourcesDownloadManager.this.chunckBlocksCounter = 0;
                    }
                    peerId2 = ((FileTransferErrorControlMessage)e.getNewValue()).getSource();
                    MultipleSourcesDownloadManager.this.propertyChangeSupport.firePropertyChange("pullerThreadPartError", null, peerId2);
                    suffix = ((FileTransferErrorControlMessage)e.getNewValue()).getFilePullMessage().getLocalFileName();
                    index = suffix.lastIndexOf(".");
                    suffix = suffix.substring(index + 1, suffix.length());
                    id = Integer.parseInt(suffix);
                    blArray = MultipleSourcesDownloadManager.this.inServiceBlockGroups;
                    // MONITORENTER : MultipleSourcesDownloadManager.this.inServiceBlockGroups
                    List list = MultipleSourcesDownloadManager.this.synchronizedInServicePeerList;
                    object = list;
                    // MONITORENTER : list
                    MultipleSourcesDownloadManager.this.inServiceBlockGroups[id] = false;
                    if (((FileTransferErrorControlMessage)e.getNewValue()).getControlId() == 0) {
                        MultipleSourcesDownloadManager.this.removePeer(peerId2);
                        firer = new Thread(){

                            public void run() {
                                (this).MultipleSourcesDownloadManager.this.propertyChangeSupport.firePropertyChange("removedSourcePeer", (this).MultipleSourcesDownloadManager.this.instance, peerId2);
                            }
                        };
                        firer.start();
                    } else if (((FileTransferErrorControlMessage)e.getNewValue()).getControlId() == 1) {
                        Thread remover = new Thread(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void run() {
                                _logger.info((Object)("Waiting... 3 minutes for:\n" + (this).MultipleSourcesDownloadManager.this.instance + "\n" + peerId2));
                                try {
                                    2.sleep(120000L);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                                List list = (this).MultipleSourcesDownloadManager.this.synchronizedInServicePeerList;
                                synchronized (list) {
                                    List list2 = (this).MultipleSourcesDownloadManager.this.synchronizedPeerList;
                                    synchronized (list2) {
                                        QueryFileTuple peer = MultipleSourcesDownloadManager.this.findInServicePeer(peerId2);
                                        if (peer != null) {
                                            (this).MultipleSourcesDownloadManager.this.synchronizedInServicePeerList.remove(peer);
                                            (this).MultipleSourcesDownloadManager.this.synchronizedPeerList.add(peer);
                                        }
                                    }
                                }
                            }
                        };
                        remover.start();
                    }
                    MultipleSourcesDownloadManager.this.resume();
                    // MONITOREXIT : object
                    // MONITOREXIT : blArray
                }
                if (e.getPropertyName().equals("filePartDownloadInterrupted") && ((FilePushMessage)e.getNewValue()).getFileName().lastIndexOf(MultipleSourcesDownloadManager.this.getFileHash()) >= 0) {
                    MultipleSourcesDownloadManager.this.chunckBlocksCounter -= blocksPerSource;
                    if (MultipleSourcesDownloadManager.this.chunckBlocksCounter < 0) {
                        MultipleSourcesDownloadManager.this.chunckBlocksCounter = 0;
                    }
                    peerId2 = ((FilePushMessage)e.getNewValue()).getSource();
                    MultipleSourcesDownloadManager.this.propertyChangeSupport.firePropertyChange("pullerThreadPartError", null, peerId2);
                    suffix = ((FilePushMessage)e.getNewValue()).getFileName();
                    index = suffix.lastIndexOf(".");
                    suffix = suffix.substring(index + 1, suffix.length());
                    id = Integer.parseInt(suffix);
                    blArray = MultipleSourcesDownloadManager.this.inServiceBlockGroups;
                    // MONITORENTER : MultipleSourcesDownloadManager.this.inServiceBlockGroups
                    List list = MultipleSourcesDownloadManager.this.synchronizedInServicePeerList;
                    object = list;
                    // MONITORENTER : list
                    MultipleSourcesDownloadManager.this.inServiceBlockGroups[id] = false;
                    MultipleSourcesDownloadManager.this.removePeer(peerId2);
                    firer = new Thread(){

                        public void run() {
                            (this).MultipleSourcesDownloadManager.this.propertyChangeSupport.firePropertyChange("removedSourcePeer", (this).MultipleSourcesDownloadManager.this.instance, peerId2);
                        }
                    };
                    firer.start();
                    MultipleSourcesDownloadManager.this.resume();
                    // MONITOREXIT : object
                    // MONITOREXIT : blArray
                }
                if (e.getPropertyName().equals("fileInfosPullCompleted") && Base16.toHexString(((FileInfosPushMessage)e.getNewValue()).getHash()).equals(MultipleSourcesDownloadManager.this.getFileHash())) {
                    final QueryFileTuple qft = ((FileInfosPushMessage)e.getNewValue()).getQueryFileTuple();
                    peerId = qft.getOwnerID();
                    MultipleSourcesDownloadManager.this.propertyChangeSupport.firePropertyChange("fileInfosPullCompleteThread", null, peerId);
                    QueryFileTuple peer = MultipleSourcesDownloadManager.this.findInServicePeer((String)peerId);
                    MultipleSourcesDownloadManager.this.watchDog.setReceivedPart();
                    Thread firer2 = new Thread((String)peerId, peer){
                        private final /* synthetic */ String val$peerId;
                        private final /* synthetic */ QueryFileTuple val$peer;
                        {
                            this.val$peerId = string;
                            this.val$peer = queryFileTuple2;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            _logger.info((Object)"Checking chunks...");
                            if (qft.getChunkHashes().getChunkHashes() == null && (this).MultipleSourcesDownloadManager.this.instance.getChunkHashes() == null) {
                                try {
                                    _logger.info((Object)("Waiting... 2 minutes for chunks:\n" + (this).MultipleSourcesDownloadManager.this.instance + "\n" + this.val$peerId));
                                    4.sleep(120000L);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            }
                            List list = (this).MultipleSourcesDownloadManager.this.synchronizedInServicePeerList;
                            synchronized (list) {
                                List list2 = (this).MultipleSourcesDownloadManager.this.synchronizedPeerList;
                                synchronized (list2) {
                                    if (this.val$peer != null) {
                                        (this).MultipleSourcesDownloadManager.this.synchronizedInServicePeerList.remove(this.val$peer);
                                        (this).MultipleSourcesDownloadManager.this.synchronizedPeerList.add(this.val$peer);
                                    }
                                }
                            }
                            (this).MultipleSourcesDownloadManager.this.propertyChangeSupport.firePropertyChange("addSourcePeer", (this).MultipleSourcesDownloadManager.this.instance, qft);
                        }
                    };
                    firer2.start();
                    MultipleSourcesDownloadManager.this.resume();
                }
                if (e.getPropertyName().equals("fileInfosPullError")) {
                    String hash = null;
                    if (e.getNewValue() instanceof FileInfosPullErrorControlMessage) {
                        hash = Base16.toHexString(((FileInfosPullErrorControlMessage)e.getNewValue()).getContent());
                    }
                    if (e.getNewValue() instanceof FileInfosPushMessage) {
                        hash = Base16.toHexString(((FileInfosPushMessage)e.getNewValue()).getHash());
                    }
                    if (hash.equals(MultipleSourcesDownloadManager.this.getFileHash())) {
                        peerId = ((Message)e.getNewValue()).getSource();
                        MultipleSourcesDownloadManager.this.propertyChangeSupport.firePropertyChange("fileInfosPullErrorThread", null, peerId);
                        List peer = MultipleSourcesDownloadManager.this.synchronizedInServicePeerList;
                        // MONITORENTER : peer
                        MultipleSourcesDownloadManager.this.removePeer((String)peerId);
                        Thread firer3 = new Thread((String)peerId){
                            private final /* synthetic */ String val$peerId;
                            {
                                this.val$peerId = string;
                            }

                            public void run() {
                                (this).MultipleSourcesDownloadManager.this.propertyChangeSupport.firePropertyChange("removedSourcePeer", (this).MultipleSourcesDownloadManager.this.instance, this.val$peerId);
                            }
                        };
                        firer3.start();
                        MultipleSourcesDownloadManager.this.resume();
                        // MONITOREXIT : peer
                    }
                }
                if (e.getPropertyName().equals("infosPullerThreadRequestError") && ((FileInfosPullerThread)e.getNewValue()).fileHash.equals(MultipleSourcesDownloadManager.this.getFileHash())) {
                    peerId2 = ((FileInfosPullerThread)e.getNewValue()).peerId;
                    peerId = MultipleSourcesDownloadManager.this.synchronizedInServicePeerList;
                    // MONITORENTER : peerId
                    _logger.info((Object)"Infos puller thread request error");
                    MultipleSourcesDownloadManager.this.removePeer(peerId2);
                    Thread firer4 = new Thread(){

                        public void run() {
                            (this).MultipleSourcesDownloadManager.this.propertyChangeSupport.firePropertyChange("removedSourcePeer", (this).MultipleSourcesDownloadManager.this.instance, peerId2);
                        }
                    };
                    firer4.start();
                    MultipleSourcesDownloadManager.this.resume();
                    // MONITOREXIT : peerId
                }
                if (e.getPropertyName().equals("filePullerThreadRequestError") && ((PullerThread)e.getNewValue()).fileHash.equals(MultipleSourcesDownloadManager.this.getFileHash())) {
                    peerId2 = ((PullerThread)e.getNewValue()).peerId;
                    int id2 = ((PullerThread)e.getNewValue()).partId;
                    boolean[] firer4 = MultipleSourcesDownloadManager.this.inServiceBlockGroups;
                    // MONITORENTER : MultipleSourcesDownloadManager.this.inServiceBlockGroups
                    List firer3 = MultipleSourcesDownloadManager.this.synchronizedInServicePeerList;
                    // MONITORENTER : firer3
                    MultipleSourcesDownloadManager.this.inServiceBlockGroups[id2] = false;
                    MultipleSourcesDownloadManager.this.removePeer(peerId2);
                    _logger.info((Object)"File puller thread request error");
                    Thread firer5 = new Thread(){

                        public void run() {
                            (this).MultipleSourcesDownloadManager.this.propertyChangeSupport.firePropertyChange("removedSourcePeer", (this).MultipleSourcesDownloadManager.this.instance, peerId2);
                        }
                    };
                    firer5.start();
                    MultipleSourcesDownloadManager.this.resume();
                    // MONITOREXIT : firer3
                    // MONITOREXIT : firer4
                }
                if (e.getPropertyName().equals("filePullRequestError") && ((FilePullMessage)e.getNewValue()).getLocalFileName().lastIndexOf(MultipleSourcesDownloadManager.this.getFileHash()) >= 0) {
                    peerId2 = ((FilePullMessage)e.getNewValue()).getDest();
                    MultipleSourcesDownloadManager.this.propertyChangeSupport.firePropertyChange("pullerThreadPartError", null, peerId2);
                    String suffix2 = ((FilePullMessage)e.getNewValue()).getLocalFileName();
                    int index2 = suffix2.lastIndexOf(".");
                    suffix2 = suffix2.substring(index2 + 1, suffix2.length());
                    int id3 = Integer.parseInt(suffix2);
                    blArray = MultipleSourcesDownloadManager.this.inServiceBlockGroups;
                    // MONITORENTER : MultipleSourcesDownloadManager.this.inServiceBlockGroups
                    List list = MultipleSourcesDownloadManager.this.synchronizedInServicePeerList;
                    object = list;
                    // MONITORENTER : list
                    MultipleSourcesDownloadManager.this.inServiceBlockGroups[id3] = false;
                    MultipleSourcesDownloadManager.this.removePeer(peerId2);
                    _logger.info((Object)"File pull request error");
                    firer = new Thread(){

                        public void run() {
                            (this).MultipleSourcesDownloadManager.this.propertyChangeSupport.firePropertyChange("removedSourcePeer", (this).MultipleSourcesDownloadManager.this.instance, peerId2);
                        }
                    };
                    firer.start();
                    MultipleSourcesDownloadManager.this.resume();
                    // MONITOREXIT : object
                    // MONITOREXIT : blArray
                }
                if (e.getPropertyName().equals("filePushError") && ((FilePushMessage)e.getNewValue()).getFileName().lastIndexOf(MultipleSourcesDownloadManager.this.getFileHash()) >= 0) {
                    peerId2 = ((FilePushMessage)e.getNewValue()).getSource();
                    MultipleSourcesDownloadManager.this.propertyChangeSupport.firePropertyChange("pullerThreadPartError", null, peerId2);
                    String suffix3 = ((FilePushMessage)e.getNewValue()).getFileName();
                    int index3 = suffix3.lastIndexOf(".");
                    suffix3 = suffix3.substring(index3 + 1, suffix3.length());
                    int id4 = Integer.parseInt(suffix3);
                    blArray = MultipleSourcesDownloadManager.this.inServiceBlockGroups;
                    // MONITORENTER : MultipleSourcesDownloadManager.this.inServiceBlockGroups
                    List list = MultipleSourcesDownloadManager.this.synchronizedInServicePeerList;
                    object = list;
                    // MONITORENTER : list
                    MultipleSourcesDownloadManager.this.inServiceBlockGroups[id4] = false;
                    MultipleSourcesDownloadManager.this.removePeer(peerId2);
                    firer = new Thread(){

                        public void run() {
                            (this).MultipleSourcesDownloadManager.this.propertyChangeSupport.firePropertyChange("removedSourcePeer", (this).MultipleSourcesDownloadManager.this.instance, peerId2);
                        }
                    };
                    firer.start();
                    MultipleSourcesDownloadManager.this.resume();
                    // MONITOREXIT : object
                    // MONITOREXIT : blArray
                }
                if (e.getPropertyName().equals("filePartError") && ((FilePartMessage)e.getNewValue()).getFilePushMessage().getFileName().lastIndexOf(MultipleSourcesDownloadManager.this.getFileHash()) >= 0) {
                    peerId2 = ((FilePartMessage)e.getNewValue()).getSource();
                    MultipleSourcesDownloadManager.this.propertyChangeSupport.firePropertyChange("pullerThreadPartError", null, peerId2);
                    String suffix4 = ((FilePartMessage)e.getNewValue()).getFilePushMessage().getFileName();
                    int index4 = suffix4.lastIndexOf(".");
                    suffix4 = suffix4.substring(index4 + 1, suffix4.length());
                    int id5 = Integer.parseInt(suffix4);
                    blArray = MultipleSourcesDownloadManager.this.inServiceBlockGroups;
                    // MONITORENTER : MultipleSourcesDownloadManager.this.inServiceBlockGroups
                    List list = MultipleSourcesDownloadManager.this.synchronizedInServicePeerList;
                    object = list;
                    // MONITORENTER : list
                    MultipleSourcesDownloadManager.this.inServiceBlockGroups[id5] = false;
                    MultipleSourcesDownloadManager.this.removePeer(peerId2);
                    firer = new Thread(){

                        public void run() {
                            (this).MultipleSourcesDownloadManager.this.propertyChangeSupport.firePropertyChange("removedSourcePeer", (this).MultipleSourcesDownloadManager.this.instance, peerId2);
                        }
                    };
                    firer.start();
                    MultipleSourcesDownloadManager.this.resume();
                    // MONITOREXIT : object
                    // MONITOREXIT : blArray
                }
                if (!e.getPropertyName().equals("securityConnectionError")) return;
                _logger.error((Object)("Critical Security Error: stopping all downloads from " + (String)e.getOldValue()));
            }
        };
        n.getPropertyChangeSupport().addPropertyChangeListener(this.warriorAntListener);
        WarriorAnt.checkChunksPath();
        File store = new File(WarriorAnt.chunksHome + WarriorAnt.chunksPath + fileHash + ".mul");
        if (store.exists()) {
            ObjectInputStream ois = new ObjectInputStream(new FileInputStream(store));
            try {
                this.downloadedBlockGroups = (boolean[])ois.readObject();
                this.fileName = (String)ois.readObject();
                this.fileHash = (String)ois.readObject();
                this.ed2kFileHash = (String)ois.readObject();
                this.chunkHashes = (Object[])ois.readObject();
                this.bytesDownloaded = (Long)ois.readObject();
                this.initialBytesDownloaded = bytesDownloaded;
                this.fileSize = (Long)ois.readObject();
                this.blockSize = (Integer)ois.readObject();
                this.assignedCoprime = (Long)ois.readObject();
                String ieDummy = (String)ois.readObject();
                ois.close();
            }
            catch (Exception e) {
                ois.close();
                store.delete();
            }
        }
        this.checkDownloadedBlockGroups();
        if (!store.exists()) {
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(store));
            oos.writeObject(this.downloadedBlockGroups);
            oos.writeObject(fileName);
            oos.writeObject(fileHash);
            oos.writeObject(ed2kFileHash);
            oos.writeObject(this.chunkHashes);
            oos.writeObject(new Long(bytesDownloaded));
            oos.writeObject(new Long(fileSize));
            oos.writeObject(new Integer(blockSize));
            oos.writeObject(new Long(this.assignedCoprime));
            oos.writeObject(extendedInfos);
            oos.flush();
            oos.close();
        }
        if (this.chunkHashes != null) {
            BackgroundEngine.getInstance().addPartialFile(this);
        }
    }

    public int getPeersNumber() {
        return this.peerList.size() + this.inServicePeerList.size();
    }

    public int getAvaiablePreviewIndexes() {
        int x = 0;
        while (this.downloadedBlockGroups[x]) {
            ++x;
        }
        return x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addPeer(QueryFileTuple peerId) {
        List list = this.synchronizedInServicePeerList;
        synchronized (list) {
            List list2 = this.synchronizedPeerList;
            synchronized (list2) {
                if (peerId instanceof QueryCompletedFileTuple) {
                    QueryCompletedFileTuple qftPeerId = (QueryCompletedFileTuple)peerId;
                    if (this.chunkHashes == null && peerId.getChunkHashes().getChunkHashes() != null && peerId.checkHashesValidity()) {
                        this.chunkHashes = peerId.getChunkHashes().getChunkHashes();
                        BackgroundEngine.getInstance().addPartialFile(this);
                        this.propertyChangeSupport.firePropertyChange("peerAvaiable", null, null);
                    }
                    if (this.n.getOutputSecureConnectionManager(qftPeerId.getOwnerID()) != null) {
                        if (!this.synchronizedPeerList.contains(qftPeerId) && !this.synchronizedInServicePeerList.contains(qftPeerId) && this.synchronizedPeerList.size() + this.synchronizedInServicePeerList.size() < MaxSources) {
                            this.synchronizedPeerList.add(qftPeerId);
                            this.propertyChangeSupport.firePropertyChange("peerAvaiable", null, null);
                            return true;
                        }
                        if (this.synchronizedPeerList.contains(qftPeerId)) {
                            this.synchronizedPeerList.remove(qftPeerId);
                            this.synchronizedPeerList.add(qftPeerId);
                            return true;
                        }
                        if (this.synchronizedInServicePeerList.contains(qftPeerId)) {
                            this.synchronizedInServicePeerList.remove(qftPeerId);
                            this.synchronizedInServicePeerList.add(qftPeerId);
                            return true;
                        }
                    }
                } else if (peerId instanceof QueryPartialFileTuple) {
                    QueryPartialFileTuple qpftPeerId = (QueryPartialFileTuple)peerId;
                    if (this.chunkHashes == null && peerId.getChunkHashes() != null && peerId.checkHashesValidity()) {
                        this.chunkHashes = peerId.getChunkHashes().getChunkHashes();
                        this.propertyChangeSupport.firePropertyChange("peerAvaiable", null, null);
                    }
                    if (this.n.getOutputSecureConnectionManager(qpftPeerId.getOwnerID()) != null) {
                        if (!this.synchronizedPeerList.contains(qpftPeerId) && !this.synchronizedInServicePeerList.contains(qpftPeerId) && this.synchronizedPeerList.size() + this.synchronizedInServicePeerList.size() < MaxSources) {
                            if (this.getBlockSize() == qpftPeerId.getBlockSize().intValue() && blocksPerSource == qpftPeerId.getBlocksPerSource()) {
                                this.synchronizedPeerList.add(qpftPeerId);
                                this.propertyChangeSupport.firePropertyChange("peerAvaiable", null, null);
                                return true;
                            }
                        } else if (this.synchronizedPeerList.contains(qpftPeerId)) {
                            if (this.getBlockSize() == qpftPeerId.getBlockSize().intValue() && blocksPerSource == qpftPeerId.getBlocksPerSource()) {
                                this.synchronizedPeerList.remove(qpftPeerId);
                                this.synchronizedPeerList.add(qpftPeerId);
                                return true;
                            }
                        } else if (this.synchronizedInServicePeerList.contains(qpftPeerId) && this.getBlockSize() == qpftPeerId.getBlockSize().intValue() && blocksPerSource == qpftPeerId.getBlocksPerSource()) {
                            this.synchronizedInServicePeerList.remove(qpftPeerId);
                            this.synchronizedInServicePeerList.add(qpftPeerId);
                            return true;
                        }
                    }
                } else if (peerId instanceof QueryRemoteFileTuple) {
                    QueryRemoteFileTuple qrftPeerId = (QueryRemoteFileTuple)peerId;
                    _logger.info((Object)(!this.n.getIdent().equals(qrftPeerId.getOwnerID()) + ""));
                    _logger.info((Object)((qrftPeerId.getOwnerIP().equals("") || !this.n.getLocalInetAddress().equals(qrftPeerId.getOwnerIP())) + ""));
                    _logger.info((Object)(!this.synchronizedPeerList.contains(qrftPeerId) + ""));
                    _logger.info((Object)(!this.synchronizedInServicePeerList.contains(qrftPeerId) + ""));
                    if (!(this.n.getIdent().equals(qrftPeerId.getOwnerID()) || !qrftPeerId.getOwnerIP().equals("") && this.n.getLocalInetAddress().equals(qrftPeerId.getOwnerIP()) || this.synchronizedPeerList.contains(qrftPeerId) || this.synchronizedInServicePeerList.contains(qrftPeerId) || this.synchronizedPeerList.size() + this.synchronizedInServicePeerList.size() >= MaxSources)) {
                        this.synchronizedPeerList.add(qrftPeerId);
                        this.propertyChangeSupport.firePropertyChange("peerAvaiable", null, null);
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public List getPeerList() {
        return this.synchronizedPeerList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryFileTuple removePeer(String peerID) {
        List list = this.synchronizedInServicePeerList;
        synchronized (list) {
            List list2 = this.synchronizedPeerList;
            synchronized (list2) {
                QueryFileTuple peer = this.findPeer(peerID);
                if (peer != null) {
                    this.synchronizedPeerList.remove(peer);
                    return peer;
                }
                QueryFileTuple ispeer = this.findInServicePeer(peerID);
                if (ispeer != null) {
                    this.synchronizedInServicePeerList.remove(ispeer);
                    return ispeer;
                }
            }
        }
        return null;
    }

    public void removeAllPeers(boolean deactivateAutoresume) {
        int x;
        if (this.isAutoresumeActive() && deactivateAutoresume) {
            this.deactivateAutoresumeEngine();
        }
        for (x = this.synchronizedPeerList.size() - 1; x >= 0; --x) {
            this.propertyChangeSupport.firePropertyChange("removedSourcePeer", this, ((QueryFileTuple)this.synchronizedPeerList.get(x)).getOwnerID());
        }
        for (x = this.synchronizedInServicePeerList.size() - 1; x >= 0; --x) {
            this.propertyChangeSupport.firePropertyChange("removedSourcePeer", this, ((QueryFileTuple)this.synchronizedInServicePeerList.get(x)).getOwnerID());
        }
    }

    public void setInterrupt(boolean deactivateAutoresume) {
        if (this.isAutoresumeActive() && deactivateAutoresume) {
            this.deactivateAutoresumeEngine();
        }
        this.interrupt = true;
        this.resume();
    }

    public void resetInterrupt() {
        this.interrupt = false;
        this.resume();
    }

    public void removeAllPropertyChangeListeners() {
        PropertyChangeListener[] listeners = this.propertyChangeSupport.getPropertyChangeListeners();
        for (int x = 0; x < listeners.length; ++x) {
            this.propertyChangeSupport.removePropertyChangeListener(listeners[x]);
        }
        this.n.getPropertyChangeSupport().removePropertyChangeListener(this.warriorAntListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void run() {
        block42: {
            block40: {
                try {
                    this.startTime = System.currentTimeMillis();
                    WarriorAnt.checkChunksPath();
                    this.watchDog.start();
                    this.partId = 0;
lbl6:
                    // 2 sources

                    while (true) {
                        if (!this.n.isDisconnected() && !this.checkCompleted()) {
                            if (this.synchronizedPeerList.size() == 0 || this.synchronizedInServicePeerList.size() == MultipleSourcesDownloadManager.MaxSources) {
                                this.propertyChangeSupport.firePropertyChange("multipleDownloadSuspended", null, this);
                                MultipleSourcesDownloadManager._logger.debug((Object)(this + "\nsuspended! InService[" + this.synchronizedInServicePeerList.size() + "] Idle[" + this.synchronizedPeerList.size() + "]"));
                                this.suspend();
                            }
                            if (this.interrupt) {
                                MultipleSourcesDownloadManager._logger.info((Object)(this + "\ninterrupting! InService[" + this.synchronizedInServicePeerList.size() + "] Idle[" + this.synchronizedPeerList.size() + "]"));
                                while (this.synchronizedInServicePeerList.size() > 0) {
                                    Thread.sleep(1000L);
                                }
                                this.removeAllPropertyChangeListeners();
                                store /* !! */  = (boolean[])new File(WarriorAnt.chunksHome + WarriorAnt.chunksPath + this.fileHash + ".mul");
                                oos = new ObjectOutputStream(new FileOutputStream((File)store /* !! */ ));
                                oos.writeObject(this.downloadedBlockGroups);
                                oos.writeObject(this.fileName);
                                oos.writeObject(this.fileHash);
                                oos.writeObject(this.ed2kFileHash);
                                oos.writeObject(this.chunkHashes);
                                num = 0;
                                x = 0;
                                while (true) {
                                    if (x >= this.downloadedBlockGroups.length) {
                                        this.bytesDownloaded = num * (this.blockSize * MultipleSourcesDownloadManager.blocksPerSource);
                                        oos.writeObject(new Long(this.bytesDownloaded));
                                        oos.writeObject(new Long(this.fileSize));
                                        oos.writeObject(new Integer(this.blockSize));
                                        oos.writeObject(new Long(this.assignedCoprime));
                                        oos.writeObject(this.extendedInfos);
                                        oos.close();
                                        MultipleSourcesDownloadManager._logger.info((Object)(this.getFileHash() + ": MultipleSourcesDownloadManager stopped"));
                                        this.watchDog.terminate();
                                        return;
                                    }
                                    if (this.downloadedBlockGroups[x]) {
                                        ++num;
                                    }
                                    ++x;
                                }
                            }
                            store /* !! */  = this.downloadedBlockGroups;
                            // MONITORENTER : this.downloadedBlockGroups
                            oos = this.inServiceBlockGroups;
                            // MONITORENTER : this.inServiceBlockGroups
                            num = this.synchronizedInServicePeerList;
                            // MONITORENTER : num
                            x = this.synchronizedPeerList;
                            // MONITORENTER : x
                            t = this.synchronizedPeerList.size() - 1;
                            break block40;
                        }
                        if (!this.checkCompleted()) break;
                        this.removeAllPropertyChangeListeners();
                        this.deactivateAutoresumeEngine();
                        BackgroundEngine.getInstance().removePartialFile(this.getFileHash());
                        this.watchDog.terminate();
                        this.writingToDisk = true;
                        this.n.setWritingFile();
                        try {
                            MultipleSourcesDownloadManager._logger.info((Object)("Download completed: " + this.fileHash));
                            WarriorAnt.checkDownloadPath();
                            complete = new File(WarriorAnt.downloadPath + new File(this.fileName).getName());
                            fos = new FileOutputStream(complete);
                            x = 0;
lbl66:
                            // 2 sources

                            while (true) {
                                if (x < this.downloadedBlockGroups.length) {
                                    partial = new File(WarriorAnt.chunksHome + WarriorAnt.chunksPath + this.fileHash + "." + x);
                                    fis = new FileInputStream(partial);
                                    content = new byte[this.blockSize];
                                    break block42;
                                }
                                fos.flush();
                                fos.close();
                                this.writingToDisk = false;
                                this.n.resetWritingFile();
                                MultipleSourcesDownloadManager._logger.info((Object)("Written to disk: " + complete.getName()));
                                this.n.propertyChangeSupport.firePropertyChange("refreshDownloadGraphic", null, this);
                                data = new File(WarriorAnt.chunksHome + WarriorAnt.chunksPath + this.fileHash + ".mul");
                                data.delete();
                                break;
                            }
                        }
                        catch (Exception e) {
                            this.writingToDisk = false;
                            this.n.resetWritingFile();
                            MultipleSourcesDownloadManager._logger.info((Object)("Couldn't write to disk: " + this.fileName));
                            this.n.propertyChangeSupport.firePropertyChange("refreshDownloadGraphic", null, this);
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    MultipleSourcesDownloadManager._logger.error((Object)"", (Throwable)e);
                }
                this.interrupt = true;
                return;
            }
            while (true) {
                block47: {
                    block46: {
                        block44: {
                            block43: {
                                block45: {
                                    if (t < 0 || this.synchronizedInServicePeerList.size() >= MultipleSourcesDownloadManager.MaxSources || this.checkCompleted()) break block43;
                                    peerTuple = (QueryFileTuple)this.synchronizedPeerList.get(t);
                                    if (peerTuple instanceof QueryCompletedFileTuple && this.chunkHashes != null) break block44;
                                    if (!(peerTuple instanceof QueryPartialFileTuple) || this.chunkHashes == null) break block45;
                                    peerPartialFileTuple = (QueryPartialFileTuple)peerTuple;
                                    peerId = peerPartialFileTuple.getOwnerID();
                                    requiredPart = false;
                                    if (this.checkPartsToDownload(this.downloadedBlockGroups, this.inServiceBlockGroups, peerPartialFileTuple.getDownloadedBlockGroups())) break block46;
                                    instance = this;
                                    this.synchronizedPeerList.remove(peerTuple);
                                    this.synchronizedInServicePeerList.add(peerTuple);
                                    remover = new Thread(){

                                        public void run() {
                                            _logger.info((Object)("Waiting... 2 minutes for:\n" + instance + "\n" + peerId));
                                            try {
                                                3.sleep(120000L);
                                            }
                                            catch (InterruptedException ex) {
                                                // empty catch block
                                            }
                                            QueryFileTuple peer = MultipleSourcesDownloadManager.this.findInServicePeer(peerId);
                                            if (peer != null) {
                                                QueryRemoteFileTuple qrft = new QueryRemoteFileTuple(null, peerPartialFileTuple.getFileName(), peerPartialFileTuple.getFileHash(), peerPartialFileTuple.getED2KFileHash(), peerPartialFileTuple.getSize(), peerPartialFileTuple.getOwnerID(), peerPartialFileTuple.getOwnerIP(), peerPartialFileTuple.getExtendedInfos(), new Long(System.currentTimeMillis()));
                                                MultipleSourcesDownloadManager.this.synchronizedInServicePeerList.remove(peer);
                                                MultipleSourcesDownloadManager.this.synchronizedPeerList.add(qrft);
                                            }
                                        }
                                    };
                                    remover.start();
                                    break block47;
                                }
                                if (peerTuple instanceof QueryRemoteFileTuple || this.chunkHashes == null) {
                                    this.synchronizedPeerList.remove(peerTuple);
                                    this.synchronizedInServicePeerList.add(peerTuple);
                                    MultipleSourcesDownloadManager._logger.info((Object)(super.toString() + " Pulling file infos: " + this.fileName + " from id " + peerTuple.getOwnerID() + " - " + this.getFileHash()));
                                    MultipleSourcesDownloadManager._logger.info((Object)("Idle: " + this.synchronizedPeerList.size() + "    In service: " + this.synchronizedInServicePeerList.size()));
                                    puller = new FileInfosPullerThread(this, this.n, this.getFileHash(), peerTuple.getOwnerID(), this.getChunkHashes() == null);
                                    puller.start();
                                }
                                break block47;
                            }
                            // MONITOREXIT : x
                            // MONITOREXIT : num
                            // MONITOREXIT : oos
                            // MONITOREXIT : store /* !! */ 
                            this.checkDownloadedBlockGroups();
                            store /* !! */  = (boolean[])new File(WarriorAnt.chunksHome + WarriorAnt.chunksPath + this.fileHash + ".mul");
                            oos = new ObjectOutputStream(new FileOutputStream((File)store /* !! */ ));
                            oos.writeObject(this.downloadedBlockGroups);
                            oos.writeObject(this.fileName);
                            oos.writeObject(this.fileHash);
                            oos.writeObject(this.ed2kFileHash);
                            oos.writeObject(this.chunkHashes);
                            num = 0;
                            for (x = 0; x < this.downloadedBlockGroups.length; ++x) {
                                if (!this.downloadedBlockGroups[x]) continue;
                                ++num;
                            }
                            this.bytesDownloaded = num * (MultipleSourcesDownloadManager.blocksPerSource * this.blockSize);
                            oos.writeObject(new Long(this.bytesDownloaded));
                            oos.writeObject(new Long(this.fileSize));
                            oos.writeObject(new Integer(this.blockSize));
                            oos.writeObject(new Long(this.assignedCoprime));
                            oos.writeObject(this.extendedInfos);
                            oos.close();
                            ** continue;
                        }
                        peerFileTuple = (QueryCompletedFileTuple)peerTuple;
                        peerId = peerFileTuple.getOwnerID();
                        requiredPart = false;
                        this.partId = 0;
                        do {
                            if (!this.downloadedBlockGroups[this.partId] && !this.inServiceBlockGroups[this.partId]) {
                                this.synchronizedPeerList.remove(t);
                                curOffset = this.partId * (this.blockSize * MultipleSourcesDownloadManager.blocksPerSource);
                                resume = new File(WarriorAnt.chunksHome + WarriorAnt.chunksPath + this.fileHash + "." + this.partId);
                                if (resume.exists()) {
                                    try {
                                        dm = new DigestManager();
                                        if (dm.getDigest(resume).equals(Base16.toHexString((byte[])this.chunkHashes[this.partId]))) {
                                            MultipleSourcesDownloadManager._logger.info((Object)("File part already downloaded: " + Base16.toHexString((byte[])this.chunkHashes[this.partId])));
                                            this.downloadedBlockGroups[this.partId] = true;
                                            this.inServiceBlockGroups[this.partId] = false;
                                            this.partId = (int)(((long)this.partId + this.assignedCoprime) % (long)this.downloadedBlockGroups.length);
                                            continue;
                                        }
                                        resume.delete();
                                        MultipleSourcesDownloadManager._logger.info((Object)("File part rejected(deleted): " + Base16.toHexString((byte[])this.chunkHashes[this.partId])));
                                    }
                                    catch (Exception exc) {
                                        MultipleSourcesDownloadManager._logger.error((Object)"Error in computing digest, deleting...");
                                        resume.delete();
                                    }
                                }
                                MultipleSourcesDownloadManager._logger.info((Object)(super.toString() + " Pulling file " + this.fileName + " from id " + peerId + " - " + this.fileHash + "." + this.partId));
                                MultipleSourcesDownloadManager._logger.info((Object)(this.fileName + " " + MultipleSourcesDownloadManager.blocksPerSource + " " + this.blockSize));
                                requiredPart = true;
                                this.synchronizedInServicePeerList.add(peerTuple);
                                MultipleSourcesDownloadManager._logger.info((Object)("Idle: " + this.synchronizedPeerList.size() + "    In service: " + this.synchronizedInServicePeerList.size()));
                                this.inServiceBlockGroups[this.partId] = true;
                                puller = new PullerThread(this, this.n, this.fileName, this.fileHash, curOffset, MultipleSourcesDownloadManager.blocksPerSource, peerId, this.blockSize, WarriorAnt.chunksPath + this.fileHash + "." + this.partId, false, peerTuple, this.partId);
                                puller.start();
                            }
                            this.partId = (int)(((long)this.partId + this.assignedCoprime) % (long)this.downloadedBlockGroups.length);
                        } while (this.partId != 0 && !requiredPart);
                        break block47;
                    }
                    this.partId = 0;
                    do {
                        if (!this.downloadedBlockGroups[this.partId] && !this.inServiceBlockGroups[this.partId] && peerPartialFileTuple.getDownloadedBlockGroups()[this.partId]) {
                            this.synchronizedPeerList.remove(t);
                            curOffset = this.partId * (this.blockSize * MultipleSourcesDownloadManager.blocksPerSource);
                            resume = new File(WarriorAnt.chunksHome + WarriorAnt.chunksPath + this.fileHash + "." + this.partId);
                            if (resume.exists()) {
                                try {
                                    dm = new DigestManager();
                                    if (dm.getDigest(resume).equals(Base16.toHexString((byte[])this.chunkHashes[this.partId]))) {
                                        MultipleSourcesDownloadManager._logger.info((Object)("File part already downloaded: " + Base16.toHexString((byte[])this.chunkHashes[this.partId])));
                                        this.downloadedBlockGroups[this.partId] = true;
                                        this.inServiceBlockGroups[this.partId] = false;
                                        this.partId = (int)(((long)this.partId + this.assignedCoprime) % (long)this.downloadedBlockGroups.length);
                                        continue;
                                    }
                                    resume.delete();
                                    MultipleSourcesDownloadManager._logger.info((Object)("File part rejected(deleted): " + Base16.toHexString((byte[])this.chunkHashes[this.partId])));
                                }
                                catch (Exception exc) {
                                    MultipleSourcesDownloadManager._logger.error((Object)"Error in computing digest, deleting...");
                                    resume.delete();
                                }
                            }
                            MultipleSourcesDownloadManager._logger.info((Object)(super.toString() + " Pulling file " + this.fileName + " from id " + peerId + " - " + this.fileHash + "." + this.partId));
                            MultipleSourcesDownloadManager._logger.info((Object)(this.fileName + " " + MultipleSourcesDownloadManager.blocksPerSource + " " + this.blockSize));
                            requiredPart = true;
                            this.synchronizedInServicePeerList.add(peerTuple);
                            MultipleSourcesDownloadManager._logger.info((Object)("Idle: " + this.synchronizedPeerList.size() + "    In service: " + this.synchronizedInServicePeerList.size()));
                            this.inServiceBlockGroups[this.partId] = true;
                            puller = new PullerThread(this, this.n, this.fileName, this.fileHash, curOffset, MultipleSourcesDownloadManager.blocksPerSource, peerId, this.blockSize, WarriorAnt.chunksPath + this.fileHash + "." + this.partId, false, peerTuple, this.partId);
                            puller.start();
                        }
                        this.partId = (int)(((long)this.partId + this.assignedCoprime) % (long)this.downloadedBlockGroups.length);
                    } while (this.partId != 0 && !requiredPart);
                }
                --t;
            }
        }
        while (fis.available() > 0) {
            read = fis.read(content);
            if (read <= 0) continue;
            if (read < content.length) {
                reduced = new byte[read];
                for (g = 0; g < read; ++g) {
                    reduced[g] = content[g];
                }
                content = reduced;
            }
            fos.write(content);
        }
        fis.close();
        this.percWritten += partial.length();
        partial.delete();
        ++x;
        ** while (true)
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public String getFileHash() {
        return this.fileHash;
    }

    public String getED2KFileHash() {
        return this.ed2kFileHash;
    }

    public Object[] getChunkHashes() {
        return this.chunkHashes;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getExtendedInfos() {
        return this.extendedInfos;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public long getByteDownloaded() {
        return this.bytesDownloaded;
    }

    public boolean[] getDownloadedBlockGroups() {
        return this.downloadedBlockGroups;
    }

    public String getPercentage() {
        long den = this.downloadedBlockGroups.length * blocksPerSource;
        int num = 0;
        for (int x = 0; x < this.downloadedBlockGroups.length; ++x) {
            if (!this.downloadedBlockGroups[x]) continue;
            ++num;
        }
        double perc = (double)(num = num * blocksPerSource + this.chunckBlocksCounter) * 1.0 / (double)den * 100.0;
        if (perc < 0.0) {
            perc = 0.0;
        }
        if (perc > 100.0) {
            perc = 100.0;
        }
        return (int)perc + "%";
    }

    public String speedToString() {
        double speed = this.getSpeedValue();
        return ("" + speed).substring(0, ("" + speed).indexOf(".") + 2) + "KiB/s ";
    }

    public double getSpeedValue() {
        if (this.checkCompleted() || this.inServicePeerList.size() == 0) {
            return 0.0;
        }
        double elapsed = (double)(System.currentTimeMillis() - this.startTime) / 1000.0;
        long downloadedGroups = 0L;
        for (int x = 0; x < this.downloadedBlockGroups.length; ++x) {
            if (!this.downloadedBlockGroups[x]) continue;
            ++downloadedGroups;
        }
        downloadedGroups = downloadedGroups * (long)blocksPerSource + (long)this.chunckBlocksCounter;
        double speed = elapsed > 0.0 ? (double)(downloadedGroups * (long)this.blockSize - this.initialBytesDownloaded) / elapsed / Math.pow(2.0, 10.0) : 0.0;
        return speed > 0.0 ? speed : 0.0;
    }

    public String toString() {
        String result = this.interrupt && !this.checkCompleted() ? JI.i("Interrupting") : (this.chunkHashes == null ? JI.i("Getting hash map") : (!this.checkCompleted() ? this.getPercentage() : (this.checkCompleted() && this.writingToDisk ? JI.i("Writing...") : JI.i("Completed"))));
        while (result.length() < 5) {
            result = result + " ";
        }
        result = result + "  " + this.speedToString();
        while (result.length() < 22) {
            result = result + " ";
        }
        result = !this.checkCompleted() ? result + " " + this.sizeToString(this.bytesDownloaded) + "/" + this.sizeToString(this.getFileSize()) + " " : (this.writingToDisk ? result + " " + this.sizeToString(this.percWritten) + "/" + this.sizeToString(this.getFileSize()) + " " : result + this.sizeToString(this.getFileSize()) + " ");
        while (result.length() < 52) {
            result = result + " ";
        }
        result = result + " " + this.getFileHash() + "     ";
        result = result + this.getFileName();
        return result;
    }

    public String sizeToString(double dSize) {
        int index;
        int x;
        double currentSize = dSize;
        dSize /= Math.pow(2.0, 20.0);
        for (x = 1; dSize > 1.0 && x < 5; dSize /= Math.pow(2.0, 10.0), ++x) {
        }
        String suffix = " bytes";
        String size = currentSize + suffix;
        if (x == 2) {
            suffix = " Mib";
            size = new Double(currentSize * 1.0 / Math.pow(2.0, 20.0)).toString();
            index = size.indexOf(".");
            if (index >= 0) {
                size = size.substring(0, index + 2);
            }
            size = size + suffix;
        }
        if (x == 3) {
            suffix = " Gib";
            size = new Double(currentSize * 1.0 / Math.pow(2.0, 30.0)).toString();
            index = size.indexOf(".");
            if (index >= 0) {
                size = size.substring(0, index + 2);
            }
            size = size + suffix;
        }
        if (x == 4) {
            suffix = " Tib";
            size = new Double(currentSize * 1.0 / Math.pow(2.0, 40.0)).toString();
            index = size.indexOf(".");
            if (index >= 0) {
                size = size.substring(0, index + 2);
            }
            size = size + suffix;
        }
        return size;
    }

    public boolean checkPartsToDownload(boolean[] downloadedBlockGroups, boolean[] inServiceBlockGroups, boolean[] remoteParts) throws Exception {
        if (downloadedBlockGroups.length != remoteParts.length) {
            throw new Exception("Array sizes do not match");
        }
        for (int x = 0; x < downloadedBlockGroups.length; ++x) {
            if (downloadedBlockGroups[x] || inServiceBlockGroups[x] || !remoteParts[x]) continue;
            return true;
        }
        return false;
    }

    public void checkDownloadedBlockGroups() {
        for (int x = 0; x < this.downloadedBlockGroups.length; ++x) {
            File currentFile = new File(WarriorAnt.chunksHome + WarriorAnt.chunksPath + this.getFileHash() + "." + x);
            if (x != this.downloadedBlockGroups.length - 1) {
                if (currentFile.exists() && currentFile.length() == (long)(blocksPerSource * this.blockSize)) {
                    this.downloadedBlockGroups[x] = true;
                    continue;
                }
                this.downloadedBlockGroups[x] = false;
                continue;
            }
            this.downloadedBlockGroups[x] = currentFile.exists() && currentFile.length() == this.fileSize - (long)((this.downloadedBlockGroups.length - 1) * (blocksPerSource * this.blockSize));
        }
    }

    public QueryFileTuple findPeer(String peerId) {
        for (int x = 0; x < this.peerList.size(); ++x) {
            if (!((QueryFileTuple)this.peerList.get(x)).getOwnerID().equals(peerId)) continue;
            return (QueryFileTuple)this.peerList.get(x);
        }
        return null;
    }

    public QueryFileTuple findInServicePeer(String peerId) {
        for (int x = 0; x < this.inServicePeerList.size(); ++x) {
            if (!((QueryFileTuple)this.inServicePeerList.get(x)).getOwnerID().equals(peerId)) continue;
            return (QueryFileTuple)this.inServicePeerList.get(x);
        }
        return null;
    }

    public void addAutoresumeEngine(AutoresumeEngine ae) {
        if (this.ae != null && !this.ae.deactivated()) {
            this.ae.deactivate();
        }
        this.ae = ae;
        if (this.ae != null && !this.ae.isAlive()) {
            this.ae.start();
            while (!this.ae.isAlive()) {
                try {
                    Thread.currentThread();
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public AutoresumeEngine getAutoresumeEngine() {
        return this.ae;
    }

    public void deactivateAutoresumeEngine() {
        if (this.ae != null && !this.ae.deactivated()) {
            this.ae.deactivate();
            this.ae = null;
        }
    }

    public boolean isAutoresumeActive() {
        return this.ae != null && !this.ae.deactivated();
    }

    public boolean checkCompleted() {
        boolean completed = true;
        for (int x = 0; x < this.downloadedBlockGroups.length; ++x) {
            if (this.downloadedBlockGroups[x]) continue;
            completed = false;
        }
        return completed;
    }

    static {
        MaxSources = 5;
    }
}

