/*
 * Decompiled with CFR 0.152.
 */
package ants.p2p.gui;

import ants.p2p.query.QueryHashItem;
import ants.p2p.utils.indexer.BackgroundEngine;
import ants.p2p.utils.indexer.FileSource;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;

class FileNameCellRenderer
extends DefaultTableCellRenderer {
    TableModel model;

    public FileNameCellRenderer(TableModel model) {
        this.model = model;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        comp.setFont(new Font("Monospaced", 0, 11));
        if (BackgroundEngine.getInstance().getLocalFile((String)this.model.getValueAt(row, 6), QueryHashItem.ANTS_HASH) != null) {
            comp.setForeground(Color.blue);
        } else if (BackgroundEngine.getInstance().getPartialFile((String)this.model.getValueAt(row, 6), QueryHashItem.ANTS_HASH) != null) {
            comp.setForeground(new Color(50, 120, 160));
        } else if (((FileSource)this.model.getValueAt(row, 1)).getSourceNumber() == 0) {
            long timeSlice = System.currentTimeMillis() - ((FileSource)this.model.getValueAt(row, 1)).getLastTimeSeen();
            if (timeSlice > (long)BackgroundEngine.remoteIndexedDocumentsTimeout) {
                comp.setForeground(new Color(255, 0, 0));
            } else if (timeSlice > 0L) {
                int color = (int)Math.floor((double)timeSlice * 255.0 / 3600000.0);
                comp.setForeground(new Color(color, 0, 0));
            } else {
                comp.setForeground(new Color(0, 0, 0));
            }
        } else {
            comp.setForeground(new Color(0, 0, 0));
        }
        return comp;
    }
}

