/*
 * Decompiled with CFR 0.152.
 */
package ants.p2p.http;

import ants.p2p.MessageWrapper;
import ants.p2p.http.HttpInterruptTransferMessage;
import ants.p2p.http.HttpProxy;
import ants.p2p.http.HttpRequestMessage;
import ants.p2p.http.HttpRequestSenderWatchDog;
import ants.p2p.http.HttpResponsePartMessage;
import ants.p2p.http.HttpTransferEndControlMessage;
import ants.p2p.security.EndpointSecurityManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.log4j.Logger;

public class HttpRequestSender
extends Thread
implements PropertyChangeListener {
    Socket s = null;
    InputStream is;
    OutputStream os;
    HttpProxy proxy;
    HttpRequestMessage httpRequestMessage = null;
    HttpRequestSenderWatchDog watchDog;
    ArrayList receivedParts = new ArrayList();
    int lastWrittenId = -1;
    static Logger _logger = Logger.getLogger((String)HttpRequestSender.class.getName());
    String httpMonitor = "HTTP_MONITOR";

    public HttpRequestSender(Socket s, HttpProxy proxy) {
        this.proxy = proxy;
        try {
            this.s = s;
            this.is = s.getInputStream();
            this.os = s.getOutputStream();
        }
        catch (Exception e) {
            _logger.error((Object)"Initialization error", (Throwable)e);
        }
    }

    public HttpRequestMessage getHttpRequestMessage() {
        return this.httpRequestMessage;
    }

    public void run() {
        try {
            this.watchDog = new HttpRequestSenderWatchDog(this);
            _logger.debug((Object)"Getting request from browser...");
            ArrayList<byte[]> byteList = new ArrayList<byte[]>();
            int total = 0;
            do {
                byte[] bytes = new byte[1024];
                int n = this.is.read(bytes);
                total += n;
                byteList.add(bytes);
            } while (this.is.available() > 0);
            this.s.shutdownInput();
            _logger.debug((Object)"Merging request parts...");
            byte[] request = new byte[total];
            int copied = 0;
            for (int x = 0; x < byteList.size(); ++x) {
                byte[] currentBytesList = (byte[])byteList.get(x);
                for (int k = 0; k < currentBytesList.length && copied < total; ++k, ++copied) {
                    request[copied] = currentBytesList[k];
                }
            }
            _logger.debug((Object)"Show Browser Request:");
            String browserRequest = "";
            for (int x = 0; x < request.length; ++x) {
                browserRequest = browserRequest + (char)request[x];
            }
            _logger.debug((Object)browserRequest);
            _logger.debug((Object)"Sending request...");
            EndpointSecurityManager esm = this.proxy.getWarriorAnt().getOutputSecureConnectionManager(this.proxy.getNodeID());
            if (esm == null) {
                this.s.close();
                throw new Exception("No secure connection avaiable with endpoint " + this.proxy.getNodeID());
            }
            this.httpRequestMessage = new HttpRequestMessage(request);
            this.httpRequestMessage.encrypt(esm.getCipherEnc());
            MessageWrapper wm = this.proxy.getWarriorAnt().sendMessage(this.httpRequestMessage, this.proxy.getNodeID(), true, false);
            while (this.proxy.getWarriorAnt().myMessages.contains(wm)) {
                Thread.sleep(1000L);
            }
            if (this.proxy.getWarriorAnt().failedMessages.contains(wm)) {
                this.httpRequestMessage.decrypt(esm.getCipherDec());
                this.proxy.getWarriorAnt().failedMessages.remove(wm);
                _logger.debug((Object)(this.proxy.getWarriorAnt().getShortId() + ": Error in sending HttpRequestMessage" + " - Cannot send pull request to id " + this.httpRequestMessage.getDest()));
                this.proxy.getWarriorAnt().propertyChangeSupport.firePropertyChange("httpRequestError", null, this.httpRequestMessage);
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkAndWriteReceivedParts() throws Exception {
        String string = this.httpMonitor;
        synchronized (string) {
            _logger.info((Object)"Checking and Writing parts...");
            while (this.receivedParts.size() != 0 && ((HttpResponsePartMessage)this.receivedParts.get(0)).getId() == this.lastWrittenId + 1) {
                boolean socketClosed;
                HttpResponsePartMessage rp = (HttpResponsePartMessage)this.receivedParts.remove(0);
                boolean bl = socketClosed = this.s.isOutputShutdown() || this.s.isClosed();
                if (!socketClosed) {
                    _logger.info((Object)"HTTP connection alive! Writing parts");
                    try {
                        this.os.write(rp.getBody());
                    }
                    catch (IOException ex) {
                        _logger.error((Object)"Socket closed", (Throwable)ex);
                        socketClosed = true;
                    }
                    ++this.lastWrittenId;
                }
                if (!socketClosed) continue;
                _logger.info((Object)"HTTP connection closed! Aborting!");
                EndpointSecurityManager esm = this.proxy.getWarriorAnt().getOutputSecureConnectionManager(this.proxy.getNodeID());
                if (esm == null) {
                    this.s.close();
                    throw new Exception("No secure connection avaiable with endpoint " + this.proxy.getNodeID());
                }
                HttpInterruptTransferMessage httpInterruptMessage = new HttpInterruptTransferMessage(new Integer(0), new byte[0], "HTTPInterruptTransfer", this.httpRequestMessage);
                httpInterruptMessage.encrypt(esm.getCipherEnc());
                MessageWrapper wm = this.proxy.getWarriorAnt().sendMessage(httpInterruptMessage, this.proxy.getNodeID(), true, false);
                while (this.proxy.getWarriorAnt().myMessages.contains(wm)) {
                    Thread.sleep(1000L);
                }
                if (this.proxy.getWarriorAnt().failedMessages.contains(wm)) {
                    httpInterruptMessage.decrypt(esm.getCipherDec());
                    this.proxy.getWarriorAnt().failedMessages.remove(wm);
                    _logger.debug((Object)(this.proxy.getWarriorAnt().getShortId() + ": Error in sending HttpInterruptMessage" + " - Cannot send pull request to id " + httpInterruptMessage.getDest()));
                    this.proxy.getWarriorAnt().propertyChangeSupport.firePropertyChange("httpInterruptError", null, httpInterruptMessage);
                    return;
                }
                this.watchDog.stop();
                this.proxy.removeHandler(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addReceivedPartToList(HttpResponsePartMessage rp) {
        String string = this.httpMonitor;
        synchronized (string) {
            if (this.lastWrittenId >= rp.getId()) {
                return;
            }
            for (int x = 0; x < this.receivedParts.size(); ++x) {
                if (!((HttpResponsePartMessage)this.receivedParts.get(x)).getId().equals(rp.getId())) continue;
                return;
            }
            this.receivedParts.add(rp);
            Collections.sort(this.receivedParts);
        }
    }

    public void propertyChange(PropertyChangeEvent e) {
        try {
            if (e.getPropertyName().equals("httpResponsePart")) {
                if (e.getNewValue() instanceof HttpResponsePartMessage && ((HttpResponsePartMessage)e.getNewValue()).getRequest().equals(this.getHttpRequestMessage())) {
                    _logger.info((Object)("Received HTTP response part: local " + this.s.getLocalPort() + " remote " + this.s.getPort()));
                    this.watchDog.trigger();
                    this.addReceivedPartToList((HttpResponsePartMessage)e.getNewValue());
                    this.checkAndWriteReceivedParts();
                }
            } else if (e.getPropertyName().equals("httpResponseEnd") && e.getNewValue() instanceof HttpTransferEndControlMessage && ((HttpTransferEndControlMessage)e.getNewValue()).getHttpRequestMessage().equals(this.getHttpRequestMessage())) {
                _logger.info((Object)("Received HTTP response end: local " + this.s.getLocalPort() + " remote " + this.s.getPort()));
                this.checkAndWriteReceivedParts();
                this.watchDog.stop();
                this.proxy.removeHandler(this);
                this.s.shutdownOutput();
                this.s.close();
            }
        }
        catch (Exception ex) {
            _logger.error((Object)"Error in handling http response", (Throwable)ex);
        }
    }

    public static boolean testAddress(String address) {
        address = address.toLowerCase();
        char[] hexChar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        if (address.length() != 16) {
            return false;
        }
        for (int x = 0; x < address.length(); ++x) {
            if (Arrays.binarySearch(hexChar, address.charAt(x)) >= 0) continue;
            return false;
        }
        return true;
    }
}

