/*
 * Decompiled with CFR 0.152.
 */
package ants.p2p.query;

import ants.p2p.Message;
import ants.p2p.MessageWrapper;
import ants.p2p.Router;
import ants.p2p.query.QueryNode;
import ants.p2p.query.security.PublicHeader;
import ants.p2p.utils.misc.Random;
import java.util.ArrayList;

public class QueryMessage
extends Message {
    QueryNode query;
    ArrayList tuples;
    PublicHeader ph;
    boolean processed = false;
    Random rnd = new Random(System.currentTimeMillis());
    long localQueryId;
    private static long localQueryIDCounter = (long)Math.floor(Math.random() * 1.0E8);

    public QueryMessage(Message m, QueryNode query, PublicHeader ph) {
        super(m);
        this.tuples = new ArrayList();
        this.ph = ph;
        this.query = query;
        this.localQueryId = QueryMessage.nextLocalQueryID();
        this.initializeRnd();
    }

    public QueryMessage(QueryMessage qm) {
        super(qm);
        this.tuples = (ArrayList)qm.tuples.clone();
        this.ph = qm.ph;
        this.query = qm.query;
        this.localQueryId = qm.localQueryId;
        this.rnd = qm.rnd;
    }

    public QueryMessage(QueryNode query, PublicHeader ph) {
        this.tuples = new ArrayList();
        this.ph = ph;
        this.query = query;
        this.localQueryId = QueryMessage.nextLocalQueryID();
        this.initializeRnd();
    }

    public void setNewDest(String newDest) {
        this.dest = newDest;
    }

    public QueryNode getQuery() {
        return this.query;
    }

    private void initializeRnd() {
        for (int x = 0; x < Router.initialRounds; ++x) {
            this.rnd.nextDouble();
        }
    }

    public double getNextRandomDouble() {
        return this.rnd.nextDouble();
    }

    public double getNextRandomDoubleAndRollback() {
        long oldSeed = this.rnd.getSeed();
        double temp = this.rnd.nextDouble();
        this.rnd.setSeed(oldSeed);
        return temp;
    }

    public ArrayList getTuples() {
        return this.tuples;
    }

    public void resetTuples() {
        this.tuples = new ArrayList();
    }

    public PublicHeader getPublicHeader() {
        return this.ph;
    }

    public void setProcessed() {
        this.processed = true;
    }

    public boolean getProcessed() {
        return this.processed;
    }

    public long getLocalQueryId() {
        return this.localQueryId;
    }

    public static long nextLocalQueryID() {
        return localQueryIDCounter++;
    }

    public Message getSignableMessage() {
        try {
            QueryMessage signable = (QueryMessage)super.getSignableMessage();
            signable.rnd = null;
            signable.dest = null;
            return signable;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean equals(Object o) {
        if (o instanceof MessageWrapper) {
            return ((MessageWrapper)o).getMessage().getAck_Id().equals(this.getAck_Id()) && ((MessageWrapper)o).getMessage().getType() == this.getType() && ((MessageWrapper)o).getMessage().getDest() == this.getDest();
        }
        try {
            return ((Message)o).getAck_Id().equals(this.getAck_Id()) && ((Message)o).getType() == this.getType() && ((Message)o).getDest() == this.getDest();
        }
        catch (ClassCastException e) {
            return o == this;
        }
    }
}

