/*
 * Decompiled with CFR 0.152.
 */
package ants.p2p.security.sockets;

import ants.p2p.Ant;
import ants.p2p.security.sockets.SSLProvider;
import ants.p2p.security.sockets.SecureClientSocket;
import ants.p2p.security.sockets.SecureClientSocketThread;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import javax.crypto.Cipher;

public class SecureP2PClientSocket
implements SecureClientSocket {
    SecureClientSocketThread localThread;
    Socket socket;
    int localServerPort;
    boolean newVersionDetected = false;
    String newerVersion = Ant.getVersion();

    public SecureP2PClientSocket(String remoteAddress, int remotePort, int localServerPort, boolean proxied) throws Exception {
        this.socket = SSLProvider.getSSLSecuredSocket(InetAddress.getByName(remoteAddress).getHostAddress(), remotePort, proxied);
        this.socket.getOutputStream().write(0);
        this.socket.getOutputStream().flush();
        this.localServerPort = localServerPort;
        this.localThread = new SecureClientSocketThread(this);
        this.socket.setSoTimeout(60000);
        this.localThread.run();
        if (!this.isClosed()) {
            this.socket.setSoTimeout(180000);
        }
        if (this.localThread.isNewVersionDetected()) {
            this.newVersionDetected = true;
            this.newerVersion = this.localThread.getNewerVersion();
        }
    }

    public boolean isNewVersionDetected() {
        return this.newVersionDetected;
    }

    public String getNewerVersion() {
        return this.newerVersion;
    }

    public long getTimeElapsed() {
        return this.localThread.getTimeElapsed();
    }

    public Cipher getCipherEnc() {
        return this.localThread.getCipherEnc();
    }

    public Cipher getCipherDec() {
        return this.localThread.getCipherDec();
    }

    public int getLocalServerPort() {
        return this.localServerPort;
    }

    public void close() throws IOException {
        if (this.socket != null) {
            this.socket.close();
        }
    }

    public boolean isClosed() {
        if (this.socket != null) {
            return this.socket.isClosed();
        }
        return true;
    }

    public InputStream getInputStream() throws IOException {
        if (this.socket != null) {
            return this.socket.getInputStream();
        }
        return null;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.socket != null) {
            return this.socket.getOutputStream();
        }
        return null;
    }

    public InetAddress getInetAddress() {
        if (this.socket != null) {
            return this.socket.getInetAddress();
        }
        return null;
    }

    public int getPort() {
        if (this.socket != null) {
            return this.socket.getPort();
        }
        return -1;
    }

    public Socket getSocket() {
        return this.socket;
    }
}

