/*
 * Decompiled with CFR 0.152.
 */
package ants.p2p.security.sockets;

import ants.p2p.Ant;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.security.AlgorithmParameterGenerator;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyAgreement;
import javax.crypto.spec.DHParameterSpec;
import org.apache.log4j.Logger;

public class SecureServerSocketThread {
    public static final String cipher = "AES";
    public static final int cipherKeySize = 16;
    public static final int DHKeyExchangeBits = 512;
    static Logger _logger = Logger.getLogger((String)SecureServerSocketThread.class.getName());
    DHParameterSpec dhParamSpec;
    KeyPair serverKpair;
    KeyAgreement serverKeyAgree;
    PublicKey serverPubKey;
    PublicKey clientPubKey;
    byte[] sharedSecret;
    byte[] aesKey;
    Cipher serverCipherEnc;
    Cipher serverCipherDec;
    int remoteServerPort;
    Socket localSocket;
    InputStream socketInputStream;
    OutputStream socketOutputStream;
    CipherInputStream cipherSocketInputStream;
    CipherOutputStream cipherSocketOutputStream;
    boolean newVersionDetected = false;
    String newerVersion = Ant.getVersion();
    long timeElapsed;
    int pingSize = 32;

    public SecureServerSocketThread(Socket localSocket) throws IOException, NoSuchAlgorithmException, InvalidParameterSpecException, InvalidAlgorithmParameterException, InvalidKeyException {
        this.localSocket = localSocket;
        this.localSocket.setSoTimeout(60000);
        this.run();
        if (!this.localSocket.isClosed()) {
            this.localSocket.setSoTimeout(180000);
        }
    }

    private void generateDHParameters() throws IOException, NoSuchAlgorithmException, InvalidParameterSpecException, InvalidAlgorithmParameterException, InvalidKeyException {
        AlgorithmParameterGenerator paramGen = AlgorithmParameterGenerator.getInstance("DH");
        paramGen.init(512);
        AlgorithmParameters params = paramGen.generateParameters();
        this.dhParamSpec = (DHParameterSpec)params.getParameterSpec(DHParameterSpec.class);
        KeyPairGenerator serverKpairGen = KeyPairGenerator.getInstance("DH");
        serverKpairGen.initialize(this.dhParamSpec);
        this.serverKpair = serverKpairGen.generateKeyPair();
        this.serverKeyAgree = KeyAgreement.getInstance("DH");
        this.serverKeyAgree.init(this.serverKpair.getPrivate());
        this.serverPubKey = this.serverKpair.getPublic();
    }

    public void run() {
        try {
            this.socketInputStream = this.localSocket.getInputStream();
            this.socketOutputStream = this.localSocket.getOutputStream();
            ObjectOutputStream keyAgreementOutStream = new ObjectOutputStream(this.socketOutputStream);
            ObjectInputStream keyAgreementInStream = new ObjectInputStream(this.socketInputStream);
            String protocolVersion = (String)keyAgreementInStream.readObject();
            keyAgreementOutStream.writeObject(Ant.getProtocolVersion());
            if (!protocolVersion.equals(Ant.getProtocolVersion())) {
                if (!protocolVersion.startsWith("beta") && protocolVersion.compareTo(Ant.getProtocolVersion()) > 0) {
                    this.newVersionDetected = true;
                    this.newerVersion = "Protocol update: " + protocolVersion;
                }
                this.localSocket.close();
                return;
            }
            String applicationName = (String)keyAgreementInStream.readObject();
            if (applicationName.equals(Ant.getApplicationName())) {
                String version = (String)keyAgreementInStream.readObject();
                if (!version.equals(Ant.getVersion()) && version.compareTo(Ant.getVersion()) > 0) {
                    this.newVersionDetected = true;
                    this.newerVersion = version;
                }
            } else {
                keyAgreementInStream.readObject();
            }
            keyAgreementOutStream.writeObject(Ant.getApplicationName());
            keyAgreementOutStream.writeObject(Ant.getVersion());
            this.remoteServerPort = keyAgreementInStream.readInt();
            long startProbe = System.currentTimeMillis();
            keyAgreementInStream.readObject();
            this.timeElapsed = System.currentTimeMillis() - startProbe;
            keyAgreementOutStream.writeObject(new byte[this.pingSize]);
        }
        catch (Exception e) {
            try {
                this.localSocket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            _logger.info((Object)("Secure server connection failed with: " + this.localSocket.getInetAddress() + ":" + this.localSocket.getPort() + " " + e.getMessage()), (Throwable)e);
            _logger.debug((Object)"Secure server connection failed", (Throwable)e);
        }
    }

    public long getTimeElapsed() {
        return this.timeElapsed;
    }

    public Cipher getCipherEnc() {
        return this.serverCipherEnc;
    }

    public Cipher getCipherDec() {
        return this.serverCipherDec;
    }

    public Socket getSocket() {
        return this.localSocket;
    }

    public int getRemoteServerPort() {
        return this.remoteServerPort;
    }

    public boolean isNewVersionDetected() {
        return this.newVersionDetected;
    }

    public String getNewerVersion() {
        return this.newerVersion;
    }
}

