/*
 * Decompiled with CFR 0.152.
 */
package ants.p2p.utils.donkey;

import java.nio.ByteBuffer;
import java.util.BitSet;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Convert {
    static final char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static final byte[] ipStringToBytes(String ipString) {
        Pattern ipRegex = Pattern.compile("\\A(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\z");
        Matcher ipMatcher = ipRegex.matcher(ipString);
        if (!ipMatcher.matches()) {
            return null;
        }
        byte[] result = new byte[4];
        for (int i = 0; i < 4; ++i) {
            String tmp = ipMatcher.group(i + 1);
            Integer itmp = new Integer(tmp);
            result[i] = Convert.intToByte(itmp);
        }
        return result;
    }

    public static final byte[] hexStringToBytes(String hexString) {
        byte[] bytes = new byte[hexString.length() / 2];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = Convert.hexToByte(hexString, i * 2);
        }
        return bytes;
    }

    public static final StringBuffer appendHexDigit(StringBuffer sb, byte b) {
        sb.append(hexChars[(b & 0xF0) >>> 4]);
        sb.append(hexChars[b & 0xF]);
        return sb;
    }

    public static final void appendAsHex(StringBuffer sb, byte[] data) {
        for (int c = 0; c < data.length; ++c) {
            Convert.appendHexDigit(sb, data[c]);
        }
    }

    public static final void appendAsHex(StringBuffer sb, Byte[] data) {
        for (int c = 0; c < data.length; ++c) {
            Convert.appendHexDigit(sb, data[c]);
        }
    }

    public static final void appendAsHex(StringBuffer sb, ByteBuffer data) {
        int pos = data.position();
        while (data.remaining() > 0) {
            Convert.appendHexDigit(sb, data.get());
        }
        data.position(pos);
    }

    public static final String byteToHex(byte b) {
        return Convert.appendHexDigit(new StringBuffer(), b).toString();
    }

    public static final String bytesToHexString(byte[] data) {
        StringBuffer sb = new StringBuffer(data.length * 2);
        Convert.appendAsHex(sb, data);
        return sb.toString();
    }

    public static final String bytesToHexString(Byte[] data) {
        StringBuffer sb = new StringBuffer(data.length * 2);
        Convert.appendAsHex(sb, data);
        return sb.toString();
    }

    public static final String byteBufferToHexString(ByteBuffer data) {
        return Convert.byteBufferToHexString(data, data.position(), data.limit());
    }

    public static final String byteBufferToHexString(ByteBuffer data, int offset, int length) {
        if (offset >= data.capacity()) {
            return "";
        }
        StringBuffer sb = new StringBuffer(length * 2);
        int pos = data.position();
        data.position(offset);
        int limit = data.limit();
        data.limit(offset + length);
        for (length = length + offset > data.capacity() ? data.capacity() - offset : length; length > 0 && data.hasRemaining(); --length) {
            Convert.appendHexDigit(sb, data.get());
        }
        data.limit(limit);
        data.position(pos);
        return sb.toString();
    }

    public static final byte hexToByte(String hex, int pos) {
        int erg = 0;
        hex = hex.toUpperCase();
        for (int j = 0; j < 2; ++j) {
            for (int i = 0; i < 16; ++i) {
                if (hex.charAt(pos + 1 - j) != hexChars[i]) continue;
                erg += i * (int)Math.pow(16.0, j);
            }
        }
        return Convert.intToByte(erg);
    }

    public static final boolean stringToBoolean(String str) {
        return str.equalsIgnoreCase("true") || str.toLowerCase().startsWith("true") || str.equalsIgnoreCase("yes") || str.toLowerCase().startsWith("yes") || str.equals("1");
    }

    public static final BitSet bytesToBitset(byte[] buffer, int pos, int length) {
        int nbits = length * 8;
        BitSet result = new BitSet(nbits);
        if (pos + length > buffer.length) {
            System.out.println("ERROR in bytesToBitset.");
            return result;
        }
        for (int i = 0; i < length; ++i) {
            byte b = buffer[i + pos];
            for (int j = 0; j < 8; ++j) {
                if ((b & 1 << j) == 0) continue;
                result.set((i << 3) + j);
            }
        }
        return result;
    }

    public static final void bitSetToBytes(BitSet bitSet, byte[] bytes, int pos) {
        for (int i = 0; i < bitSet.length(); ++i) {
            if (!bitSet.get(i)) continue;
            int n = i / 8 + pos;
            bytes[n] = (byte)(bytes[n] | 1 << i % 8);
        }
    }

    public static final byte[] bitSetToBytes(BitSet bitSet, int realsize) {
        byte[] bytes = null;
        if (bitSet.length() <= realsize) {
            bytes = new byte[(realsize + 7) / 8];
            Convert.bitSetToBytes(bitSet, bytes, 0);
        } else {
            bytes = new byte[(bitSet.size() + 7) / 8];
            Convert.bitSetToBytes(bitSet, bytes, 0);
        }
        return bytes;
    }

    public static final int byteToInt(byte myByte) {
        return myByte & 0xFF;
    }

    public static final byte intToByte(int value) {
        return (byte)(value & 0xFF);
    }

    public static final byte[] intArrayToBytes(int[] iarray) {
        byte[] buffer = new byte[iarray.length];
        for (int i = 0; i < iarray.length; ++i) {
            buffer[i] = Convert.intToByte(iarray[i]);
        }
        return buffer;
    }

    public static final int[] unsingedByteArrayToInts(byte[] barray) {
        int[] buffer = new int[barray.length];
        for (int i = 0; i < barray.length; ++i) {
            buffer[i] = Convert.byteToInt(barray[i]);
        }
        return buffer;
    }

    public static final String intArrayToIpString(int[] iarray) {
        String ip = "";
        for (int i = 0; i < 4; ++i) {
            ip = ip + Integer.toString(iarray[i]);
            if (i == 3) continue;
            ip = ip + ".";
        }
        return ip;
    }

    public static final String byteArrayToIpString(byte[] barray) {
        int[] iarray = Convert.unsingedByteArrayToInts(barray);
        return Convert.intArrayToIpString(iarray);
    }

    public static final long unsingedByteToLong(byte b) {
        return b < 0 ? (long)b & 0xFFL : (long)b;
    }

    public static final long unsignedIntToLong(int i) {
        return i < 0 ? (long)i & 0xFFFFFFFFL : (long)i;
    }

    public static final int unsignedShortToInt(short i) {
        return i < 0 ? i & 0xFFFF : i;
    }

    public static final Locale parseLocale(String localeAsStr) {
        return new Locale(localeAsStr);
    }
}

