/*
 * Decompiled with CFR 0.152.
 */
package ants.p2p.utils.indexer;

import ants.p2p.query.QueryFileTuple;
import ants.p2p.query.QueryRemoteFileTuple;
import ants.p2p.utils.indexer.FileInfos;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;

public class RemoteFileInfos
implements Serializable {
    String hash;
    String ed2kFileHash;
    String name;
    String extendedInfos;
    Hashtable owners = new Hashtable();
    long size;
    private final boolean marker = false;

    public RemoteFileInfos(QueryFileTuple qft) {
        long lastTimeSeen = 0L;
        if (!(qft instanceof QueryRemoteFileTuple)) {
            lastTimeSeen = System.currentTimeMillis();
            this.extendedInfos = qft.getExtendedInfos();
        } else {
            QueryRemoteFileTuple qrft = (QueryRemoteFileTuple)qft;
            lastTimeSeen = qrft.getLastTimeSeen();
            this.extendedInfos = qft.getExtendedInfos();
        }
        this.owners.put(qft.getOwnerID(), new Long(lastTimeSeen));
        this.hash = qft.getFileHash();
        this.ed2kFileHash = qft.getED2KFileHash();
        this.name = qft.getFileName();
        this.size = qft.getSize();
    }

    public String getName() {
        return this.name;
    }

    public String getHash() {
        return this.hash;
    }

    public Hashtable getOwners() {
        return this.owners;
    }

    public boolean hasSources(long timeOut) {
        Enumeration sources = this.owners.keys();
        while (sources.hasMoreElements()) {
            String sourceHash = (String)sources.nextElement();
            Long sourceLastTimeSeen = (Long)this.owners.get(sourceHash);
            if (System.currentTimeMillis() - sourceLastTimeSeen <= timeOut) continue;
            this.owners.remove(sourceHash);
        }
        return this.owners.size() != 0;
    }

    public String getED2KFileHash() {
        return this.ed2kFileHash;
    }

    public long getSize() {
        return this.size;
    }

    public boolean equals(Object o) {
        if (o instanceof RemoteFileInfos) {
            return ((RemoteFileInfos)o).hash.equals(this.hash);
        }
        if (o instanceof FileInfos) {
            return ((FileInfos)o).getHash().equals(this.hash);
        }
        if (o instanceof String) {
            return ((String)o).equals(this.hash);
        }
        return this == o;
    }

    public String getExtendedInfos() {
        return this.extendedInfos;
    }
}

