/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.upnp.ssdp;

import java.net.InetAddress;
import org.cybergarage.http.HTTPRequest;
import org.cybergarage.net.HostInterface;
import org.cybergarage.upnp.ControlPoint;
import org.cybergarage.upnp.ssdp.HTTPMUSocket;
import org.cybergarage.upnp.ssdp.SSDP;
import org.cybergarage.upnp.ssdp.SSDPNotifyRequest;
import org.cybergarage.upnp.ssdp.SSDPPacket;
import org.cybergarage.util.Debug;

public class SSDPNotifySocket
extends HTTPMUSocket
implements Runnable {
    private boolean useIPv6Address;
    private ControlPoint controlPoint = null;
    private Thread deviceNotifyThread = null;

    public SSDPNotifySocket(String bindAddr) {
        String addr = "239.255.255.250";
        this.useIPv6Address = false;
        if (HostInterface.isIPv6Address(bindAddr)) {
            addr = SSDP.getIPv6Address();
            this.useIPv6Address = true;
        }
        this.open(addr, 1900, bindAddr);
        this.setControlPoint(null);
    }

    public void setControlPoint(ControlPoint ctrlp) {
        this.controlPoint = ctrlp;
    }

    public ControlPoint getControlPoint() {
        return this.controlPoint;
    }

    public boolean post(SSDPNotifyRequest req) {
        String ssdpAddr = "239.255.255.250";
        if (this.useIPv6Address) {
            ssdpAddr = SSDP.getIPv6Address();
        }
        req.setHost(ssdpAddr, 1900);
        return this.post((HTTPRequest)req);
    }

    public void run() {
        Thread thisThread = Thread.currentThread();
        ControlPoint ctrlPoint = this.getControlPoint();
        while (this.deviceNotifyThread == thisThread) {
            InetAddress pmaddr;
            Thread.yield();
            SSDPPacket packet = this.receive();
            if (packet == null) continue;
            InetAddress maddr = this.getMulticastInetAddress();
            if (!maddr.equals(pmaddr = packet.getHostInetAddress())) {
                Debug.warning("Invalidate Multicast Recieved : " + maddr + "," + pmaddr);
                continue;
            }
            if (ctrlPoint == null) continue;
            ctrlPoint.notifyReceived(packet);
        }
    }

    public void start() {
        this.deviceNotifyThread = new Thread(this);
        this.deviceNotifyThread.start();
    }

    public void stop() {
        this.close();
        this.deviceNotifyThread = null;
    }
}

