/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERSet;

public abstract class ASN1Set
extends DERObject {
    protected Vector set = new Vector();

    protected void addObject(DEREncodable obj) {
        this.set.addElement(obj);
    }

    abstract void encode(DEROutputStream var1) throws IOException;

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ASN1Set)) {
            return false;
        }
        ASN1Set other = (ASN1Set)o;
        if (this.size() != other.size()) {
            return false;
        }
        Enumeration s1 = this.getObjects();
        Enumeration s2 = other.getObjects();
        while (s1.hasMoreElements()) {
            if (s1.nextElement().equals(s2.nextElement())) continue;
            return false;
        }
        return true;
    }

    private byte[] getEncoded(DEREncodable obj) {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        ASN1OutputStream aOut = new ASN1OutputStream(bOut);
        try {
            aOut.writeObject(obj);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("cannot encode object added to SET");
        }
        return bOut.toByteArray();
    }

    public static ASN1Set getInstance(ASN1TaggedObject obj, boolean explicit) {
        if (explicit) {
            if (!obj.isExplicit()) {
                throw new IllegalArgumentException("object implicit - explicit expected.");
            }
            return (ASN1Set)obj.getObject();
        }
        if (obj.isExplicit()) {
            DERSet set = new DERSet(obj.getObject());
            return set;
        }
        if (obj.getObject() instanceof ASN1Set) {
            return (ASN1Set)obj.getObject();
        }
        ASN1EncodableVector v = new ASN1EncodableVector();
        if (obj.getObject() instanceof ASN1Sequence) {
            ASN1Sequence s = (ASN1Sequence)obj.getObject();
            Enumeration e = s.getObjects();
            while (e.hasMoreElements()) {
                v.add((DEREncodable)e.nextElement());
            }
            return new DERSet(v);
        }
        throw new IllegalArgumentException("unknown object in getInstanceFromTagged");
    }

    public static ASN1Set getInstance(Object obj) {
        if (obj == null || obj instanceof ASN1Set) {
            return (ASN1Set)obj;
        }
        throw new IllegalArgumentException("unknown object in getInstance");
    }

    public DEREncodable getObjectAt(int index) {
        return (DEREncodable)this.set.elementAt(index);
    }

    public Enumeration getObjects() {
        return this.set.elements();
    }

    public int hashCode() {
        Enumeration e = this.getObjects();
        int hashCode = 0;
        while (e.hasMoreElements()) {
            hashCode ^= e.nextElement().hashCode();
        }
        return hashCode;
    }

    private boolean lessThanOrEqual(byte[] a, byte[] b) {
        if (a.length <= b.length) {
            int i = 0;
            while (i != a.length) {
                int r = b[i] & 0xFF;
                int l = a[i] & 0xFF;
                if (r > l) {
                    return true;
                }
                if (l > r) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        int i = 0;
        while (i != b.length) {
            int r = b[i] & 0xFF;
            int l = a[i] & 0xFF;
            if (r > l) {
                return true;
            }
            if (l > r) {
                return false;
            }
            ++i;
        }
        return false;
    }

    public int size() {
        return this.set.size();
    }

    protected void sort() {
        if (this.set.size() > 1) {
            boolean swapped = true;
            while (swapped) {
                int index = 0;
                byte[] a = this.getEncoded((DEREncodable)this.set.elementAt(0));
                swapped = false;
                while (index != this.set.size() - 1) {
                    byte[] b = this.getEncoded((DEREncodable)this.set.elementAt(index + 1));
                    if (this.lessThanOrEqual(a, b)) {
                        a = b;
                    } else {
                        Object o = this.set.elementAt(index);
                        this.set.setElementAt(this.set.elementAt(index + 1), index);
                        this.set.setElementAt(o, index + 1);
                        swapped = true;
                    }
                    ++index;
                }
            }
        }
    }
}

