/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROutputStream;

public class DERApplicationSpecific
extends DERObject {
    private byte[] octets;
    private int tag;

    public DERApplicationSpecific(int tag, DEREncodable object) throws IOException {
        this.tag = tag | 0x20;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DEROutputStream dos = new DEROutputStream(baos);
        dos.writeObject(object);
        this.octets = baos.toByteArray();
    }

    public DERApplicationSpecific(int tag, byte[] octets) {
        this.tag = tag;
        this.octets = octets;
    }

    void encode(DEROutputStream out) throws IOException {
        out.writeEncoded(0x40 | this.tag, this.octets);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof DERApplicationSpecific)) {
            return false;
        }
        DERApplicationSpecific other = (DERApplicationSpecific)o;
        if (this.tag != other.tag) {
            return false;
        }
        if (this.octets.length != other.octets.length) {
            return false;
        }
        int i = 0;
        while (i < this.octets.length) {
            if (this.octets[i] != other.octets[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int getApplicationTag() {
        return this.tag & 0x1F;
    }

    public byte[] getContents() {
        return this.octets;
    }

    public DERObject getObject() throws IOException {
        return new ASN1InputStream(new ByteArrayInputStream(this.getContents())).readObject();
    }

    public int hashCode() {
        byte[] b = this.getContents();
        int value = 0;
        int i = 0;
        while (i != b.length) {
            value ^= (b[i] & 0xFF) << i % 4;
            ++i;
        }
        return value ^ this.getApplicationTag();
    }

    public boolean isConstructed() {
        return (this.tag & 0x20) != 0;
    }
}

