/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.BERInputStream;
import org.bouncycastle.asn1.DERBMPString;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERBoolean;
import org.bouncycastle.asn1.DERConstructedSequence;
import org.bouncycastle.asn1.DERConstructedSet;
import org.bouncycastle.asn1.DEREnumerated;
import org.bouncycastle.asn1.DERGeneralString;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERT61String;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DERTags;
import org.bouncycastle.asn1.DERUTCTime;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.DERUniversalString;
import org.bouncycastle.asn1.DERUnknownTag;
import org.bouncycastle.asn1.DERVisibleString;

public class DERInputStream
extends FilterInputStream
implements DERTags {
    public DERInputStream(InputStream is) {
        super(is);
    }

    protected DERObject buildObject(int tag, byte[] bytes) throws IOException {
        switch (tag) {
            case 5: {
                return null;
            }
            case 48: {
                ByteArrayInputStream bIn = new ByteArrayInputStream(bytes);
                BERInputStream dIn = new BERInputStream(bIn);
                DERConstructedSequence seq = new DERConstructedSequence();
                try {
                    while (true) {
                        DERObject obj = dIn.readObject();
                        seq.addObject(obj);
                    }
                }
                catch (EOFException ex) {
                    return seq;
                }
            }
            case 49: {
                ByteArrayInputStream bIn = new ByteArrayInputStream(bytes);
                BERInputStream dIn = new BERInputStream(bIn);
                ASN1EncodableVector v = new ASN1EncodableVector();
                try {
                    while (true) {
                        DERObject obj = dIn.readObject();
                        v.add(obj);
                    }
                }
                catch (EOFException ex) {
                    return new DERConstructedSet(v);
                }
            }
            case 1: {
                return new DERBoolean(bytes);
            }
            case 2: {
                return new DERInteger(bytes);
            }
            case 10: {
                return new DEREnumerated(bytes);
            }
            case 6: {
                return new DERObjectIdentifier(bytes);
            }
            case 3: {
                byte padBits = bytes[0];
                byte[] data = new byte[bytes.length - 1];
                System.arraycopy(bytes, 1, data, 0, bytes.length - 1);
                return new DERBitString(data, (int)padBits);
            }
            case 12: {
                return new DERUTF8String(bytes);
            }
            case 19: {
                return new DERPrintableString(bytes);
            }
            case 22: {
                return new DERIA5String(bytes);
            }
            case 20: {
                return new DERT61String(bytes);
            }
            case 26: {
                return new DERVisibleString(bytes);
            }
            case 28: {
                return new DERUniversalString(bytes);
            }
            case 27: {
                return new DERGeneralString(bytes);
            }
            case 30: {
                return new DERBMPString(bytes);
            }
            case 4: {
                return new DEROctetString(bytes);
            }
            case 23: {
                return new DERUTCTime(bytes);
            }
            case 24: {
                return new DERGeneralizedTime(bytes);
            }
        }
        if ((tag & 0x80) != 0) {
            if ((tag & 0x1F) == 31) {
                throw new IOException("unsupported high tag encountered");
            }
            if (bytes.length == 0) {
                if ((tag & 0x20) == 0) {
                    return new DERTaggedObject(false, tag & 0x1F, new DERNull());
                }
                return new DERTaggedObject(false, tag & 0x1F, new DERConstructedSequence());
            }
            if ((tag & 0x20) == 0) {
                return new DERTaggedObject(false, tag & 0x1F, new DEROctetString(bytes));
            }
            ByteArrayInputStream bIn = new ByteArrayInputStream(bytes);
            BERInputStream dIn = new BERInputStream(bIn);
            DERObject dObj = dIn.readObject();
            if (dIn.available() == 0) {
                return new DERTaggedObject(tag & 0x1F, dObj);
            }
            DERConstructedSequence seq = new DERConstructedSequence();
            seq.addObject(dObj);
            try {
                while (true) {
                    dObj = dIn.readObject();
                    seq.addObject(dObj);
                }
            }
            catch (EOFException ex) {
                return new DERTaggedObject(false, tag & 0x1F, seq);
            }
        }
        return new DERUnknownTag(tag, bytes);
    }

    /*
     * Unable to fully structure code
     */
    protected void readFully(byte[] bytes) throws IOException {
        left = bytes.length;
        if (left != 0) ** GOTO lbl9
        return;
lbl-1000:
        // 1 sources

        {
            l = this.read(bytes, bytes.length - left, left);
            if (l < 0) {
                throw new EOFException("unexpected end of stream");
            }
            left -= l;
lbl9:
            // 2 sources

            ** while (left > 0)
        }
lbl10:
        // 1 sources

    }

    protected int readLength() throws IOException {
        int length = this.read();
        if (length < 0) {
            throw new IOException("EOF found when length expected");
        }
        if (length == 128) {
            return -1;
        }
        if (length > 127) {
            int size = length & 0x7F;
            if (size > 4) {
                throw new IOException("DER length more than 4 bytes");
            }
            length = 0;
            int i = 0;
            while (i < size) {
                int next = this.read();
                if (next < 0) {
                    throw new IOException("EOF found reading length");
                }
                length = (length << 8) + next;
                ++i;
            }
            if (length < 0) {
                throw new IOException("corrupted steam - negative length found");
            }
        }
        return length;
    }

    public DERObject readObject() throws IOException {
        int tag = this.read();
        if (tag == -1) {
            throw new EOFException();
        }
        int length = this.readLength();
        byte[] bytes = new byte[length];
        this.readFully(bytes);
        return this.buildObject(tag, bytes);
    }
}

