/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERString;

public class DERNumericString
extends DERObject
implements DERString {
    String string;

    public DERNumericString(String string) {
        this.string = string;
    }

    public DERNumericString(byte[] string) {
        char[] cs = new char[string.length];
        int i = 0;
        while (i != cs.length) {
            cs[i] = (char)(string[i] & 0xFF);
            ++i;
        }
        this.string = new String(cs);
    }

    void encode(DEROutputStream out) throws IOException {
        out.writeEncoded(18, this.getOctets());
    }

    public boolean equals(Object o) {
        if (!(o instanceof DERNumericString)) {
            return false;
        }
        DERNumericString s = (DERNumericString)o;
        return this.getString().equals(s.getString());
    }

    public static DERNumericString getInstance(ASN1TaggedObject obj, boolean explicit) {
        return DERNumericString.getInstance(obj.getObject());
    }

    public static DERNumericString getInstance(Object obj) {
        if (obj == null || obj instanceof DERNumericString) {
            return (DERNumericString)obj;
        }
        if (obj instanceof ASN1OctetString) {
            return new DERNumericString(((ASN1OctetString)obj).getOctets());
        }
        if (obj instanceof ASN1TaggedObject) {
            return DERNumericString.getInstance(((ASN1TaggedObject)obj).getObject());
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public byte[] getOctets() {
        char[] cs = this.string.toCharArray();
        byte[] bs = new byte[cs.length];
        int i = 0;
        while (i != cs.length) {
            bs[i] = (byte)cs[i];
            ++i;
        }
        return bs;
    }

    public String getString() {
        return this.string;
    }

    public int hashCode() {
        return this.getString().hashCode();
    }
}

