/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERSequence;

public class OtherRecipientInfo
extends ASN1Encodable {
    private DERObjectIdentifier oriType;
    private DEREncodable oriValue;

    public OtherRecipientInfo(ASN1Sequence seq) {
        this.oriType = DERObjectIdentifier.getInstance(seq.getObjectAt(1));
        this.oriValue = seq.getObjectAt(2);
    }

    public OtherRecipientInfo(DERObjectIdentifier oriType, DEREncodable oriValue) {
        this.oriType = oriType;
        this.oriValue = oriValue;
    }

    public static OtherRecipientInfo getInstance(Object obj) {
        if (obj == null || obj instanceof OtherRecipientInfo) {
            return (OtherRecipientInfo)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new OtherRecipientInfo((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("Invalid OtherRecipientInfo: " + obj.getClass().getName());
    }

    public static OtherRecipientInfo getInstance(ASN1TaggedObject obj, boolean explicit) {
        return OtherRecipientInfo.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public DERObjectIdentifier getType() {
        return this.oriType;
    }

    public DEREncodable getValue() {
        return this.oriValue;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.oriType);
        v.add(this.oriValue);
        return new DERSequence(v);
    }
}

