/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.mozilla;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;

public class PublicKeyAndChallenge
extends ASN1Encodable {
    private DERIA5String challenge;
    private ASN1Sequence pkacSeq;
    private SubjectPublicKeyInfo spki;

    public PublicKeyAndChallenge(ASN1Sequence seq) {
        this.pkacSeq = seq;
        this.spki = SubjectPublicKeyInfo.getInstance(seq.getObjectAt(0));
        this.challenge = DERIA5String.getInstance(seq.getObjectAt(1));
    }

    public DERIA5String getChallenge() {
        return this.challenge;
    }

    public static PublicKeyAndChallenge getInstance(Object obj) {
        if (obj instanceof PublicKeyAndChallenge) {
            return (PublicKeyAndChallenge)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new PublicKeyAndChallenge((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("unkown object in factory");
    }

    public SubjectPublicKeyInfo getSubjectPublicKeyInfo() {
        return this.spki;
    }

    public DERObject toASN1Object() {
        return this.pkacSeq;
    }
}

