/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.ocsp;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.ocsp.ResponderID;
import org.bouncycastle.asn1.x509.X509Extensions;

public class ResponseData
extends ASN1Encodable {
    private DERGeneralizedTime producedAt;
    private ResponderID responderID;
    private X509Extensions responseExtensions;
    private ASN1Sequence responses;
    private DERInteger version;

    public ResponseData(ASN1Sequence seq) {
        ASN1TaggedObject o;
        int index = 0;
        this.version = seq.getObjectAt(0) instanceof ASN1TaggedObject ? ((o = (ASN1TaggedObject)seq.getObjectAt(0)).getTagNo() == 0 ? DERInteger.getInstance((ASN1TaggedObject)seq.getObjectAt(0), true) : null) : null;
        int n = ++index;
        this.responderID = ResponderID.getInstance(seq.getObjectAt(n));
        int n2 = ++index;
        this.producedAt = (DERGeneralizedTime)seq.getObjectAt(n2);
        int n3 = ++index;
        this.responses = (ASN1Sequence)seq.getObjectAt(n3);
        if (seq.size() > ++index) {
            this.responseExtensions = X509Extensions.getInstance((ASN1TaggedObject)seq.getObjectAt(index), true);
        }
    }

    public ResponseData(DERInteger version, ResponderID responderID, DERGeneralizedTime producedAt, ASN1Sequence responses, X509Extensions responseExtensions) {
        this.version = version;
        this.responderID = responderID;
        this.producedAt = producedAt;
        this.responses = responses;
        this.responseExtensions = responseExtensions;
    }

    public static ResponseData getInstance(Object obj) {
        if (obj == null || obj instanceof ResponseData) {
            return (ResponseData)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new ResponseData((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public static ResponseData getInstance(ASN1TaggedObject obj, boolean explicit) {
        return ResponseData.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public DERGeneralizedTime getProducedAt() {
        return this.producedAt;
    }

    public ResponderID getResponderID() {
        return this.responderID;
    }

    public X509Extensions getResponseExtensions() {
        return this.responseExtensions;
    }

    public ASN1Sequence getResponses() {
        return this.responses;
    }

    public DERInteger getVersion() {
        return this.version;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        if (this.version != null) {
            v.add(new DERTaggedObject(true, 0, new DERInteger(0)));
        }
        v.add(this.responderID);
        v.add(this.producedAt);
        v.add(this.responses);
        if (this.responseExtensions != null) {
            v.add(new DERTaggedObject(true, 1, this.responseExtensions));
        }
        return new DERSequence(v);
    }
}

