/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.ocsp;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.X509Extensions;

public class TBSRequest
extends ASN1Encodable {
    X509Extensions requestExtensions;
    ASN1Sequence requestList;
    GeneralName requestorName;
    DERInteger version;

    public TBSRequest(ASN1Sequence seq) {
        int index = 0;
        if (seq.getObjectAt(0) instanceof ASN1TaggedObject) {
            ASN1TaggedObject o = (ASN1TaggedObject)seq.getObjectAt(0);
            if (o.getTagNo() == 0) {
                this.version = DERInteger.getInstance((ASN1TaggedObject)seq.getObjectAt(0), true);
                ++index;
            } else {
                this.version = new DERInteger(0);
            }
        } else {
            this.version = new DERInteger(0);
        }
        if (seq.getObjectAt(index) instanceof ASN1TaggedObject) {
            this.requestorName = GeneralName.getInstance((ASN1TaggedObject)seq.getObjectAt(index++), true);
        }
        this.requestList = (ASN1Sequence)seq.getObjectAt(index++);
        if (seq.size() == index + 1) {
            this.requestExtensions = X509Extensions.getInstance((ASN1TaggedObject)seq.getObjectAt(index), true);
        }
    }

    public TBSRequest(GeneralName requestorName, ASN1Sequence requestList, X509Extensions requestExtensions) {
        this.version = new DERInteger(0);
        this.requestorName = requestorName;
        this.requestList = requestList;
        this.requestExtensions = requestExtensions;
    }

    public static TBSRequest getInstance(Object obj) {
        if (obj == null || obj instanceof TBSRequest) {
            return (TBSRequest)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new TBSRequest((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public static TBSRequest getInstance(ASN1TaggedObject obj, boolean explicit) {
        return TBSRequest.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public X509Extensions getRequestExtensions() {
        return this.requestExtensions;
    }

    public ASN1Sequence getRequestList() {
        return this.requestList;
    }

    public GeneralName getRequestorName() {
        return this.requestorName;
    }

    public DERInteger getVersion() {
        return this.version;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        if (this.version.getValue().intValue() != 0) {
            v.add(new DERTaggedObject(true, 0, this.version));
        }
        if (this.requestorName != null) {
            v.add(new DERTaggedObject(true, 1, this.requestorName));
        }
        v.add(this.requestList);
        if (this.requestExtensions != null) {
            v.add(new DERTaggedObject(true, 2, this.requestExtensions));
        }
        return new DERSequence(v);
    }
}

